/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JScrollPane;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

public class FruchtermanReingoldLayout
extends SceneLayout {
    private double forceConstant;
    private double temp;
    private int iterations = 700;
    private final int magicSizeMultiplier = 10;
    private final int magicSizeConstant = 200;
    private Rectangle bounds;
    protected int m_fidx;
    private static final double MIN = 1.0E-6;
    private static final double ALPHA = 0.1;
    private DependencyGraphScene scene;
    private JScrollPane panel;

    public FruchtermanReingoldLayout(DependencyGraphScene scene, JScrollPane panel) {
        super((Scene)scene);
        this.scene = scene;
        this.init();
        this.panel = panel;
    }

    public void performLayout() {
        this.performLayout(true);
    }

    private void performLayout(boolean finish) {
        for (int i = 0; i < this.iterations; ++i) {
            int repeats = 0;
            while (true) {
                for (ArtifactGraphNode n : this.scene.getNodes()) {
                    if (n.isFixed()) continue;
                    this.calcRepulsion(n);
                }
                for (ArtifactGraphEdge e : this.scene.getEdges()) {
                    this.calcAttraction(e);
                }
                for (ArtifactGraphNode n : this.scene.getNodes()) {
                    if (n.isFixed()) continue;
                    this.calcPositions(n);
                }
                if (this.areAllFixed() || repeats > 2) break;
                ++repeats;
            }
            this.doRelayoutNonFixed();
            this.resetFixed();
            this.cool(i);
        }
        if (finish) {
            this.finish();
        }
    }

    public void rePerformLayout(int iters) {
        int nds = this.scene.getNodes().size();
        this.iterations = iters;
        this.bounds = this.scene.getBounds();
        if (this.bounds == null) {
            return;
        }
        this.temp = this.bounds.getWidth() / 1000.0;
        this.forceConstant = 0.25 * Math.sqrt(this.bounds.getHeight() * this.bounds.getWidth() / (double)nds);
        this.performLayout(false);
    }

    private void init() {
        int nds = this.scene.getNodes().size();
        this.bounds = new Rectangle(200 + 10 * nds, 200 + 10 * nds);
        this.temp = this.bounds.getWidth() / 10.0;
        this.forceConstant = 0.75 * Math.sqrt(this.bounds.getHeight() * this.bounds.getWidth() / (double)nds);
        ArtifactGraphNode r = this.scene.getRootGraphNode();
        r.locX = this.bounds.getCenterX();
        r.locY = this.bounds.getCenterY();
        r.setFixed(true);
        this.layoutCirculary(this.scene.getNodes(), r);
    }

    private void finish() {
        for (ArtifactGraphNode n : this.scene.getNodes()) {
            Widget wid = this.scene.findWidget(n);
            Point point = new Point();
            point.setLocation(n.locX, n.locY);
            if (this.scene.isAnimated()) {
                this.scene.getSceneAnimator().animatePreferredLocation(wid, point);
                continue;
            }
            wid.setPreferredLocation(point);
        }
    }

    public void calcPositions(ArtifactGraphNode n) {
        double deltaLength = Math.max(1.0E-6, Math.sqrt(n.dispX * n.dispX + n.dispY * n.dispY));
        double xDisp = n.dispX / deltaLength * Math.min(deltaLength, this.temp);
        double yDisp = n.dispY / deltaLength * Math.min(deltaLength, this.temp);
        n.locX += xDisp;
        n.locY += yDisp;
        if (this.isThereFreeSpaceNonFixedSpace(n)) {
            n.setFixed(true);
        }
    }

    public void calcAttraction(ArtifactGraphEdge e) {
        ArtifactGraphNode n1 = (ArtifactGraphNode)this.scene.getEdgeSource(e);
        ArtifactGraphNode n2 = (ArtifactGraphNode)this.scene.getEdgeTarget(e);
        assert (n1 != null && n2 != null) : "wrong edge=" + e;
        double xDelta = n1.locX - n2.locX;
        double yDelta = n1.locX - n2.locY;
        double deltaLength = Math.max(1.0E-6, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
        double force = deltaLength * deltaLength / this.forceConstant;
        double xDisp = xDelta / deltaLength * force;
        double yDisp = yDelta / deltaLength * force;
        n1.dispX -= xDisp;
        n1.dispY -= yDisp;
        n2.dispX += xDisp;
        n2.dispY += yDisp;
    }

    public void calcRepulsion(ArtifactGraphNode n1) {
        n1.dispX = 0.0;
        n1.dispY = 0.0;
        for (ArtifactGraphNode n2 : this.scene.getNodes()) {
            if (n1 == n2) continue;
            double xDelta = n1.locX - n2.locX;
            double yDelta = n1.locY - n2.locY;
            double deltaLength = Math.max(1.0E-6, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
            double force = this.forceConstant * this.forceConstant / deltaLength;
            n1.dispX += xDelta / deltaLength * force;
            n1.dispY += yDelta / deltaLength * force;
        }
    }

    private void cool(int iter) {
        this.temp *= 1.0 - (double)iter / (double)this.iterations;
    }

    private void layoutCirculary(Collection<ArtifactGraphNode> nodes, ArtifactGraphNode master) {
        Point masterPoint = new Point();
        masterPoint.setLocation(master.locX, master.locY);
        double thetaStep = 0.6283185307179586;
        double r = 150.0;
        double theta = 0.0;
        Iterator<ArtifactGraphNode> it = nodes.iterator();
        ArtifactGraphNode nd = it.next();
        while (true) {
            AffineTransform tr;
            Point2D d2point;
            Point point;
            if (this.isThereFreeSpace(point = new Point((int)(d2point = (tr = AffineTransform.getRotateInstance(theta)).transform(new Point2D.Double(0.0, r), null)).getX() + masterPoint.x, (int)d2point.getY() + masterPoint.y), nd)) {
                nd.locX = point.getX();
                nd.locY = point.getY();
                nd.dispX = 0.0;
                nd.dispY = 0.0;
                if (it.hasNext()) {
                    nd = it.next();
                } else {
                    return;
                }
            }
            if (!((theta += thetaStep) > 5.969026041820607)) continue;
            r += 90.0;
            theta -= Math.PI * 2;
            thetaStep = thetaStep * 3.0 / 4.0;
        }
    }

    private boolean isThereFreeSpace(Point pnt, ArtifactGraphNode node) {
        Widget widget;
        if (this.scene != null && (widget = this.scene.findWidget(node)) != null) {
            Rectangle bnds = widget.getBounds();
            if (bnds == null) {
                return true;
            }
            bnds = new Rectangle(pnt.x, pnt.y, bnds.width, bnds.height);
            for (ArtifactGraphNode nd : this.scene.getNodes()) {
                Rectangle bnds2 = this.scene.findWidget(nd).getBounds();
                if (bnds2 == null) {
                    return true;
                }
                Point point = new Point();
                point.setLocation(nd.locX, nd.locY);
                if (!bnds.intersects(bnds2 = new Rectangle(point, bnds2.getSize()))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areAllFixed() {
        for (ArtifactGraphNode nd : this.scene.getNodes()) {
            if (nd.isFixed()) continue;
            return false;
        }
        return true;
    }

    private void resetFixed() {
        for (ArtifactGraphNode nd : this.scene.getNodes()) {
            nd.setFixed(false);
        }
        this.scene.getRootGraphNode().setFixed(true);
    }

    private boolean isThereFreeSpaceNonFixedSpace(ArtifactGraphNode node) {
        Rectangle bnds = this.scene.findWidget(node).getBounds();
        if (bnds == null) {
            return true;
        }
        Point pnt = new Point();
        pnt.setLocation(node.locX, node.locY);
        bnds = new Rectangle(pnt, bnds.getSize());
        for (ArtifactGraphNode nd : this.scene.getNodes()) {
            Rectangle bnds2 = this.scene.findWidget(nd).getBounds();
            if (bnds2 == null) {
                return true;
            }
            Point point = new Point();
            point.setLocation(nd.locX, nd.locY);
            bnds2 = new Rectangle(point, bnds2.getSize());
            if (!nd.isFixed() || !bnds.intersects(bnds2)) continue;
            return false;
        }
        return true;
    }

    private void doRelayoutNonFixed() {
        for (ArtifactGraphNode node : this.scene.getNodes()) {
            if (node.isFixed()) continue;
            this.relayoutNonFixed(node);
        }
    }

    private void relayoutNonFixed(ArtifactGraphNode node) {
        Point masterPoint = new Point();
        masterPoint.setLocation(node.locX, node.locY);
        double thetaStep = 0.6283185307179586;
        double r = 30.0;
        double theta = 0.0;
        node.setFixed(false);
        while (true) {
            AffineTransform tr = AffineTransform.getRotateInstance(theta);
            Point2D d2point = tr.transform(new Point2D.Double(0.0, r), null);
            Point point = new Point((int)d2point.getX() + masterPoint.x, (int)d2point.getY() + masterPoint.y);
            node.locX = point.getX();
            node.locY = point.getY();
            if (this.isThereFreeSpaceNonFixedSpace(node)) {
                node.setFixed(true);
                return;
            }
            if (!((theta += thetaStep) > 5.969026041820607)) continue;
            r += 30.0;
            theta -= Math.PI * 2;
            thetaStep = thetaStep * 3.0 / 4.0;
        }
    }
}

