/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.api.VerificationWarningOverrider;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitPresent {
    public static ErrorDescription apply(HintContext hc) {
        PersistenceScope[] scopes;
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)hc.getInfo().getFileObject());
        if (project == null) {
            return null;
        }
        for (PersistenceScope scope : scopes = PersistenceUtils.getPersistenceScopes((Project)project)) {
            if (!scope.getClassPath().contains(hc.getInfo().getFileObject())) continue;
            try {
                PersistenceUnit[] pus;
                FileObject persistenceXML = scope.getPersistenceXml();
                if (persistenceXML == null || (pus = PersistenceMetadata.getDefault().getRoot(persistenceXML).getPersistenceUnit()) == null || pus.length <= 0) continue;
                return null;
            }
            catch (IOException | RuntimeException e) {
                JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        for (VerificationWarningOverrider wo : project.getLookup().lookupAll(VerificationWarningOverrider.class)) {
            if (!wo.suppressWarning("no_persitence_unit_warning")) continue;
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)hc, (TreePath)hc.getPath().getParentPath(), (String)NbBundle.getMessage(PersistenceUnitPresent.class, (String)"MSG_MissingPersistenceUnitHint"), (Fix[])new Fix[]{project.getLookup().lookup(PersistenceLocationProvider.class) == null ? null : new CreatePersistenceUnit(project)});
    }
}

