/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroCache;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class APTFileMacroMap
extends APTBaseMacroMap {
    private static final Map<CharSequence, APTMacro> NO_CACHE = Collections.unmodifiableMap(new HashMap(0));
    private static final int INITIAL_CACHE_SIZE = 512;
    private APTMacroMap sysMacroMap;
    private Map<CharSequence, APTMacro> macroCache = NO_CACHE;
    private int crc1 = 0;
    private int crc2 = 0;
    private final LinkedList<CharSequence> expandingMacros = new LinkedList();
    private final HashSet<CharSequence> expandingMacroIDs = new HashSet();
    private boolean afterPPDefinedKeyword = false;
    private static final APTMacroCache cache = APTMacroCache.getManager();

    public APTFileMacroMap() {
    }

    public APTFileMacroMap(APTMacroMap sysMacroMap, List<String> userMacros) {
        if (sysMacroMap == null) {
            sysMacroMap = APTBaseMacroMap.EMPTY;
        }
        this.sysMacroMap = sysMacroMap;
        this.macroCache = new HashMap<CharSequence, APTMacro>(512);
        this.fill(userMacros, false);
    }

    @Override
    public boolean isDefined(CharSequence token) {
        token = CharSequences.create((CharSequence)token);
        this.initCache();
        APTMacro res = this.macroCache.get(token);
        if (res == APTMacroMapSnapshot.UNDEFINED_MACRO) {
            return false;
        }
        if (res != null) {
            return true;
        }
        if (this.sysMacroMap != null) {
            return this.sysMacroMap.isDefined(token);
        }
        return false;
    }

    @Override
    public APTMacro getMacro(APTToken token) {
        CharSequence macroText = token.getTextID();
        this.initCache();
        APTMacro res = this.macroCache.get(macroText);
        if (res == null) {
            if (this.sysMacroMap != null) {
                res = this.sysMacroMap.getMacro(token);
            }
            if (res == null) {
                res = APTMacroMapSnapshot.UNDEFINED_MACRO;
            }
            if (res.getKind() != APTMacro.Kind.POSITION_PREDEFINED) {
                this.macroCache.put(macroText, res);
            }
        }
        return res != APTMacroMapSnapshot.UNDEFINED_MACRO ? res : null;
    }

    @Override
    protected void putMacro(CharSequence name, APTMacro macro) {
        int i2;
        this.initCache();
        super.putMacro(name, macro);
        APTMacro old = this.macroCache.put(name, macro);
        int i1 = name.hashCode();
        if (old != null) {
            i2 = old.hashCode();
            this.crc1 -= i1 + i2;
            this.crc2 -= i1 ^ i2;
        }
        if (macro != APTMacroMapSnapshot.UNDEFINED_MACRO) {
            i2 = macro.hashCode();
            this.crc1 += i1 + i2;
            this.crc2 += i1 ^ i2;
        }
    }

    @Override
    protected APTMacro createMacro(CharSequence file, APTDefine define, APTMacro.Kind macroType) {
        APTMacro macro = new APTMacroImpl(file, define, macroType);
        if (APTTraceFlags.APT_SHARE_MACROS) {
            macro = cache.getMacro(macro);
        }
        return macro;
    }

    @Override
    protected APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot parent) {
        return new APTMacroMapSnapshot(parent);
    }

    @Override
    public PPMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new FileStateImpl(this.active.getParent(), this.sysMacroMap, this.crc1, this.crc2);
    }

    public long getCompilationUnitCRC() {
        long out = ((long)this.crc1 << 32) + (long)this.crc2;
        if (this.sysMacroMap instanceof APTSystemMacroMap) {
            out += ((APTSystemMacroMap)this.sysMacroMap).getCompilationUnitCRC();
        }
        return out;
    }

    @Override
    public void setState(PPMacroMap.State state) {
        this.active = this.makeSnapshot(((APTBaseMacroMap.StateImpl)state).snap);
        this.crc1 = 0;
        this.crc2 = 0;
        if (state instanceof FileStateImpl) {
            FileStateImpl fileState = (FileStateImpl)state;
            this.sysMacroMap = fileState.sysMacroMap;
            this.crc1 = fileState.crc1;
            this.crc2 = fileState.crc2;
        }
        this.macroCache = NO_CACHE;
    }

    private void initCache() {
        if (this.macroCache == NO_CACHE) {
            this.macroCache = this.active.getAll();
            if (this.crc1 == 0 && this.crc2 == 0) {
                for (Map.Entry<CharSequence, APTMacro> entry : this.macroCache.entrySet()) {
                    int i1 = entry.getKey().hashCode();
                    int i2 = entry.getValue().hashCode();
                    this.crc1 += i1 + i2;
                    this.crc2 += i1 ^ i2;
                }
            }
        }
    }

    @Override
    public boolean pushPPDefined() {
        if (this.afterPPDefinedKeyword) {
            return false;
        }
        this.afterPPDefinedKeyword = true;
        return true;
    }

    @Override
    public boolean popPPDefined() {
        if (this.afterPPDefinedKeyword) {
            this.afterPPDefinedKeyword = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean pushExpanding(APTToken token) {
        assert (token != null);
        CharSequence id = token.getTextID();
        if (!this.isExpanding(id)) {
            this.expandingMacros.addLast(id);
            this.expandingMacroIDs.add(id);
            return true;
        }
        return false;
    }

    @Override
    public void popExpanding() {
        block2: {
            try {
                CharSequence id = this.expandingMacros.removeLast();
                this.expandingMacroIDs.remove(id);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"why pop from empty stack?");
            }
        }
    }

    @Override
    public boolean isExpanding(APTToken token) {
        return this.isExpanding(token.getTextID());
    }

    private boolean isExpanding(CharSequence id) {
        return this.expandingMacroIDs.contains(id);
    }

    @Override
    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append("Own Map:\n");
        retValue.append(super.toString());
        retValue.append("System Map:\n");
        retValue.append(this.sysMacroMap);
        return retValue.toString();
    }

    public static class FileStateImpl
    extends APTBaseMacroMap.StateImpl {
        private final APTMacroMap sysMacroMap;
        private final int crc1;
        private final int crc2;

        private FileStateImpl(APTMacroMapSnapshot snap, APTMacroMap sysMacroMap, int crc1, int crc2) {
            super(snap);
            this.sysMacroMap = sysMacroMap;
            this.crc1 = crc1;
            this.crc2 = crc2;
        }

        private FileStateImpl(FileStateImpl state, boolean cleanedState) {
            super(state, cleanedState);
            this.sysMacroMap = state.sysMacroMap;
            this.crc1 = state.crc1;
            this.crc2 = state.crc2;
        }

        APTHandlersSupportImpl.StateKeyImpl getStateKey(Key startFileProject) {
            long sysCrc = 0L;
            if (this.sysMacroMap instanceof APTSystemMacroMap) {
                sysCrc = ((APTSystemMacroMap)this.sysMacroMap).getCompilationUnitCRC();
            }
            return new APTHandlersSupportImpl.StateKeyImpl(this.crc1, this.crc2, sysCrc, startFileProject);
        }

        @Override
        public String toString() {
            StringBuilder retValue = new StringBuilder();
            retValue.append("FileState\n");
            retValue.append("Snapshot\n");
            retValue.append(super.toString());
            retValue.append("\nSystem MacroMap\n");
            if (System.getProperty("cnd.apt.macro.trace") != null) {
                retValue.append(this.sysMacroMap);
            } else {
                retValue.append(System.identityHashCode(this.sysMacroMap));
            }
            return retValue.toString();
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.crc1);
            output.writeInt(this.crc2);
            APTSerializeUtils.writeSystemMacroMap(this.sysMacroMap, output);
        }

        public FileStateImpl(RepositoryDataInput input) throws IOException {
            super(input);
            this.crc1 = input.readInt();
            this.crc2 = input.readInt();
            APTMacroMap systemMap = APTSerializeUtils.readSystemMacroMap(input);
            this.sysMacroMap = systemMap == null ? APTBaseMacroMap.EMPTY : systemMap;
        }

        @Override
        public APTBaseMacroMap.StateImpl copyCleaned() {
            return new FileStateImpl(this, true);
        }
    }
}

