/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.util.Collection;
import org.clang.basic.vfs.FileSystem;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.support.ClangFileSystemProvider;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileObjectBasedFileSystem;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.Utilities;

public class ClankFileSystemProviderImpl
extends ClangFileSystemProvider {
    public static final String RFS_PREFIX = "rfs:";

    public IntrusiveRefCntPtr<FileSystem> getFileSystemImpl(ClankCompilationDataBase.Entry entry) {
        boolean useFS = APTTraceFlags.ALWAYS_USE_NB_FS || Utilities.isWindows() ? true : (this.isFullRemote(entry) ? true : this.isMixedOrSimpleRemote(entry));
        return useFS ? new IntrusiveRefCntPtr((Object)ClankFileObjectBasedFileSystem.getInstance()) : null;
    }

    private boolean isMixedOrSimpleRemote(ClankCompilationDataBase.Entry entry) {
        for (CharSequence sysIncludePath : entry.getPredefinedSystemIncludePaths()) {
            if (!CharSequenceUtils.startsWith((CharSequence)sysIncludePath, (CharSequence)RFS_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullRemote(ClankCompilationDataBase.Entry entry) {
        Collection compiledFiles = entry.getCompiledFiles();
        return compiledFiles != null && !compiledFiles.isEmpty() && CharSequenceUtils.startsWith((CharSequence)((CharSequence)compiledFiles.iterator().next()), (CharSequence)RFS_PREFIX);
    }

    public static String getPathFromUrl(String path) {
        if (CharSequenceUtils.startsWith((CharSequence)path, (CharSequence)RFS_PREFIX)) {
            int pos = CharSequenceUtils.indexOf((CharSequence)path, (CharSequence)":", (int)RFS_PREFIX.length());
            if (pos > 0) {
                ++pos;
                while (pos < path.length() && Character.isDigit(path.charAt(pos))) {
                    ++pos;
                }
                return path.substring(pos, path.length());
            }
            throw new IllegalArgumentException("The path " + path + " starts with " + RFS_PREFIX + " but does not contain a colon after it");
        }
        return path;
    }
}

