/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.IOException;
import java.io.Writer;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;

public class APTTraceUtils {
    private APTTraceUtils() {
    }

    public static String toFileString(APTFile aptFile) {
        if (aptFile == null) {
            return "<no file>";
        }
        String file = aptFile.getPath().toString();
        if (!CndUtils.isUnitTestMode()) {
            return file;
        }
        String parentFile = CndPathUtilities.getDirName((String)file);
        String name = CndPathUtilities.getBaseName((String)file);
        if (parentFile == null) {
            return name;
        }
        return CndPathUtilities.getBaseName((String)parentFile) + "/" + name;
    }

    public static String toStringList(APT t) {
        StringBuilder ts = new StringBuilder();
        if (t.getFirstChild() != null) {
            ts.append(" (");
        }
        ts.append(" ").append(t.toString());
        if (t.getFirstChild() != null) {
            ts.append(APTTraceUtils.toStringList(t.getFirstChild()));
        }
        if (t.getFirstChild() != null) {
            ts.append(" )");
        }
        if (t.getNextSibling() != null) {
            ts.append(APTTraceUtils.toStringList(t.getNextSibling()));
        }
        return ts.toString();
    }

    public static String toStringTree(APT t) {
        StringBuilder ts = new StringBuilder();
        if (t.getFirstChild() != null) {
            ts.append(" (");
        }
        ts.append(" ").append(t.toString());
        if (t.getFirstChild() != null) {
            ts.append(APTTraceUtils.toStringTree(t.getFirstChild()));
        }
        if (t.getFirstChild() != null) {
            ts.append(" )");
        }
        return ts.toString();
    }

    public static void xmlSerialize(APT t, Writer out) throws IOException {
        for (APT node = t; node != null; node = node.getNextSibling()) {
            if (node.getFirstChild() == null) {
                APTTraceUtils.xmlSerializeNode(node, out);
                continue;
            }
            APTTraceUtils.xmlSerializeRootOpen(node, out);
            APTTraceUtils.xmlSerialize(node.getFirstChild(), out);
            APTTraceUtils.xmlSerializeRootClose(node, out);
        }
    }

    private static void xmlSerializeNode(APT t, Writer out) throws IOException {
        out.write("<" + APTTraceUtils.xmlNodeText(t) + "\"/>\n");
    }

    private static void xmlSerializeRootOpen(APT t, Writer out) throws IOException {
        out.write("<" + APTTraceUtils.xmlNodeText(t) + "\">\n");
    }

    private static void xmlSerializeRootClose(APT t, Writer out) throws IOException {
        out.write("</" + t.getClass().getSimpleName() + ">\n");
    }

    private static String xmlNodeText(APT t) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(t.getClass().getSimpleName());
        buf.append(" type=\"").append(APTTraceUtils.encode(APTTraceUtils.getTypeName(t)));
        buf.append("\" text=\"").append(APTTraceUtils.encode(t.toString()));
        return buf.toString();
    }

    private static String encode(String text) {
        StringBuilder n = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append("&amp;");
                    continue block7;
                }
                case '<': {
                    n.append("&lt;");
                    continue block7;
                }
                case '>': {
                    n.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    n.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    n.append("&apos;");
                    continue block7;
                }
                default: {
                    n.append(c);
                }
            }
        }
        return new String(n);
    }

    public static String getTypeName(APT t) {
        int type = t.getType();
        String str = "<unknown>";
        switch (type) {
            case 0: {
                str = "INVALID";
                break;
            }
            case 1: {
                str = "FILE";
                break;
            }
            case 2: {
                str = "TOKEN_STREAM";
                break;
            }
            case 3: {
                str = "INCLUDE";
                break;
            }
            case 4: {
                str = "INCLUDE_NEXT";
                break;
            }
            case 5: {
                str = "DEFINE";
                break;
            }
            case 6: {
                str = "UNDEF";
                break;
            }
            case 7: {
                str = "IFDEF";
                break;
            }
            case 8: {
                str = "IFNDEF";
                break;
            }
            case 9: {
                str = "IF";
                break;
            }
            case 10: {
                str = "ELIF";
                break;
            }
            case 11: {
                str = "ELSE";
                break;
            }
            case 12: {
                str = "ENDIF";
                break;
            }
            case 13: {
                str = "PRAGMA";
                break;
            }
            case 14: {
                str = "LINE";
                break;
            }
            case 15: {
                str = "ERROR";
                break;
            }
            case 16: {
                str = "PREPROC_UNKNOWN";
                break;
            }
        }
        return str;
    }
}

