/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.support.APTCommentToken;
import org.netbeans.modules.cnd.apt.impl.support.APTConstTextToken;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteConstTextToken;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteIdToken;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteLiteralToken;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroParamExpansion;
import org.netbeans.modules.cnd.apt.impl.support.APTTestToken;
import org.netbeans.modules.cnd.apt.impl.support.MacroExpandedToken;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankDriverImpl;
import org.netbeans.modules.cnd.apt.impl.support.generated.APTExprParser;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBaseToken;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class APTUtils {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.apt");
    public static final String SCOPE = "::";
    private static final String DEFINE_PREFIX = "#define ";
    public static final APTToken VA_ARGS_TOKEN;
    public static final APTToken EMPTY_ID_TOKEN;
    public static final APTToken COMMA_TOKEN;
    public static final APTToken DEF_MACRO_BODY;
    public static final APTToken EOF_TOKEN;
    public static final APTToken EOF_TOKEN2;
    private static final int EOF3 = -1;
    public static final TokenStream EMPTY_STREAM;

    public static CharSequence getFileOnceMacroName(APTFile apt) {
        String path = apt.getPath().toString().replace("\\", "/");
        if (CndUtils.isUnitTestMode()) {
            String TEST_DATA_DIR = "/unit/data/";
            int idx = path.indexOf(TEST_DATA_DIR);
            assert (idx > 0) : "no " + TEST_DATA_DIR + " prefix in " + path;
            path = path.substring(idx + TEST_DATA_DIR.length());
        }
        return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)"\"", (CharSequence)path, (CharSequence)"\""));
    }

    public static String getAPTTokenName(int type) {
        if (type == 91) {
            return "ID";
        }
        if (type == EOF_TOKEN2.getType()) {
            return "EOF3";
        }
        return APTExprParser._tokenNames[type];
    }

    public static void dumpStatistics() {
        APTDriver.dumpStatistics();
    }

    private APTUtils() {
    }

    public static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public static int hash(List<?> list) {
        if (list == null) {
            return 0;
        }
        int hashCode = 1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return APTUtils.hash(hashCode);
    }

    public static boolean equalArrayLists(List<?> l1, List<?> l2) {
        if (l1 != l2) {
            int n2;
            if (l1 == null || l2 == null) {
                return false;
            }
            int n1 = l1.size();
            if (n1 != (n2 = l2.size())) {
                return false;
            }
            for (int i = 0; i < n1; ++i) {
                if (l1.get(i).equals(l2.get(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void setTokenText(APTToken _token, char[] buf, int start, int count) {
        if (_token instanceof APTBaseToken || _token instanceof APTLiteIdToken) {
            _token.setTextID(CharSequences.create((char[])buf, (int)start, (int)count));
        } else if (_token instanceof APTCommentToken) {
            ((APTCommentToken)_token).setTextLength(count);
        } else if (!(_token instanceof APTConstTextToken || _token instanceof APTLiteConstTextToken || _token instanceof APTLiteLiteralToken)) {
            System.err.printf("unexpected token %s while assigning text %s", _token, new String(buf, start, count));
            _token.setText(new String(buf, start, count));
        }
    }

    public static APTDefine createAPTDefineOnce(CharSequence filePath) {
        APTDefineNode defNode = null;
        String text = DEFINE_PREFIX + filePath;
        TokenStream stream = APTTokenStreamBuilder.buildTokenStream(text, "Unknown Language");
        try {
            APTToken next = (APTToken)stream.nextToken();
            APTToken fileName = (APTToken)stream.nextToken();
            defNode = new APTDefineNode(next, fileName);
        }
        catch (TokenStreamException ex) {
            LOG.log(Level.SEVERE, "error on lexing macros {0}\n\t{1}", new Object[]{filePath, ex.getMessage()});
        }
        return defNode;
    }

    public static APTDefine createAPTDefine(String macroText) {
        APTDefineNode.Builder nodeBuilder = null;
        macroText = DEFINE_PREFIX + macroText;
        TokenStream stream = APTTokenStreamBuilder.buildTokenStream(macroText, "Unknown Language");
        try {
            APTToken next = (APTToken)stream.nextToken();
            nodeBuilder = new APTDefineNode.Builder(next);
            boolean look4Equal = true;
            do {
                next = (APTToken)stream.nextToken();
                if (!look4Equal || next.getType() != 6) continue;
                look4Equal = false;
                next = (APTToken)stream.nextToken();
            } while (nodeBuilder.accept(null, next));
            if (((APTDefineNode)nodeBuilder.getNode()).getBody().isEmpty() && look4Equal) {
                nodeBuilder.accept(null, DEF_MACRO_BODY);
            }
        }
        catch (TokenStreamException ex) {
            LOG.log(Level.SEVERE, "error on lexing macros {0}\n\t{1}", new Object[]{macroText, ex.getMessage()});
        }
        return (APTDefineNode)nodeBuilder.getNode();
    }

    public static APTToken createAPTToken(int type, int startOffset, int endOffset, int startColumn, int startLine, int endColumn, int endLine, int literalType) {
        if (APTLiteConstTextToken.isApplicable(type, startOffset, startColumn, startLine)) {
            return new APTLiteConstTextToken(type, startOffset, startColumn, startLine);
        }
        if (APTLiteLiteralToken.isApplicable(type, startOffset, startColumn, startLine, literalType)) {
            return new APTLiteLiteralToken(startOffset, startColumn, startLine, literalType);
        }
        if (APTLiteIdToken.isApplicable(type, startOffset, startColumn, startLine)) {
            return new APTLiteIdToken(startOffset, startColumn, startLine);
        }
        APTToken out = APTUtils.createAPTToken(type);
        out.setType(type);
        out.setColumn(startColumn);
        out.setLine(startLine);
        out.setOffset(startOffset);
        out.setEndOffset(endOffset);
        out.setEndColumn(endColumn);
        out.setEndLine(endLine);
        return out;
    }

    public static APTToken createIDENT(CharSequence text) {
        assert (CharSequences.isCompact((CharSequence)text));
        APTToken out = APTUtils.createAPTToken(91);
        out.setType(91);
        out.setTextID(text);
        return out;
    }

    public static APTToken createAPTToken(int type) {
        if (APTUtils.isPreprocessorToken(type)) {
            return APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
        }
        switch (type) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 78: 
            case 79: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 504: {
                return APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
            }
            case 478: 
            case 485: 
            case 486: {
                return new APTCommentToken();
            }
        }
        return new APTConstTextToken();
    }

    public static APTToken getLastToken(TokenStream ts) {
        APTToken last = null;
        try {
            APTToken token = (APTToken)ts.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                last = token;
                token = (APTToken)ts.nextToken();
            }
        }
        catch (TokenStreamException tokenStreamException) {
            // empty catch block
        }
        return last;
    }

    public static CharSequence debugString(TokenStream ts) {
        return APTUtils.stringize(ts, false);
    }

    public static String toString(TokenStream ts) {
        StringBuilder retValue = new StringBuilder();
        try {
            Token token = ts.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                retValue.append(token.toString());
                token = ts.nextToken();
                if (APTUtils.isEOF(token)) continue;
                retValue.append(" ");
            }
        }
        catch (TokenStreamException ex) {
            LOG.log(Level.SEVERE, "error on converting token stream to text\n{0}", new Object[]{ex});
        }
        return retValue.toString();
    }

    public static CharSequence stringize(TokenStream ts, boolean inIncludeDirective) {
        StringBuilder retValue = new StringBuilder();
        try {
            APTToken token = (APTToken)ts.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                retValue.append(token.getTextID());
                APTToken next = (APTToken)ts.nextToken();
                if (!APTUtils.isEOF(next) && !inIncludeDirective) {
                    retValue.append(next.getOffset() == token.getEndOffset() ? "" : Character.valueOf(' '));
                }
                token = next;
            }
        }
        catch (TokenStreamException ex) {
            LOG.log(Level.SEVERE, "error on stringizing token stream\n{0}", new Object[]{ex});
        }
        return retValue;
    }

    public static String macros2String(Collection<? extends CharSequence> macros) {
        StringBuilder retValue = new StringBuilder();
        retValue.append("MACROS (sorted ").append(macros.size()).append("):\n");
        ArrayList<? extends CharSequence> macrosSorted = new ArrayList<CharSequence>(macros);
        Collections.sort(macrosSorted, CharSequences.comparator());
        for (CharSequence charSequence : macrosSorted) {
            assert (charSequence != null);
            retValue.append(charSequence);
            retValue.append("'\n");
        }
        return retValue.toString();
    }

    public static String macros2String(Map<CharSequence, APTMacro> macros) {
        StringBuilder retValue = new StringBuilder();
        retValue.append("MACROS (sorted ").append(macros.size()).append("):\n");
        ArrayList<CharSequence> macrosSorted = new ArrayList<CharSequence>(macros.keySet());
        Collections.sort(macrosSorted, CharSequences.comparator());
        for (CharSequence key : macrosSorted) {
            APTMacro macro = macros.get(key);
            assert (macro != null);
            retValue.append(macro);
            retValue.append("'\n");
        }
        return retValue.toString();
    }

    public static CharSequence includes2String(List<IncludeDirEntry> includePaths) {
        StringBuilder retValue = new StringBuilder();
        Iterator<IncludeDirEntry> it = includePaths.iterator();
        while (it.hasNext()) {
            IncludeDirEntry path = it.next();
            retValue.append(CndFileSystemProvider.toUrl((FileSystem)path.getFileSystem(), (CharSequence)path.getAsSharedCharSequence()));
            if (!it.hasNext()) continue;
            retValue.append('\n');
        }
        return retValue;
    }

    public static boolean isPreprocessorToken(Token token) {
        assert (token != null);
        return APTUtils.isPreprocessorToken(token.getType());
    }

    public static boolean isPreprocessorToken(int ttype) {
        switch (ttype) {
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    public static boolean isID(Token token) {
        return token != null && token.getType() == 91;
    }

    public static boolean isFortranKeyword(int tokenType) {
        APTLanguageFilter filter = APTLanguageSupport.getInstance().getFilter("Fortran Language");
        if (filter instanceof APTBaseLanguageFilter) {
            return ((APTBaseLanguageFilter)filter).isKeyword(tokenType);
        }
        return false;
    }

    public static boolean isInt(Token token) {
        if (token != null) {
            switch (token.getType()) {
                case 65: 
                case 66: 
                case 67: 
                case 92: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEOF(Token token) {
        assert (token != null);
        return token == null || APTUtils.isEOF(token.getType());
    }

    public static boolean isEOF(int ttype) {
        return ttype == 1 || ttype == -1;
    }

    public static boolean isVaArgsToken(APTToken token) {
        return token != null && token.getTextID().equals(VA_ARGS_TOKEN.getTextID());
    }

    public static boolean isStartConditionNode(int ntype) {
        switch (ntype) {
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStartOrSwitchConditionNode(int ntype) {
        switch (ntype) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndCondition(Token token) {
        return APTUtils.isEndCondition(token.getType());
    }

    public static boolean isEndCondition(int ttype) {
        switch (ttype) {
            case 102: 
            case 103: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndConditionNode(int ntype) {
        switch (ntype) {
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommentToken(Token token) {
        assert (token != null);
        return APTUtils.isCommentToken(token.getType());
    }

    public static boolean isCommentToken(int ttype) {
        switch (ttype) {
            case 478: 
            case 485: 
            case 486: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenBracket(Token token) {
        assert (token != null);
        return APTUtils.isOpenBracket(token.getType());
    }

    public static boolean isOpenBracket(int ttype) {
        switch (ttype) {
            case 12: 
            case 14: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCloseBracket(Token token) {
        assert (token != null);
        return APTUtils.isCloseBracket(token.getType());
    }

    public static boolean isCloseBracket(int ttype) {
        switch (ttype) {
            case 13: 
            case 15: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static int getMatchBracket(int ttype) {
        switch (ttype) {
            case 17: {
                return 16;
            }
            case 13: {
                return 12;
            }
            case 15: {
                return 14;
            }
            case 16: {
                return 17;
            }
            case 12: {
                return 13;
            }
            case 14: {
                return 15;
            }
        }
        return 1;
    }

    public static boolean isEndDirectiveToken(int ttype) {
        switch (ttype) {
            case 1: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMacroExpandedToken(Token token) {
        if (token instanceof MacroExpandedToken) {
            return true;
        }
        if (token instanceof APTBaseLanguageFilter.FilterToken) {
            return APTUtils.isMacroExpandedToken(((APTBaseLanguageFilter.FilterToken)token).getOriginalToken());
        }
        return false;
    }

    public static boolean isMacroParamExpandedToken(Token token) {
        if (token instanceof APTMacroParamExpansion) {
            return true;
        }
        if (token instanceof MacroExpandedToken) {
            return APTUtils.isMacroParamExpandedToken(((MacroExpandedToken)token).getTo());
        }
        if (token instanceof APTBaseLanguageFilter.FilterToken) {
            return APTUtils.isMacroParamExpandedToken(((APTBaseLanguageFilter.FilterToken)token).getOriginalToken());
        }
        return false;
    }

    public static APTToken getExpandedToken(APTToken token) {
        if (token instanceof APTMacroParamExpansion) {
            return APTUtils.getExpandedToken(((APTMacroParamExpansion)token).getOriginal());
        }
        if (token instanceof MacroExpandedToken) {
            return APTUtils.getExpandedToken(((MacroExpandedToken)token).getTo());
        }
        if (token instanceof APTBaseLanguageFilter.FilterToken) {
            return APTUtils.getExpandedToken(((APTBaseLanguageFilter.FilterToken)token).getOriginalToken());
        }
        return token;
    }

    public static boolean areAdjacent(APTToken left, APTToken right) {
        while (left instanceof MacroExpandedToken && right instanceof MacroExpandedToken) {
            left = ((MacroExpandedToken)left).getTo();
            right = ((MacroExpandedToken)right).getTo();
        }
        return left.getEndOffset() == right.getOffset();
    }

    public static List<APTToken> toList(TokenStream ts) {
        if (ts instanceof ClankDriverImpl.ArrayBasedAPTTokenStream) {
            return ((ClankDriverImpl.ArrayBasedAPTTokenStream)ts).toList();
        }
        LinkedList<APTToken> tokens = new LinkedList<APTToken>();
        try {
            APTToken token = (APTToken)ts.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                tokens.add(token);
                token = (APTToken)ts.nextToken();
            }
        }
        catch (TokenStreamException ex) {
            LOG.log(Level.INFO, "error on converting token stream to list", ex.getMessage());
        }
        return tokens;
    }

    public static Object getTextKey(String text) {
        assert (text != null);
        assert (text.length() > 0);
        return text;
    }

    public static APTToken createAPTToken(APTToken token, int ttype) {
        APTToken newToken = APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken(token, ttype) : new APTBaseToken(token, ttype);
        return newToken;
    }

    public static APTToken createAPTToken(APTToken token) {
        return APTUtils.createAPTToken(token, token.getType());
    }

    public static APTToken createAPTToken() {
        APTToken newToken = APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
        return newToken;
    }

    static {
        String level = System.getProperty("org.netbeans.modules.cnd.apt.level");
        if (level == null) {
            if (APTTraceFlags.TRACE_APT | APTTraceFlags.TRACE_APT_LEXER) {
                LOG.setLevel(Level.ALL);
            } else {
                LOG.setLevel(Level.SEVERE);
            }
        } else {
            try {
                LOG.setLevel(Level.parse(level));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        VA_ARGS_TOKEN = APTUtils.createAPTToken();
        VA_ARGS_TOKEN.setType(91);
        VA_ARGS_TOKEN.setText("__VA_ARGS__");
        EMPTY_ID_TOKEN = APTUtils.createAPTToken();
        EMPTY_ID_TOKEN.setType(91);
        EMPTY_ID_TOKEN.setText("");
        COMMA_TOKEN = APTUtils.createAPTToken(8);
        COMMA_TOKEN.setType(8);
        COMMA_TOKEN.setText(",");
        DEF_MACRO_BODY = APTUtils.createAPTToken();
        DEF_MACRO_BODY.setType(90);
        DEF_MACRO_BODY.setText("1");
        EOF_TOKEN = new APTEOFToken();
        EOF_TOKEN2 = new APTEOFTokenAntlr3();
        EMPTY_STREAM = new TokenStream(){

            public Token nextToken() throws TokenStreamException {
                return EOF_TOKEN;
            }
        };
    }

    private static final class APTEOFTokenAntlr3
    extends APTTokenAbstact {
        @Override
        public int getOffset() {
            throw new UnsupportedOperationException("getOffset must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public void setOffset(int o) {
            throw new UnsupportedOperationException("setOffset must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("getEndOffset must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public void setEndOffset(int o) {
            throw new UnsupportedOperationException("setEndOffset must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public CharSequence getTextID() {
            throw new UnsupportedOperationException("getTextID must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public void setTextID(CharSequence id) {
            throw new UnsupportedOperationException("setTextID must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public int getEndColumn() {
            throw new UnsupportedOperationException("getEndColumn must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public void setEndColumn(int c) {
            throw new UnsupportedOperationException("setEndColumn must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public int getEndLine() {
            throw new UnsupportedOperationException("getEndLine must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public void setEndLine(int l) {
            throw new UnsupportedOperationException("setEndLine must not be used; use APTUtils.isEOF in client");
        }

        @Override
        public int getType() {
            return -1;
        }

        @Override
        public String getText() {
            return "<EOF3>";
        }

        @Override
        public int getColumn() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getLine() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "<EOF3>";
        }
    }

    private static final class APTEOFToken
    extends APTTokenAbstact {
        @Override
        public int getOffset() {
            throw new UnsupportedOperationException("getOffset must not be used");
        }

        @Override
        public void setOffset(int o) {
            throw new UnsupportedOperationException("setOffset must not be used");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("getEndOffset must not be used");
        }

        @Override
        public void setEndOffset(int o) {
            throw new UnsupportedOperationException("setEndOffset must not be used");
        }

        @Override
        public CharSequence getTextID() {
            throw new UnsupportedOperationException("getTextID must not be used");
        }

        @Override
        public void setTextID(CharSequence id) {
            throw new UnsupportedOperationException("setTextID must not be used");
        }

        @Override
        public int getEndColumn() {
            throw new UnsupportedOperationException("getEndColumn must not be used");
        }

        @Override
        public void setEndColumn(int c) {
            throw new UnsupportedOperationException("setEndColumn must not be used");
        }

        @Override
        public int getEndLine() {
            throw new UnsupportedOperationException("getEndLine must not be used");
        }

        @Override
        public void setEndLine(int l) {
            throw new UnsupportedOperationException("setEndLine must not be used");
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public String getText() {
            return "<EOF>";
        }

        @Override
        public int getColumn() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getLine() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "<EOF>";
        }
    }
}

