/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphAction;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphActionEDTRunnable;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphUI;
import org.netbeans.modules.cnd.callgraph.api.ui.Catalog;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphScene;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.DefaultCatalog;
import org.netbeans.modules.cnd.callgraph.impl.FunctionRootNode;
import org.netbeans.modules.cnd.callgraph.impl.GoToOccurrenceAction;
import org.netbeans.modules.cnd.callgraph.impl.LoadingNode;
import org.netbeans.modules.cnd.callgraph.support.ExportAction;
import org.netbeans.modules.cnd.callgraph.support.ExportXmlAction;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class CallGraphPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    private final AbstractNode root;
    private List<Action> actions;
    private CallModel model;
    private boolean showGraph;
    private boolean isCalls;
    private boolean isShowOverriding;
    private boolean isShowParameters;
    public static final String IS_CALLS = "CallGraphIsCalls";
    public static final String IS_SHOW_OVERRIDING = "CallGraphIsShowOverriding";
    public static final String IS_SHOW_PARAMETERS = "CallGraphIsShowParameters";
    public static final String INITIAL_LAYOUT = "CallGraphLayout";
    private CallGraphScene scene;
    private final transient FocusTraversalPolicy newPolicy;
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final int MAX_EXPANDED_TREE_NODES = 1000;
    private AtomicBoolean isSetDividerLocation = new AtomicBoolean(false);
    private static final RequestProcessor RP = new RequestProcessor("CallGraphPanel", 2);
    private final CallGraphUI graphUI;
    private final Catalog messagesCatalog;
    final ShowOverridingAction showOverridingAction;
    private final Icon overridingIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/show_overriding.gif"));
    private JToggleButton callers;
    private JToggleButton calls;
    private JPanel contextPanel;
    private JButton focusOn;
    private JScrollPane graphView;
    private JToolBar.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JToolBar jToolBar1;
    private JToggleButton overriding;
    private JButton refresh;
    private JScrollPane treeView;

    public CallGraphPanel(CallGraphUI graphUI) {
        this.graphUI = graphUI;
        this.messagesCatalog = graphUI == null || graphUI.getCatalog() == null ? new DefaultCatalog() : graphUI.getCatalog();
        this.showOverridingAction = new ShowOverridingAction();
        this.initComponents();
        this.isCalls = NbPreferences.forModule(CallGraphPanel.class).getBoolean(IS_CALLS, true);
        this.isShowOverriding = NbPreferences.forModule(CallGraphPanel.class).getBoolean(IS_SHOW_OVERRIDING, false);
        this.isShowParameters = NbPreferences.forModule(CallGraphPanel.class).getBoolean(IS_SHOW_PARAMETERS, false);
        this.getTreeView().setRootVisible(false);
        Children.SortedArray children = new Children.SortedArray();
        this.showGraph = graphUI == null ? false : graphUI.showGraph();
        this.actions = new ArrayList<Action>();
        this.actions.add(new RefreshAction());
        this.actions.add(new FocusOnAction());
        this.actions.add(null);
        this.actions.add(new WhoIsCalledAction());
        this.actions.add(new WhoCallsAction());
        this.actions.add(this.showOverridingAction);
        this.actions.add(null);
        this.actions.add(new ShowFunctionParameters());
        if (this.showGraph) {
            this.scene = new CallGraphScene();
            ExportAction exportAction = new ExportAction((Scene)this.scene, this);
            ExportXmlAction exportXmlAction = new ExportXmlAction(this.scene, this);
            this.actions.add(exportAction);
            this.actions.add(exportXmlAction);
            this.scene.setExportAction(exportAction);
            this.scene.setExportXmlAction(exportXmlAction);
        }
        this.actions.add(null);
        this.actions.add(new ExpandAction());
        this.actions.add(new ExpandAllAction());
        if (graphUI != null) {
            this.actions.addAll(graphUI.getActions(new CallGraphActionEDTRunnable(){

                @Override
                public void run() {
                    CallGraphPanel.this.updateButtons();
                    CallGraphPanel.this.update();
                }
            }));
        }
        this.root = new AbstractNode((Children)children){

            public Action[] getActions(boolean context) {
                return CallGraphPanel.this.actions.toArray(new Action[CallGraphPanel.this.actions.size()]);
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
        if (this.showGraph) {
            this.initGraph();
        } else {
            Component left = this.jSplitPane1.getLeftComponent();
            this.remove(this.jSplitPane1);
            this.jSplitPane1.remove(left);
            this.add(left, "Center");
        }
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] selectedNodes = CallGraphPanel.this.getExplorerManager().getSelectedNodes();
                if (selectedNodes.length == 1) {
                    Node selected = selectedNodes[0];
                    if (selected instanceof CallNode) {
                        CallGraphPanel.this.getContextPanel().setRootContent((CallNode)selected);
                    } else {
                        CallGraphPanel.this.getContextPanel().setRootContent(null);
                    }
                }
            }
        });
        ArrayList<Component> order = new ArrayList<Component>();
        order.add(this.treeView);
        order.add(this.contextPanel);
        order.add(this.refresh);
        order.add(this.focusOn);
        order.add(this.calls);
        order.add(this.callers);
        this.newPolicy = new MyOwnFocusTraversalPolicy(this, order);
        this.setFocusTraversalPolicy(this.newPolicy);
        if (isMacLaf) {
            this.jToolBar1.setBackground(macBackground);
        }
    }

    private void initGraph() {
        JComponent view = this.scene.createView();
        this.graphView.setViewportView(view);
        view.setFocusable(this.isCalls);
        int aInt = NbPreferences.forModule(CallGraphPanel.class).getInt(INITIAL_LAYOUT, 0);
        switch (aInt) {
            case 0: {
                this.scene.setLayout(CallGraphScene.LayoutKind.grid);
                break;
            }
            case 1: {
                this.scene.setLayout(CallGraphScene.LayoutKind.hierarchical);
                break;
            }
            case 2: {
                this.scene.setLayout(CallGraphScene.LayoutKind.hierarchical_inverted);
                break;
            }
            case 3: {
                this.scene.setLayout(CallGraphScene.LayoutKind.horizontal);
            }
        }
        this.graphView.setFocusable(false);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.refresh = new JButton();
        this.focusOn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.calls = new JToggleButton();
        this.callers = new JToggleButton();
        this.overriding = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.graphView = new JScrollPane();
        this.jSplitPane2 = new JSplitPane();
        this.treeView = new BeanTreeView();
        this.contextPanel = new ContextPanel(this.graphUI);
        this.setFocusCycleRoot(true);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        this.jToolBar1.setName("jToolBar1");
        this.refresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/refresh.png")));
        this.refresh.setToolTipText(this.getMessage("RefreshActionTooltip", new Object[0]));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setName("refresh");
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.refreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.refresh);
        this.focusOn.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/focus_on.png")));
        this.focusOn.setToolTipText(this.getMessage("FocusOnActionTooltip", new Object[0]));
        this.focusOn.setHorizontalTextPosition(0);
        this.focusOn.setName("focusOn");
        this.focusOn.setVerticalTextPosition(3);
        this.focusOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.focusOnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.focusOn);
        this.jSeparator1.setName("jSeparator1");
        this.jSeparator1.setSeparatorSize(new Dimension(0, 4));
        this.jToolBar1.add(this.jSeparator1);
        this.calls.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/who_is_called.png")));
        this.calls.setToolTipText(this.getMessage("CallsActionTooltip", new Object[0]));
        this.calls.setHorizontalTextPosition(0);
        this.calls.setMaximumSize(new Dimension(28, 28));
        this.calls.setMinimumSize(new Dimension(28, 28));
        this.calls.setName("calls");
        this.calls.setPreferredSize(new Dimension(28, 28));
        this.calls.setVerticalTextPosition(3);
        this.calls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.callsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.calls);
        this.callers.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/who_calls.png")));
        this.callers.setToolTipText(this.getMessage("CallersActionTooltip", new Object[0]));
        this.callers.setHorizontalTextPosition(0);
        this.callers.setMaximumSize(new Dimension(28, 28));
        this.callers.setMinimumSize(new Dimension(28, 28));
        this.callers.setName("callers");
        this.callers.setPreferredSize(new Dimension(28, 28));
        this.callers.setVerticalTextPosition(3);
        this.callers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.callersActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.callers);
        this.overriding.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/show_overriding.gif")));
        this.overriding.setToolTipText(this.getMessage("ShowOverridingTooltip", new Object[0]));
        this.overriding.setFocusable(false);
        this.overriding.setHorizontalTextPosition(0);
        this.overriding.setMaximumSize(new Dimension(28, 28));
        this.overriding.setMinimumSize(new Dimension(28, 28));
        this.overriding.setName("overriding");
        this.overriding.setPreferredSize(new Dimension(28, 28));
        this.overriding.setVerticalTextPosition(3);
        this.overriding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.overridingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.overriding);
        this.add((Component)this.jToolBar1, "Before");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setFocusable(false);
        this.jSplitPane1.setName("");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.graphView.setToolTipText("");
        this.graphView.setFocusable(false);
        this.graphView.setName("");
        this.jSplitPane1.setRightComponent(this.graphView);
        this.graphView.getAccessibleContext().setAccessibleName("getMessage(\"pictorial.part\")");
        this.graphView.getAccessibleContext().setAccessibleDescription("getMessage(\"pictorial.part\")");
        this.jSplitPane2.setDividerLocation(-10);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(1.0);
        this.jSplitPane2.setFocusable(false);
        this.jSplitPane2.setName("");
        this.treeView.setName("treeView");
        this.jSplitPane2.setLeftComponent(this.treeView);
        this.treeView.getAccessibleContext().setAccessibleName(this.getMessage("CGP_TreeView_AN", new Object[0]));
        this.treeView.getAccessibleContext().setAccessibleDescription(this.getMessage("CGP_TreeView_AD", new Object[0]));
        this.contextPanel.setMinimumSize(new Dimension(10, 35));
        this.contextPanel.setName("contextPanel");
        this.contextPanel.setPreferredSize(new Dimension(10, 35));
        this.jSplitPane2.setRightComponent(this.contextPanel);
        this.contextPanel.getAccessibleContext().setAccessibleName(this.getMessage("CGP_ListView_AM", new Object[0]));
        this.contextPanel.getAccessibleContext().setAccessibleDescription(this.getMessage("CGP_ListView_AD", new Object[0]));
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void refreshActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void callsActionPerformed(ActionEvent evt) {
        if (this.isCalls == this.calls.isSelected()) {
            return;
        }
        this.setDirection(true);
    }

    private void callersActionPerformed(ActionEvent evt) {
        if (this.isCalls != this.callers.isSelected()) {
            return;
        }
        this.setDirection(false);
    }

    private void focusOnActionPerformed(ActionEvent evt) {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes == null || nodes.length != 1) {
            return;
        }
        Node node = nodes[0];
        if (node instanceof FunctionRootNode) {
            this.update();
        } else if (node instanceof CallNode) {
            Call call = ((CallNode)node).getCall();
            if (this.isCalls) {
                this.model.setRoot(call.getCallee());
            } else {
                this.model.setRoot(call.getCaller());
            }
            this.setName(this.model.getName());
            this.setToolTipText(this.getName() + " - " + this.getMessage("CTL_CallGraphTopComponent", new Object[0]));
            Container parent = this.getParent();
            while (parent != null) {
                if (parent instanceof JTabbedPane) {
                    int i = ((JTabbedPane)parent).getSelectedIndex();
                    if (i < 0) break;
                    ((JTabbedPane)parent).setTitleAt(i, this.getName() + "  ");
                    break;
                }
                if (!(parent instanceof TopComponent)) continue;
                ((TopComponent)parent).setName(this.getToolTipText());
                break;
            }
            this.update();
        }
    }

    private void overridingActionPerformed(ActionEvent evt) {
        this.showOverridingAction.actionPerformed(evt);
    }

    private void setShowOverriding(boolean showOverriding) {
        this.isShowOverriding = showOverriding;
        NbPreferences.forModule(CallGraphPanel.class).putBoolean(IS_SHOW_OVERRIDING, this.isShowOverriding);
    }

    private void setShowParameters(boolean showParameters) {
        this.isShowParameters = showParameters;
        NbPreferences.forModule(CallGraphPanel.class).putBoolean(IS_SHOW_PARAMETERS, this.isShowParameters);
        this.updateButtons();
        this.update();
    }

    private void setDirection(boolean direction) {
        this.isCalls = direction;
        NbPreferences.forModule(CallGraphPanel.class).putBoolean(IS_CALLS, this.isCalls);
        this.updateButtons();
        this.update();
    }

    private void updateButtons() {
        this.calls.setSelected(this.isCalls);
        this.callers.setSelected(!this.isCalls);
        this.overriding.setSelected(this.isShowOverriding);
    }

    private String getMessage(String key, Object ... parameters) {
        return this.messagesCatalog.getMessage(key, parameters);
    }

    public void setModel(CallModel model) {
        this.model = model;
        if (!model.getRoot().kind().equals((Object)Function.Kind.FUNCTION)) {
            this.isCalls = false;
        }
        this.updateButtons();
        this.update();
    }

    public CallModel getModel() {
        return this.model;
    }

    private synchronized void update() {
        final CallGraphState state = new CallGraphState(this.model, this.scene, this.actions);
        if (this.showGraph) {
            this.scene.setModel(state);
        }
        if (this.showGraph) {
            this.scene.clean();
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                final Function function = CallGraphPanel.this.model.getRoot();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (function != null) {
                            final Children children = CallGraphPanel.this.root.getChildren();
                            if (!Children.MUTEX.isReadAccess()) {
                                Children.MUTEX.writeAccess(new Runnable(){

                                    @Override
                                    public void run() {
                                        children.remove(children.getNodes());
                                        FunctionRootNode selectedNode = null;
                                        if (!CallGraphPanel.this.model.isRootVisible()) {
                                            List<Call> childrenList = CallGraphPanel.this.isCalls ? CallGraphPanel.this.model.getCallees(function) : CallGraphPanel.this.model.getCallers(function);
                                            Node[] functions = new Node[childrenList.size()];
                                            for (int i = 0; i < childrenList.size(); ++i) {
                                                Call call = childrenList.get(i);
                                                Function f = CallGraphPanel.this.isCalls ? call.getCallee() : call.getCaller();
                                                functions[i] = new FunctionRootNode(f, state, CallGraphPanel.this.isCalls);
                                            }
                                            if (functions.length > 0) {
                                                selectedNode = functions[0];
                                            }
                                            children.add(functions);
                                        } else {
                                            selectedNode = new FunctionRootNode(function, state, CallGraphPanel.this.isCalls);
                                            children.add(new Node[]{selectedNode});
                                        }
                                        FunctionRootNode node = selectedNode;
                                        try {
                                            CallGraphPanel.this.getExplorerManager().setSelectedNodes(new Node[]{node});
                                        }
                                        catch (PropertyVetoException propertyVetoException) {
                                            // empty catch block
                                        }
                                        SwingUtilities.invokeLater(new Runnable((Node)node){
                                            final /* synthetic */ Node val$node;
                                            {
                                                this.val$node = node;
                                            }

                                            @Override
                                            public void run() {
                                                CallGraphPanel.this.getTreeView().expandNode(this.val$node);
                                            }
                                        });
                                    }
                                });
                            }
                        } else {
                            final Children children = CallGraphPanel.this.root.getChildren();
                            if (!Children.MUTEX.isReadAccess()) {
                                Children.MUTEX.writeAccess(new Runnable(){

                                    @Override
                                    public void run() {
                                        children.remove(children.getNodes());
                                    }
                                });
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.treeView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeView.requestFocusInWindow();
    }

    public final BeanTreeView getTreeView() {
        return (BeanTreeView)this.treeView;
    }

    private ContextPanel getContextPanel() {
        return (ContextPanel)this.contextPanel;
    }

    public final ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("CallGraphView");
    }

    private void expandAllImpl(final Node n) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                CallGraphPanel.this.expandAllWorker(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAllWorker(Node n) {
        final AtomicBoolean canceled = new AtomicBoolean(false);
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)this.getMessage("ExpandAll", new Object[0]), (Cancellable)new Cancellable(){

            public boolean cancel() {
                canceled.set(true);
                return true;
            }
        });
        progress.start();
        try {
            ArrayList<List<Node>> list = new ArrayList<List<Node>>();
            this.expandAllImpl(progress, canceled, n, list);
            int count = 0;
            for (int i = 0; i < list.size(); ++i) {
                for (Node node : (List)list.get(i)) {
                    this.getTreeView().expandNode(node);
                    if (++count < 1000) continue;
                    int allCount = 0;
                    for (int j = 0; j < list.size(); ++j) {
                        allCount += ((List)list.get(j)).size();
                    }
                    StatusDisplayer.getDefault().setStatusText(this.getMessage("ExpandedLimitWarning", count, allCount, i, list.size(), allCount));
                    return;
                }
            }
        }
        finally {
            progress.finish();
        }
    }

    /*
     * Exception decompiling
     */
    private void expandAllImpl(ProgressHandle progress, AtomicBoolean canceled, Node node, List<List<Node>> list) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateProgress(ProgressHandle progress, List<List<Node>> list) {
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            count += list.get(i).size();
        }
        if (count % 100 == 0) {
            progress.progress(this.getMessage("ExpandedProgress", count, list.size()));
        }
    }

    private static class LoadingOccurencesNode
    extends AbstractNode
    implements Call.Occurrence {
        public LoadingOccurencesNode() {
            super(Children.LEAF);
            this.setName("dummy");
            this.setDisplayName(NbBundle.getMessage(this.getClass(), (String)"Loading"));
        }

        public Image getIcon(int param) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/waitNode.gif");
        }

        @Override
        public void open() {
        }

        @Override
        public String getHtmlDisplayName() {
            return this.getDescription();
        }

        public String getDisplayName() {
            return NbBundle.getMessage(this.getClass(), (String)"Loading");
        }

        @Override
        public String getDescription() {
            return this.getDisplayName();
        }

        public int hashCode() {
            int hash = 5;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LoadingNode) {
                return this == obj;
            }
            return false;
        }
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final ArrayList<Component> order;
        private final Container panel;

        public MyOwnFocusTraversalPolicy(Container panel, List<Component> order) {
            this.order = new ArrayList(order.size());
            this.order.addAll(order);
            this.panel = panel;
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (focusCycleRoot == this.panel) {
                int idx = this.getIndex(aComponent);
                idx = (idx + 1) % this.order.size();
                return this.getComponentAtIndex(idx);
            }
            return null;
        }

        private int getIndex(Component aComponent) {
            int idx = this.order.indexOf(aComponent);
            while (idx == -1) {
                if ((aComponent = aComponent.getParent()) == null) {
                    return -1;
                }
                idx = this.order.indexOf(aComponent);
            }
            return idx;
        }

        private Component getComponentAtIndex(int idx) {
            if (idx == 0) {
                return ((BeanTreeView)this.order.get(idx)).getViewport().getView();
            }
            if (idx == 1) {
                return ((ContextPanel)this.order.get(idx)).listView.getViewport().getView();
            }
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (focusCycleRoot == this.panel) {
                int idx = this.getIndex(aComponent) - 1;
                if (idx < 0) {
                    idx = this.order.size() - 1;
                }
                return this.getComponentAtIndex(idx);
            }
            return null;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            if (focusCycleRoot == this.panel) {
                return this.getComponentAtIndex(0);
            }
            return null;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            if (focusCycleRoot == this.panel) {
                return this.getComponentAtIndex(this.order.size() - 1);
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            if (focusCycleRoot == this.panel) {
                return this.getComponentAtIndex(0);
            }
            return null;
        }
    }

    private static final class ContextPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager managerCtx = new ExplorerManager();
        private final ListView listView = new ListView();
        private final CallGraphUI graphUI;

        private ContextPanel(CallGraphUI graphUI) {
            this.graphUI = graphUI;
            this.initDefaultView();
        }

        private void initDefaultView() {
            this.removeAll();
            this.listView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AM"));
            this.listView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AD"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.listView, "Center");
            this.listView.setFocusable(false);
            this.listView.setHorizontalScrollBarPolicy(31);
        }

        public ExplorerManager getExplorerManager() {
            return this.managerCtx;
        }

        @Override
        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            return this.listView.requestFocusInWindow();
        }

        private void setRootContent(final CallNode node) {
            this.initDefaultView();
            ArrayList<CallContext> list = new ArrayList<CallContext>(1);
            list.add(new CallContext(new LoadingOccurencesNode()));
            CallContextRoot root = new CallContextRoot(new ContextList(list));
            this.getExplorerManager().setRootContext((Node)root);
            this.revalidate();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CallContextRoot root;
                    if (node == null) {
                        List list = Collections.emptyList();
                        root = new CallContextRoot(new ContextList(list));
                    } else {
                        JPanel contextPanel;
                        Call call = node.getCall();
                        ArrayList<CallContext> list = new ArrayList<CallContext>(call.getOccurrences().size());
                        JPanel jPanel = contextPanel = ContextPanel.this.graphUI == null ? null : ContextPanel.this.graphUI.getContextPanel(call);
                        if (contextPanel != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ContextPanel.this.removeAll();
                                    ContextPanel.this.setLayout(new BorderLayout());
                                    ContextPanel.this.add((Component)contextPanel, "Center");
                                    ContextPanel.this.revalidate();
                                }
                            });
                            return;
                        }
                        if (call instanceof Node) {
                            root = (Node)call;
                        } else {
                            for (Call.Occurrence occurrence : call.getOccurrences()) {
                                list.add(new CallContext(occurrence));
                            }
                            root = new CallContextRoot(new ContextList(list));
                        }
                    }
                    CallContextRoot rootNode = root;
                    SwingUtilities.invokeLater(new Runnable((Node)rootNode){
                        final /* synthetic */ Node val$rootNode;
                        {
                            this.val$rootNode = node;
                        }

                        @Override
                        public void run() {
                            ContextPanel.this.initDefaultView();
                            ContextPanel.this.getExplorerManager().setRootContext(this.val$rootNode);
                            ContextPanel.this.revalidate();
                        }
                    });
                }
            });
        }

        public static class CallContext
        extends AbstractNode {
            private final Call.Occurrence occurrence;

            public CallContext(Call.Occurrence element) {
                super(Children.LEAF);
                this.occurrence = element;
            }

            public String getHtmlDisplayName() {
                if (this.occurrence != null) {
                    return this.occurrence.getHtmlDisplayName();
                }
                return super.getHtmlDisplayName();
            }

            public Action getPreferredAction() {
                return new GoToOccurrenceAction(this.occurrence);
            }

            public String getShortDescription() {
                String ret = this.occurrence.getDescription();
                if (ret != null) {
                    return ret;
                }
                return super.getShortDescription();
            }

            public Action[] getActions(boolean context) {
                return new Action[0];
            }

            public Image getIcon(int type) {
                if (this.occurrence instanceof Node) {
                    return ((Node)this.occurrence).getIcon(type);
                }
                return super.getIcon(type);
            }
        }

        private static final class CallContextRoot
        extends AbstractNode {
            public CallContextRoot(Children.Array array) {
                super((Children)array);
            }
        }

        private static final class ContextList
        extends Children.Array {
            private ContextList(Collection<Node> nodes) {
                super(nodes);
            }
        }
    }

    private final class ExpandAllAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenuItem menuItem;

        public ExpandAllAction() {
            this.putValue("Name", CallGraphPanel.this.getMessage("ExpandAll", new Object[0]));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node[] nodes = CallGraphPanel.this.getExplorerManager().getSelectedNodes();
            if (nodes == null || nodes.length == 0) {
                CallGraphPanel.this.expandAllImpl((Node)CallGraphPanel.this.root);
            } else {
                CallGraphPanel.this.expandAllImpl(nodes[0]);
            }
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private final class ExpandAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenuItem menuItem;

        public ExpandAction() {
            this.putValue("Name", CallGraphPanel.this.getMessage("Expand", new Object[0]));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node[] nodes = CallGraphPanel.this.getExplorerManager().getSelectedNodes();
            if (nodes == null || nodes.length == 0) {
                CallGraphPanel.this.getTreeView().expandAll();
            } else {
                CallGraphPanel.this.getTreeView().expandNode(nodes[0]);
            }
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private final class FocusOnAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenuItem menuItem;

        public FocusOnAction() {
            this.putValue("Name", CallGraphPanel.this.getMessage("FocusOnAction", new Object[0]));
            this.putValue("SmallIcon", CallGraphPanel.this.focusOn.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.focusOnActionPerformed(e);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private final class ShowFunctionParameters
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowFunctionParameters() {
            this.putValue("Name", CallGraphPanel.this.getMessage("ShowFunctionSignature", new Object[0]));
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.setShowParameters(!CallGraphPanel.this.isShowParameters);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphPanel.this.isShowParameters);
            return this.menuItem;
        }
    }

    private final class ShowOverridingAction
    extends CallGraphAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowOverridingAction() {
            super(new CallGraphActionEDTRunnable(){

                @Override
                public void run() {
                    CallGraphPanel.this.updateButtons();
                    CallGraphPanel.this.update();
                }
            });
            this.putValue("Name", CallGraphPanel.this.getMessage("ShowOverridingAction", new Object[0]));
            this.putValue("SmallIcon", CallGraphPanel.this.overridingIcon);
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void doNonEDTAction() {
            CallGraphPanel.this.setShowOverriding(!CallGraphPanel.this.isShowOverriding);
            CallGraphPanel.this.model.update();
        }

        @Override
        public void doEDTAction() {
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphPanel.this.isShowOverriding);
            return this.menuItem;
        }
    }

    private final class WhoIsCalledAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JRadioButtonMenuItem menuItem;

        public WhoIsCalledAction() {
            this.putValue("Name", CallGraphPanel.this.getMessage("CallsAction", new Object[0]));
            this.putValue("SmallIcon", CallGraphPanel.this.calls.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.setDirection(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphPanel.this.isCalls);
            return this.menuItem;
        }
    }

    private final class WhoCallsAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JRadioButtonMenuItem menuItem;

        public WhoCallsAction() {
            this.putValue("Name", CallGraphPanel.this.getMessage("CallersAction", new Object[0]));
            this.putValue("SmallIcon", CallGraphPanel.this.callers.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.setDirection(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!CallGraphPanel.this.isCalls);
            return this.menuItem;
        }
    }

    private final class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", CallGraphPanel.this.getMessage("RefreshAction", new Object[0]));
            this.putValue("SmallIcon", CallGraphPanel.this.refresh.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.refreshActionPerformed(e);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }
}

