/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.windows.IOColorPrint;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class RemoteJavaAntLogger
extends AntLogger {
    private static final String JIDENT = "[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*";
    private static final Pattern STACK_TRACE = Pattern.compile("(.*?((?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.])*)([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*)[.](?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*|<init>|<clinit>)[(])(([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.]java):([0-9]+)|Unknown Source)([)].*)");
    private static final Pattern EXCEPTION_MESSAGE = Pattern.compile("(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*\\.)+)([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*(?:: .+)?)");
    private static final String[] TASKS_OF_INTEREST = new String[]{"sshexec"};
    private static final int[] LEVELS_OF_INTEREST = new int[]{3, 2, 1, 0};

    static StackTraceParse parseStackTraceLine(String line) {
        Matcher m = STACK_TRACE.matcher(line);
        if (m.matches()) {
            int lineNumber;
            String pkg = m.group(2);
            String filename = m.group(5);
            if (filename == null) {
                filename = m.group(3).replaceFirst("[$].+", "") + ".java";
                lineNumber = 1;
            } else {
                lineNumber = Integer.parseInt(m.group(6));
            }
            return new StackTraceParse(line, pkg.replace('.', '/') + filename, lineNumber, m.group(1), m.group(4), m.group(7));
        }
        return null;
    }

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    private SessionData getSessionData(AntSession session) {
        SessionData data = (SessionData)session.getCustomData((AntLogger)this);
        if (data == null) {
            data = new SessionData();
            session.putCustomData((AntLogger)this, (Object)data);
        }
        return data;
    }

    public void buildStarted(AntEvent event) {
        Project prj;
        File projectDir;
        FileObject projectFolder;
        AntSession session = event.getSession();
        SessionData data = this.getSessionData(session);
        String path = event.evaluate("${basedir}");
        if (path != null && (projectFolder = FileUtil.toFileObject((File)(projectDir = FileUtil.normalizeFile((File)new File(path))))) != null && (prj = FileOwnerQuery.getOwner((FileObject)projectFolder)) != null) {
            ClassPath platformSources;
            ClassPath runCP = null;
            ClassPath bootCP = null;
            for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups("java")) {
                FileObject root = sg.getRootFolder();
                if (RemoteJavaAntLogger.isTest(root)) continue;
                runCP = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
                bootCP = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
                break;
            }
            if (runCP != null) {
                data.setClasspath(runCP);
            }
            if (bootCP != null && (platformSources = this.findPlatformSources(bootCP)) != null) {
                data.setPlatformSources(platformSources);
            }
        }
    }

    public void messageLogged(AntEvent event) {
        AntSession session = event.getSession();
        int messageLevel = event.getLogLevel();
        int sessionLevel = session.getVerbosity();
        SessionData data = this.getSessionData(session);
        String line = RemoteJavaAntLogger.removeCRLF(event.getMessage());
        StackTraceParse parse = RemoteJavaAntLogger.parseStackTraceLine(line);
        if (parse != null) {
            for (FileObject root : RemoteJavaAntLogger.getCurrentSourceRootsForClasspath(data)) {
                FileObject source = root.getFileObject(parse.resource);
                if (source == null) continue;
                parse.hyperlink(session, event, source, messageLevel, sessionLevel, data);
                break;
            }
            if (!event.isConsumed()) {
                FileObject source = GlobalPathRegistry.getDefault().findResource(parse.resource);
                if (source != null) {
                    parse.hyperlink(session, event, source, messageLevel, sessionLevel, data);
                } else if (messageLevel <= sessionLevel && TASKS_OF_INTEREST[0].equals(event.getTaskName())) {
                    event.consume();
                    session.println(line, event.getLogLevel() <= 1, null);
                }
            }
        } else {
            if (!this.isEmpty(line)) {
                session.println(line, false, null);
                data.lastExceptionMessage = null;
                data.possibleExceptionText = line;
            }
            event.consume();
        }
    }

    private static String removeCRLF(@NonNull String message) {
        int index = message.length() - 1;
        for (int len = 0; index >= 0 && len < 2 && (message.charAt(index) == '\r' || message.charAt(index) == '\n'); --index, ++len) {
        }
        return index == message.length() - 1 ? message : message.substring(0, index + 1);
    }

    private boolean isEmpty(@NonNull String str) {
        boolean res = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            res = false;
            break;
        }
        return res;
    }

    private static boolean isTest(FileObject root) {
        return UnitTestForSourceQuery.findSources((FileObject)root).length > 0;
    }

    @CheckForNull
    private ClassPath findPlatformSources(@NullAllowed ClassPath bootCP) {
        if (bootCP == null) {
            return null;
        }
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            ClassPath platformBootLibs = p.getBootstrapLibraries();
            if (!bootCP.toString().equals(platformBootLibs.toString())) continue;
            return p.getSourceFolders();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<FileObject> getCurrentSourceRootsForClasspath(SessionData data) {
        Collection<FileObject> result;
        if (data.classpath == null) {
            return Collections.emptySet();
        }
        SessionData sessionData = data;
        synchronized (sessionData) {
            result = data.classpathSourceRoots;
        }
        if (result == null) {
            result = new LinkedHashSet<FileObject>();
            for (ClassPath.Entry entry : data.classpath.entries()) {
                FileObject[] someRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots();
                result.addAll(Arrays.asList(someRoots));
            }
            if (data.platformSources != null) {
                result.addAll(Arrays.asList(data.platformSources.getRoots()));
            } else {
                JavaPlatform plat = JavaPlatform.getDefault();
                if (plat != null) {
                    result.addAll(Arrays.asList(plat.getSourceFolders().getRoots()));
                }
            }
            result = Collections.unmodifiableCollection(result);
            sessionData = data;
            synchronized (sessionData) {
                data.classpathSourceRoots = result;
            }
        }
        return result;
    }

    private static String guessExceptionMessage(SessionData data) {
        String pet = data.possibleExceptionText;
        String lem = data.lastExceptionMessage;
        if (pet != null) {
            if (lem == null) {
                Matcher m = EXCEPTION_MESSAGE.matcher(pet);
                if (m.matches()) {
                    data.lastExceptionMessage = lem = m.group(1);
                } else {
                    data.possibleExceptionText = null;
                }
            }
            return lem;
        }
        return null;
    }

    private static final class SessionData {
        public ClassPath platformSources = null;
        public ClassPath classpath = null;
        public volatile Collection<FileObject> classpathSourceRoots = null;
        public volatile String possibleExceptionText = null;
        public volatile String lastExceptionMessage = null;

        public void setClasspath(ClassPath cp) {
            this.classpath = cp;
            this.classpathSourceRoots = null;
        }

        public void setPlatformSources(ClassPath platformSources) {
            this.platformSources = platformSources;
            this.classpathSourceRoots = null;
        }
    }

    static final class StackTraceParse {
        final String line;
        final String resource;
        final int lineNumber;
        final String prePart;
        final String midPart;
        final String endPart;

        StackTraceParse(String line, String resource, int lineNumber, String prePart, String midPart, String endPart) {
            this.line = line;
            this.resource = resource;
            this.lineNumber = lineNumber;
            this.prePart = prePart;
            this.midPart = midPart;
            this.endPart = endPart;
        }

        public String toString() {
            return this.resource + ":" + this.lineNumber;
        }

        void hyperlink(AntSession session, AntEvent event, FileObject source, int messageLevel, int sessionLevel, SessionData data) {
            if (messageLevel <= sessionLevel && !event.isConsumed()) {
                OutputListener hyperlink = session.createStandardHyperlink(source.toURL(), RemoteJavaAntLogger.guessExceptionMessage(data), this.lineNumber, -1, -1, -1);
                event.consume();
                InputOutput io = session.getIO();
                if (IOColorPrint.isSupported((InputOutput)io)) {
                    try {
                        OutputWriter out = messageLevel <= 1 ? io.getErr() : io.getOut();
                        boolean important = this.prePart.contains("at ") && !this.prePart.contains("WARNING");
                        out.print(this.prePart);
                        IOColorPrint.print((InputOutput)io, (CharSequence)this.midPart, (OutputListener)hyperlink, (boolean)important, null);
                        out.println(this.endPart);
                        return;
                    }
                    catch (IOException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
                session.println(this.line, true, hyperlink);
            }
        }
    }
}

