/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.ui;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class CreateJREPanel
extends JPanel {
    private static final String HELP_ID = "java.j2seembedded.create-remote-platform";
    private static final String KEY_EJDK = "ejdk.home";
    private final JButton buttonCreate;
    private boolean valid = false;
    private JButton buttonBrowse;
    private JCheckBox checkBoxCharsets;
    private JCheckBox checkBoxDebug;
    private JCheckBox checkBoxFxControls;
    private JCheckBox checkBoxFxGraphics;
    private JCheckBox checkBoxKeepDebugInfo;
    private JCheckBox checkBoxLocales;
    private JCheckBox checkBoxNashorn;
    private JCheckBox checkBoxNoCompression;
    private JCheckBox checkBoxSunec;
    private JCheckBox checkBoxSunpkcs11;
    private JComboBox comboBoxProfile;
    private JComboBox comboBoxVM;
    private JSeparator jSeparator1;
    private JTextField jreCreateLocation;
    private JLabel labelError;
    private JLabel labelExtensions;
    private JLabel labelJRECreateInfo;
    private JLabel labelJRECreateLocation;
    private JLabel labelOptions;
    private JLabel labelProfile;
    private JLabel labelRemoteJREInfo;
    private JLabel labelRemoteJREPath;
    private JLabel labelVM;
    private JTextField remoteJREPath;

    private CreateJREPanel(@NonNull JButton okOption, @NullAllowed String username, @NullAllowed String host) {
        assert (username != null ? host != null : host == null);
        this.buttonCreate = okOption;
        this.buttonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateJREPanel.setEJDKHome(CreateJREPanel.this.jreCreateLocation.getText());
            }
        });
        this.initComponents();
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateJREPanel.this.validatePanel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateJREPanel.this.validatePanel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateJREPanel.this.validatePanel();
            }
        };
        this.jreCreateLocation.getDocument().addDocumentListener(docListener);
        this.remoteJREPath.getDocument().addDocumentListener(docListener);
        this.labelRemoteJREInfo.setText(NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelRemoteJREInfo.text", (Object)username, (Object)host));
        if (username == null || host == null) {
            this.labelRemoteJREPath.setVisible(false);
            this.remoteJREPath.setVisible(false);
            this.labelRemoteJREInfo.setVisible(false);
        } else {
            this.remoteJREPath.setText(NbBundle.getMessage(CreateJREPanel.class, (String)"LBL_JRE_Path_Default", (Object)username));
        }
        File path = CreateJREPanel.getEJDKHome();
        if (path != null) {
            this.jreCreateLocation.setText(path.getAbsolutePath());
        }
        this.validatePanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateJREPanel.this.remoteJREPath.requestFocusInWindow();
                CreateJREPanel.this.remoteJREPath.selectAll();
            }
        });
    }

    @CheckForNull
    public static List<String> configure(@NonNull File destFolder) {
        Parameters.notNull((CharSequence)"destFolder", (Object)destFolder);
        Pair<List<String>, String> data = CreateJREPanel.configureImpl(null, null, destFolder);
        return data == null ? null : (List)data.first();
    }

    @CheckForNull
    public static Pair<List<String>, String> configure(@NonNull String userName, @NonNull String host, @NonNull File destFolder) {
        Parameters.notNull((CharSequence)"destFolder", (Object)destFolder);
        Parameters.notNull((CharSequence)"userName", (Object)userName);
        Parameters.notNull((CharSequence)"host", (Object)host);
        return CreateJREPanel.configureImpl(userName, host, destFolder);
    }

    @CheckForNull
    private static Pair<List<String>, String> configureImpl(@NullAllowed String userName, @NullAllowed String host, @NonNull File destFolder) {
        JButton buttonCreate = new JButton(NbBundle.getMessage(CreateJREPanel.class, (String)"LBL_Dialog_Button_Create"));
        CreateJREPanel panel = new CreateJREPanel(buttonCreate, userName, host);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CreateJREPanel.class, (String)"LBL_CreateJRETitle"), true, new Object[]{buttonCreate, DialogDescriptor.CANCEL_OPTION}, (Object)0, 0, new HelpCtx(HELP_ID), null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(buttonCreate)) {
            if (!panel.isPanelValid()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateJREPanel.class, (String)"ERROR_Invalid_CreateJREPanel"), 2));
                return null;
            }
            ArrayList<String> cmdLine = new ArrayList<String>();
            File ejdk = new File(panel.getJRECreateLocation());
            File bin = new File(ejdk, "bin");
            File jrecreate = null;
            if (Utilities.isWindows()) {
                cmdLine.add("cmd");
                cmdLine.add("/c");
                jrecreate = new File(bin, "jrecreate.bat");
            } else {
                jrecreate = new File(bin, "jrecreate.sh");
            }
            cmdLine.add(jrecreate.getAbsolutePath());
            cmdLine.add("--dest");
            cmdLine.add(destFolder.getAbsolutePath());
            cmdLine.add("--ejdk-home");
            cmdLine.add(ejdk.getAbsolutePath());
            String profile = panel.getProfile();
            if (profile != null) {
                cmdLine.add("--profile");
                cmdLine.add(profile);
            }
            cmdLine.add("--vm");
            cmdLine.add(panel.getVirtualMachine());
            if (panel.isDebug()) {
                cmdLine.add("--debug");
            }
            if (panel.isKeepDebugInfo()) {
                cmdLine.add("--keep-debug-info");
            }
            if (panel.isNoCompression()) {
                cmdLine.add("--no-compression");
            }
            StringBuilder extensions = new StringBuilder();
            if (panel.isFxGraphics()) {
                extensions.append("fx:graphics");
            }
            if (panel.isFxControls()) {
                if (extensions.length() > 0) {
                    extensions.append(",");
                }
                extensions.append("fx:controls");
            }
            if (panel.isSunec()) {
                if (extensions.length() > 0) {
                    extensions.append(",");
                }
                extensions.append("sunec");
            }
            if (panel.isSunpkcs11()) {
                if (extensions.length() > 0) {
                    extensions.append(",");
                }
                extensions.append("sunpkcs11");
            }
            if (panel.isLocales()) {
                if (extensions.length() > 0) {
                    extensions.append(",");
                }
                extensions.append("locales");
            }
            if (panel.isCharsets()) {
                if (extensions.length() > 0) {
                    extensions.append(",");
                }
                extensions.append("charsets");
            }
            if (panel.isNashorn()) {
                if (extensions.length() > 0) {
                    extensions.append(",");
                }
                extensions.append("nashorn");
            }
            if (extensions.length() > 0) {
                cmdLine.add("--extension");
                cmdLine.add(extensions.toString());
            }
            return Pair.of(cmdLine, (Object)panel.getRemoteJREPath());
        }
        return null;
    }

    private void validatePanel() {
        if (this.jreCreateLocation.getText().isEmpty()) {
            this.labelError.setText(NbBundle.getMessage(CreateJREPanel.class, (String)"ERROR_JRE_Create"));
            this.valid = false;
            this.buttonCreate.setEnabled(false);
            return;
        }
        if (this.remoteJREPath.isVisible() && this.remoteJREPath.getText().isEmpty()) {
            this.labelError.setText(NbBundle.getMessage(CreateJREPanel.class, (String)"ERROR_JRE_Path"));
            this.valid = false;
            this.buttonCreate.setEnabled(false);
            return;
        }
        this.labelError.setText(null);
        this.valid = true;
        this.buttonCreate.setEnabled(true);
    }

    private void initComponents() {
        this.labelOptions = new JLabel();
        this.checkBoxDebug = new JCheckBox();
        this.checkBoxKeepDebugInfo = new JCheckBox();
        this.checkBoxNoCompression = new JCheckBox();
        this.labelProfile = new JLabel();
        this.comboBoxProfile = new JComboBox();
        this.comboBoxVM = new JComboBox();
        this.labelVM = new JLabel();
        this.labelExtensions = new JLabel();
        this.checkBoxFxGraphics = new JCheckBox();
        this.checkBoxFxControls = new JCheckBox();
        this.checkBoxSunec = new JCheckBox();
        this.checkBoxSunpkcs11 = new JCheckBox();
        this.checkBoxLocales = new JCheckBox();
        this.checkBoxCharsets = new JCheckBox();
        this.checkBoxNashorn = new JCheckBox();
        this.labelError = new JLabel();
        this.labelJRECreateLocation = new JLabel();
        this.jreCreateLocation = new JTextField();
        this.buttonBrowse = new JButton();
        this.labelJRECreateInfo = new JLabel();
        this.labelRemoteJREPath = new JLabel();
        this.remoteJREPath = new JTextField();
        this.labelRemoteJREInfo = new JLabel();
        this.jSeparator1 = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.labelOptions, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelOptions.text"));
        this.checkBoxDebug.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxDebug, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxDebug.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxKeepDebugInfo, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxKeepDebugInfo.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxNoCompression, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxNoCompression.text"));
        this.labelProfile.setLabelFor(this.comboBoxProfile);
        Mnemonics.setLocalizedText((JLabel)this.labelProfile, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelProfile.text"));
        this.comboBoxProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Compact1", "Compact2", "Compact3", "Full JRE"}));
        this.comboBoxProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateJREPanel.this.comboBoxProfileActionPerformed(evt);
            }
        });
        this.comboBoxVM.setModel(new DefaultComboBoxModel<String>(new String[]{"Minimal", "Client", "Server", "All"}));
        this.labelVM.setLabelFor(this.comboBoxVM);
        Mnemonics.setLocalizedText((JLabel)this.labelVM, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelVM.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelExtensions, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelExtensions.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxFxGraphics, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxFxGraphics.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxFxControls, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxFxControls.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxSunec, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxSunec.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxSunpkcs11, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxSunpkcs11.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxLocales, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxLocales.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxCharsets, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxCharsets.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxNashorn, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.checkBoxNashorn.text"));
        this.labelError.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.labelError, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelError.text"));
        this.labelJRECreateLocation.setLabelFor(this.labelJRECreateLocation);
        Mnemonics.setLocalizedText((JLabel)this.labelJRECreateLocation, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelJRECreateLocation.text"));
        this.jreCreateLocation.setText(NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.jreCreateLocation.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonBrowse, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.buttonBrowse.text"));
        this.buttonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateJREPanel.this.buttonBrowseActionPerformed(evt);
            }
        });
        this.labelJRECreateInfo.setFont(this.labelJRECreateInfo.getFont().deriveFont(this.labelJRECreateInfo.getFont().getStyle() | 2));
        Mnemonics.setLocalizedText((JLabel)this.labelJRECreateInfo, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelJRECreateInfo.text"));
        this.labelRemoteJREPath.setLabelFor(this.remoteJREPath);
        Mnemonics.setLocalizedText((JLabel)this.labelRemoteJREPath, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelRemoteJREPath.text"));
        this.remoteJREPath.setText(NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.remoteJREPath.text"));
        this.labelRemoteJREInfo.setFont(this.labelRemoteJREInfo.getFont().deriveFont(this.labelRemoteJREInfo.getFont().getStyle() | 2));
        Mnemonics.setLocalizedText((JLabel)this.labelRemoteJREInfo, (String)NbBundle.getMessage(CreateJREPanel.class, (String)"CreateJREPanel.labelRemoteJREInfo.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDebug).addComponent(this.checkBoxKeepDebugInfo).addComponent(this.checkBoxNoCompression)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelProfile).addComponent(this.labelVM)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboBoxVM, 0, -1, Short.MAX_VALUE).addComponent(this.comboBoxProfile, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelJRECreateLocation).addComponent(this.labelRemoteJREPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jreCreateLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonBrowse)).addComponent(this.remoteJREPath))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelOptions).addComponent(this.labelExtensions).addComponent(this.labelError).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxSunpkcs11).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxFxGraphics).addComponent(this.checkBoxFxControls).addComponent(this.checkBoxSunec)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxNashorn).addComponent(this.checkBoxCharsets).addComponent(this.checkBoxLocales)))))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelJRECreateInfo, -1, 380, Short.MAX_VALUE).addComponent(this.labelRemoteJREInfo, -2, 0, Short.MAX_VALUE)))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelJRECreateLocation).addComponent(this.jreCreateLocation, -2, -1, -2).addComponent(this.buttonBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelJRECreateInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelRemoteJREPath).addComponent(this.remoteJREPath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelRemoteJREInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelOptions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBoxDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxKeepDebugInfo, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxNoCompression).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelProfile).addComponent(this.comboBoxProfile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxVM, -2, -1, -2).addComponent(this.labelVM)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelExtensions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxFxGraphics).addComponent(this.checkBoxLocales)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxFxControls).addComponent(this.checkBoxCharsets)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxSunec).addComponent(this.checkBoxNashorn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxSunpkcs11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addComponent(this.labelError)));
    }

    private void buttonBrowseActionPerformed(ActionEvent evt) {
        String oldValue = this.jreCreateLocation.getText();
        JFileChooser chooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                if (EJDKFileView.isEJDK(this.getSelectedFile())) {
                    super.approveSelection();
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateJREPanel.class, (String)"TXT_InvalidEJDKFolder", (Object)this.getSelectedFile().getName()), 0));
                }
            }
        };
        chooser.setFileView(new EJDKFileView(chooser.getFileSystemView()));
        chooser.setFileSelectionMode(1);
        if (oldValue != null) {
            chooser.setSelectedFile(new File(oldValue));
        }
        chooser.setDialogTitle(NbBundle.getMessage(CreateJREPanel.class, (String)"Title_Chooser_SelectJRECreate"));
        if (chooser.showOpenDialog(this) == 0) {
            this.jreCreateLocation.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void comboBoxProfileActionPerformed(ActionEvent evt) {
        if (this.comboBoxProfile.getSelectedIndex() == 0 || this.comboBoxProfile.getSelectedIndex() == 1) {
            this.comboBoxVM.setSelectedIndex(0);
        } else if (this.comboBoxProfile.getSelectedIndex() == 2) {
            this.comboBoxVM.setSelectedIndex(1);
        } else if (this.comboBoxProfile.getSelectedIndex() == 3) {
            this.comboBoxVM.setSelectedIndex(3);
        }
    }

    public String getJRECreateLocation() {
        return this.jreCreateLocation.getText();
    }

    public String getRemoteJREPath() {
        return this.remoteJREPath.getText();
    }

    public String getProfile() {
        String profile = (String)this.comboBoxProfile.getSelectedItem();
        if (profile == null || profile.equals(this.comboBoxProfile.getModel().getElementAt(this.comboBoxProfile.getModel().getSize() - 1))) {
            return null;
        }
        return profile.toLowerCase();
    }

    public String getVirtualMachine() {
        return ((String)this.comboBoxVM.getSelectedItem()).toLowerCase();
    }

    public boolean isDebug() {
        return this.checkBoxDebug.isSelected();
    }

    public boolean isKeepDebugInfo() {
        return this.checkBoxKeepDebugInfo.isSelected();
    }

    public boolean isNoCompression() {
        return this.checkBoxNoCompression.isSelected();
    }

    public boolean isFxGraphics() {
        return this.checkBoxFxGraphics.isSelected();
    }

    public boolean isFxControls() {
        return this.checkBoxFxControls.isSelected();
    }

    public boolean isSunec() {
        return this.checkBoxSunec.isSelected();
    }

    public boolean isSunpkcs11() {
        return this.checkBoxSunpkcs11.isSelected();
    }

    public boolean isLocales() {
        return this.checkBoxLocales.isSelected();
    }

    public boolean isCharsets() {
        return this.checkBoxCharsets.isSelected();
    }

    public boolean isNashorn() {
        return this.checkBoxNashorn.isSelected();
    }

    public boolean isPanelValid() {
        return this.valid;
    }

    @CheckForNull
    private static File getEJDKHome() {
        Preferences prefs = NbPreferences.forModule(CreateJREPanel.class);
        String path = prefs.get(KEY_EJDK, null);
        return path == null ? null : new File(path);
    }

    private static void setEJDKHome(@NullAllowed String path) {
        Preferences prefs = NbPreferences.forModule(CreateJREPanel.class);
        prefs.put(KEY_EJDK, path == null || path.isEmpty() ? null : path);
    }

    private static final class EJDKFileView
    extends FileView {
        private static final Image BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/java/j2seembedded/resources/ejdkBadge.gif", (boolean)false);
        private static final ImageIcon EMPTY = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/j2seembedded/resources/empty.gif", (boolean)false);
        private final FileSystemView fsv;
        private Icon lastOrig;
        private Icon lastMerged;

        public EJDKFileView(@NonNull FileSystemView fsv) {
            this.fsv = fsv;
        }

        @Override
        public Icon getIcon(@NonNull File file) {
            File f = FileUtil.normalizeFile((File)file);
            Icon original = this.fsv.getSystemIcon(f);
            if (original == null) {
                original = EMPTY;
            }
            if (EJDKFileView.isEJDK(f)) {
                if (original.equals(this.lastOrig)) {
                    assert (this.lastMerged != null);
                    return this.lastMerged;
                }
                this.lastMerged = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.icon2Image((Icon)original), (Image)BADGE, (int)(original.getIconWidth() - BADGE.getWidth(null)), (int)(original.getIconHeight() - BADGE.getHeight(null))));
                this.lastOrig = original;
                return this.lastMerged;
            }
            return original;
        }

        static boolean isEJDK(@NonNull File folder) {
            int osId = Utilities.getOperatingSystem();
            if (osId == 8 || osId == 256) {
                return false;
            }
            String jrecreateName = Utilities.isWindows() ? "jrecreate.bat" : "jrecreate.sh";
            File jrecreate = new File(new File(folder, "bin"), jrecreateName);
            return jrecreate.exists();
        }
    }
}

