/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.api.scripting;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import netscape.javascript.JSObject;

final class ScriptObjectMirror
extends JSObject
implements Bindings {
    private final ScriptObject sobj;
    private final ScriptObject global;

    ScriptObjectMirror(ScriptObject sobj, ScriptObject global) {
        this.sobj = sobj;
        this.global = global;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ScriptObjectMirror) {
            return this.sobj.equals(((ScriptObjectMirror)other).sobj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.sobj.hashCode();
    }

    public String toString() {
        return this.inGlobal(new Callable<String>(){

            @Override
            public String call() {
                return ScriptRuntime.safeToString(ScriptObjectMirror.this.sobj);
            }
        });
    }

    private <V> V inGlobal(Callable<V> callable) {
        boolean globalChanged;
        ScriptObject oldGlobal = NashornScriptEngine.getNashornGlobal();
        boolean bl = globalChanged = oldGlobal != this.global;
        if (globalChanged) {
            NashornScriptEngine.setNashornGlobal(this.global);
        }
        try {
            V v = callable.call();
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Cannot happen", e);
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    @Override
    public Object call(String methodName, Object[] args) {
        boolean globalChanged;
        Object val = this.sobj.get(methodName);
        ScriptObject oldGlobal = NashornScriptEngine.getNashornGlobal();
        boolean bl = globalChanged = oldGlobal != this.global;
        if (val instanceof ScriptFunction) {
            Object[] modifiedArgs = ScriptObjectMirror.unwrapArray(args, this.global);
            if (modifiedArgs != null) {
                for (int i = 0; i < modifiedArgs.length; ++i) {
                    Object arg = modifiedArgs[i];
                    if (!(arg instanceof ScriptObject)) continue;
                    modifiedArgs[i] = ScriptObjectMirror.wrap(arg, oldGlobal);
                }
            }
            try {
                if (globalChanged) {
                    NashornScriptEngine.setNashornGlobal(this.global);
                }
                Object i = ScriptObjectMirror.wrap(((ScriptFunction)val).invoke(this.sobj, modifiedArgs), this.global);
                return i;
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (globalChanged) {
                    NashornScriptEngine.setNashornGlobal(oldGlobal);
                }
            }
        }
        throw new RuntimeException("No such method: " + methodName);
    }

    @Override
    public Object eval(final String s) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                Context context = AccessController.doPrivileged(new PrivilegedAction<Context>(){

                    @Override
                    public Context run() {
                        return Context.getContext();
                    }
                });
                return ScriptObjectMirror.wrap(context.eval(ScriptObjectMirror.this.global, s, null, null, false), ScriptObjectMirror.this.global);
            }
        });
    }

    @Override
    public Object getMember(final String name) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(name), ScriptObjectMirror.this.global);
            }
        });
    }

    @Override
    public Object getSlot(final int index) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(index), ScriptObjectMirror.this.global);
            }
        });
    }

    @Override
    public void removeMember(String name) {
        this.remove(name);
    }

    @Override
    public void setMember(String name, Object value) {
        this.put(name, ScriptObjectMirror.wrap(value, NashornScriptEngine.getNashornGlobal()));
    }

    @Override
    public void setSlot(final int index, final Object value) {
        this.inGlobal(new Callable<Void>(){

            @Override
            public Void call() {
                ScriptObjectMirror.this.sobj.set(index, ScriptObjectMirror.unwrap(value, ScriptObjectMirror.this.global), ScriptObjectMirror.this.global.isStrictContext());
                return null;
            }
        });
    }

    @Override
    public void clear() {
        this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                ScriptObjectMirror.this.sobj.clear();
                return null;
            }
        });
    }

    @Override
    public boolean containsKey(final Object key) {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.containsKey(ScriptObjectMirror.unwrap(key, ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public boolean containsValue(final Object value) {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.containsValue(ScriptObjectMirror.unwrap(value, ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.inGlobal(new Callable<Set<Map.Entry<String, Object>>>(){

            @Override
            public Set<Map.Entry<String, Object>> call() {
                Iterator<String> iter = ScriptObjectMirror.this.sobj.propertyIterator();
                HashSet<AbstractMap.SimpleImmutableEntry<String, Object>> entries = new HashSet<AbstractMap.SimpleImmutableEntry<String, Object>>();
                while (iter.hasNext()) {
                    String key = iter.next();
                    Object value = ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(key), ScriptObjectMirror.this.global));
                    entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, value));
                }
                return Collections.unmodifiableSet(entries);
            }
        });
    }

    @Override
    public Object get(final Object key) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(key), ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.isEmpty();
            }
        });
    }

    @Override
    public Set<String> keySet() {
        return this.inGlobal(new Callable<Set<String>>(){

            @Override
            public Set<String> call() {
                Iterator<String> iter = ScriptObjectMirror.this.sobj.propertyIterator();
                HashSet<String> keySet = new HashSet<String>();
                while (iter.hasNext()) {
                    keySet.add(iter.next());
                }
                return Collections.unmodifiableSet(keySet);
            }
        });
    }

    @Override
    public Object put(final String key, final Object value) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.this.sobj.put(key, ScriptObjectMirror.unwrap(value, ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public void putAll(final Map<? extends String, ? extends Object> map) {
        final boolean strict = this.sobj.isStrictContext();
        this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                for (Map.Entry entry : map.entrySet()) {
                    ScriptObjectMirror.this.sobj.set(entry.getKey(), ScriptObjectMirror.unwrap(entry.getValue(), ScriptObjectMirror.this.global), strict);
                }
                return null;
            }
        });
    }

    @Override
    public Object remove(final Object key) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.remove(ScriptObjectMirror.unwrap(key, ScriptObjectMirror.this.global)), ScriptObjectMirror.this.global);
            }
        });
    }

    @Override
    public int size() {
        return this.inGlobal(new Callable<Integer>(){

            @Override
            public Integer call() {
                return ScriptObjectMirror.this.sobj.size();
            }
        });
    }

    @Override
    public Collection<Object> values() {
        return this.inGlobal(new Callable<Collection<Object>>(){

            @Override
            public Collection<Object> call() {
                ArrayList<Object> values = new ArrayList<Object>(ScriptObjectMirror.this.size());
                Iterator<Object> iter = ScriptObjectMirror.this.sobj.valueIterator();
                while (iter.hasNext()) {
                    values.add(ScriptObjectMirror.wrap(iter.next(), ScriptObjectMirror.this.global));
                }
                return Collections.unmodifiableList(values);
            }
        });
    }

    ScriptObject getScriptObject() {
        return this.sobj;
    }

    static Object translateUndefined(Object obj) {
        return obj == ScriptRuntime.UNDEFINED ? null : obj;
    }

    static Object wrap(Object obj, ScriptObject homeGlobal) {
        return obj instanceof ScriptObject ? new ScriptObjectMirror((ScriptObject)obj, homeGlobal) : obj;
    }

    static Object unwrap(Object obj, ScriptObject homeGlobal) {
        if (obj instanceof ScriptObjectMirror) {
            ScriptObjectMirror mirror = (ScriptObjectMirror)obj;
            return mirror.global == homeGlobal ? mirror.sobj : obj;
        }
        return obj;
    }

    static Object[] wrapArray(Object[] args, ScriptObject homeGlobal) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] newArgs = new Object[args.length];
        int index = 0;
        for (Object obj : args) {
            newArgs[index] = ScriptObjectMirror.wrap(obj, homeGlobal);
            ++index;
        }
        return newArgs;
    }

    static Object[] unwrapArray(Object[] args, ScriptObject homeGlobal) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] newArgs = new Object[args.length];
        int index = 0;
        for (Object obj : args) {
            newArgs[index] = ScriptObjectMirror.unwrap(obj, homeGlobal);
            ++index;
        }
        return newArgs;
    }
}

