/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Frame;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.Namespace;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class FunctionNode
extends Block {
    @Ignore
    private IdentNode ident;
    private String name;
    private CompileUnit compileUnit;
    private MethodEmitter method;
    private Kind kind;
    private List<IdentNode> parameters;
    private List<FunctionNode> functions;
    private long firstToken;
    private long lastToken;
    private Frame frames;
    private final Namespace namespace;
    @Ignore
    private IdentNode thisNode;
    @Ignore
    private IdentNode scopeNode;
    @Ignore
    private IdentNode resultNode;
    @Ignore
    private IdentNode argumentsNode;
    @Ignore
    private IdentNode calleeNode;
    @Ignore
    private IdentNode varArgsNode;
    private final Stack<LabelNode> labelStack;
    private final Stack<Node> controlStack;
    @Ignore
    private final List<VarNode> declarations;
    @Ignore
    private VarNode funcVarNode;
    @Ignore
    private LineNumberNode funcVarLineNumberNode;
    @Ignore
    private Node selfSymbolInit;
    private int flags;
    private static final int IS_ANONYMOUS = 1;
    private static final int IS_STATEMENT = 2;
    private static final int IS_STRICT_MODE = 4;
    private static final int USES_ARGUMENTS = 8;
    private static final int IS_LOWERED = 16;
    private static final int IS_SPLIT = 32;
    private static final int IS_LAZY = 64;
    private static final int HAS_EVAL = 128;
    private static final int HAS_WITH = 256;
    private static final int HAS_DESCENDANT_WITH_OR_EVAL = 512;
    private static final int DEFINES_ARGUMENTS = 1024;
    private static final int NEEDS_SELF_SYMBOL = 2048;
    private static final int USES_ANCESTOR_SCOPE = 4096;
    private static final int HAS_DEEP_WITH_OR_EVAL = 896;
    private static final int HAS_ALL_VARS_IN_SCOPE = 928;
    private static final int MAYBE_NEEDS_ARGUMENTS = 136;
    private static final int NEEDS_PARENT_SCOPE = 4992;
    private Type returnType = Type.UNKNOWN;
    @Ignore
    private List<Block> referencingParentBlocks;

    public FunctionNode(Source source, long token, int finish, Compiler compiler, Block parent, IdentNode ident, String name) {
        super(source, token, finish, parent, null);
        this.ident = ident;
        this.name = name;
        this.kind = Kind.NORMAL;
        this.parameters = new ArrayList<IdentNode>();
        this.functions = new ArrayList<FunctionNode>();
        this.firstToken = token;
        this.lastToken = token;
        this.namespace = new Namespace(compiler.getNamespace().getParent());
        this.labelStack = new Stack();
        this.controlStack = new Stack();
        this.declarations = new ArrayList<VarNode>();
        this.function = this;
    }

    private FunctionNode(FunctionNode functionNode, Node.CopyState cs) {
        super(functionNode, cs);
        this.ident = (IdentNode)cs.existingOrCopy(functionNode.ident);
        this.name = functionNode.name;
        this.kind = functionNode.kind;
        this.parameters = new ArrayList<IdentNode>();
        for (IdentNode param : functionNode.getParameters()) {
            this.parameters.add((IdentNode)cs.existingOrCopy(param));
        }
        this.functions = new ArrayList<FunctionNode>();
        this.firstToken = functionNode.firstToken;
        this.lastToken = functionNode.lastToken;
        this.namespace = functionNode.getNamespace();
        this.thisNode = (IdentNode)cs.existingOrCopy(functionNode.thisNode);
        this.scopeNode = (IdentNode)cs.existingOrCopy(functionNode.scopeNode);
        this.resultNode = (IdentNode)cs.existingOrCopy(functionNode.resultNode);
        this.argumentsNode = (IdentNode)cs.existingOrCopy(functionNode.argumentsNode);
        this.varArgsNode = (IdentNode)cs.existingOrCopy(functionNode.varArgsNode);
        this.calleeNode = (IdentNode)cs.existingOrCopy(functionNode.calleeNode);
        this.labelStack = new Stack();
        this.controlStack = new Stack();
        this.declarations = new ArrayList<VarNode>();
        for (VarNode decl : functionNode.getDeclarations()) {
            this.declarations.add((VarNode)cs.existingOrCopy(decl));
        }
        this.flags = functionNode.flags;
        this.funcVarNode = (VarNode)cs.existingOrCopy(functionNode.funcVarNode);
        this.function = this;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return FunctionNode.fixBlockChain(new FunctionNode(this, cs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node accept(NodeVisitor visitor) {
        FunctionNode saveFunctionNode = visitor.getCurrentFunctionNode();
        Block saveBlock = visitor.getCurrentBlock();
        visitor.setCurrentFunctionNode(this);
        visitor.setCurrentCompileUnit(this.getCompileUnit());
        visitor.setCurrentMethodEmitter(this.getMethodEmitter());
        visitor.setCurrentBlock(this);
        try {
            if (visitor.enter(this) != null) {
                int i;
                if (this.ident != null) {
                    this.ident = (IdentNode)this.ident.accept(visitor);
                }
                int count = this.parameters.size();
                for (i = 0; i < count; ++i) {
                    this.parameters.set(i, (IdentNode)this.parameters.get(i).accept(visitor));
                }
                count = this.functions.size();
                for (i = 0; i < count; ++i) {
                    this.functions.set(i, (FunctionNode)this.functions.get(i).accept(visitor));
                }
                count = this.statements.size();
                for (i = 0; i < count; ++i) {
                    this.statements.set(i, ((Node)this.statements.get(i)).accept(visitor));
                }
                Node node = visitor.leave(this);
                visitor.setCurrentBlock(saveBlock);
                visitor.setCurrentFunctionNode(saveFunctionNode);
                visitor.setCurrentCompileUnit(saveFunctionNode != null ? saveFunctionNode.getCompileUnit() : null);
                visitor.setCurrentMethodEmitter(saveFunctionNode != null ? saveFunctionNode.getMethodEmitter() : null);
                return node;
            }
            visitor.setCurrentBlock(saveBlock);
            visitor.setCurrentFunctionNode(saveFunctionNode);
            visitor.setCurrentCompileUnit(saveFunctionNode != null ? saveFunctionNode.getCompileUnit() : null);
            visitor.setCurrentMethodEmitter(saveFunctionNode != null ? saveFunctionNode.getMethodEmitter() : null);
        }
        catch (Throwable throwable) {
            visitor.setCurrentBlock(saveBlock);
            visitor.setCurrentFunctionNode(saveFunctionNode);
            visitor.setCurrentCompileUnit(saveFunctionNode != null ? saveFunctionNode.getCompileUnit() : null);
            visitor.setCurrentMethodEmitter(saveFunctionNode != null ? saveFunctionNode.getMethodEmitter() : null);
            throw throwable;
        }
        return this;
    }

    public FunctionNode findParentFunction() {
        return this.getParent() != null ? this.getParent().getFunction() : null;
    }

    @Override
    public void addParentName(StringBuilder sb) {
        if (!this.isScript()) {
            sb.append(this.getName());
            sb.append("$");
        }
    }

    @Override
    public boolean needsScope() {
        return super.needsScope() || this.isScript();
    }

    public final Frame pushFrame() {
        this.frames = new Frame(this.frames);
        return this.frames;
    }

    public final void popFrame() {
        this.frames = this.frames.getPrevious();
    }

    public String uniqueName(String base) {
        return this.namespace.uniqueName(base);
    }

    public Symbol newTemporary(Frame currentFrame, Type type, Node node) {
        assert (currentFrame != null);
        Symbol symbol = node.getSymbol();
        if (symbol == null) {
            String uname = this.uniqueName(CompilerConstants.TEMP_PREFIX.tag());
            symbol = new Symbol(uname, 1, type);
            symbol.setNode(node);
        }
        if (!symbol.hasSlot()) {
            currentFrame.addSymbol(symbol);
        }
        node.setSymbol(symbol);
        return symbol;
    }

    public Symbol newTemporary(Type type, Node node) {
        return this.newTemporary(this.frames, type, node);
    }

    public Symbol newLiteral(LiteralNode<?> literalNode) {
        String uname = this.uniqueName(CompilerConstants.LITERAL_PREFIX.tag());
        Symbol sym = new Symbol(uname, 5, literalNode.getType());
        sym.setNode(literalNode);
        literalNode.setSymbol(sym);
        return sym;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('[');
        sb.append(this.returnType);
        sb.append(']');
        sb.append(' ');
        sb.append("function");
        if (this.ident != null) {
            sb.append(' ');
            this.ident.toString(sb);
        }
        sb.append('(');
        boolean first = true;
        for (IdentNode parameter : this.parameters) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            parameter.toString(sb);
        }
        sb.append(')');
    }

    public boolean isScript() {
        return this.getParent() == null;
    }

    public Stack<Node> getControlStack() {
        return this.controlStack;
    }

    public boolean isLazy() {
        return (this.flags & 0x40) != 0;
    }

    public void setIsLazy(boolean isLazy) {
        this.flags = isLazy ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
    }

    public boolean hasWith() {
        return (this.flags & 0x100) != 0;
    }

    public void setHasWith() {
        if (!this.hasWith()) {
            this.flags |= 0x100;
            this.markParentForWithOrEval();
        }
    }

    private void markParentForWithOrEval() {
        this.setNeedsScope();
        FunctionNode parentFunction = this.findParentFunction();
        if (parentFunction != null) {
            parentFunction.setDescendantHasWithOrEval();
        }
    }

    private void setDescendantHasWithOrEval() {
        if ((this.flags & 0x200) == 0) {
            this.flags |= 0x200;
            this.markParentForWithOrEval();
        }
    }

    public boolean hasEval() {
        return (this.flags & 0x80) != 0;
    }

    public void setHasEval() {
        if (!this.hasEval()) {
            this.flags |= 0x80;
            this.markParentForWithOrEval();
        }
    }

    public boolean hasDeepWithOrEval() {
        return (this.flags & 0x380) != 0;
    }

    public long getFirstToken() {
        return this.firstToken;
    }

    public void setFirstToken(long firstToken) {
        this.firstToken = firstToken;
    }

    public List<FunctionNode> getFunctions() {
        return Collections.unmodifiableList(this.functions);
    }

    public Stack<LabelNode> getLabelStack() {
        return this.labelStack;
    }

    public IdentNode getVarArgsNode() {
        return this.varArgsNode;
    }

    public void setVarArgsNode(IdentNode varArgsNode) {
        this.varArgsNode = varArgsNode;
    }

    public IdentNode getCalleeNode() {
        return this.calleeNode;
    }

    public void setCalleeNode(IdentNode calleeNode) {
        this.calleeNode = calleeNode;
    }

    public boolean needsCallee() {
        return this.needsParentScope() || this.needsSelfSymbol() || this.needsArguments() && !this.isStrictMode();
    }

    public IdentNode getArgumentsNode() {
        return this.argumentsNode;
    }

    public void setArgumentsNode(IdentNode argumentsNode) {
        this.argumentsNode = argumentsNode;
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    public void setIdent(IdentNode ident) {
        this.ident = ident;
    }

    public boolean isVarArg() {
        return this.needsArguments() || this.parameters.size() > 250;
    }

    public void setDefinesArguments() {
        this.flags |= 0x400;
    }

    public boolean needsArguments() {
        return (this.flags & 0x88) != 0 && (this.flags & 0x400) == 0 && !this.isScript();
    }

    public void setUsesArguments() {
        this.flags |= 8;
    }

    public boolean needsParentScope() {
        return (this.flags & 0x1380) != 0 || this.isScript();
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public long getLastToken() {
        return this.lastToken;
    }

    public void setLastToken(long lastToken) {
        this.lastToken = lastToken;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean varsInScope() {
        return this.isScript() || (this.flags & 0x3A0) != 0;
    }

    public boolean isSplit() {
        return (this.flags & 0x20) != 0;
    }

    public void setIsSplit() {
        this.flags |= 0x20;
        this.setNeedsScope();
    }

    public List<IdentNode> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void setParameters(List<IdentNode> parameters) {
        this.parameters = parameters;
    }

    public IdentNode getResultNode() {
        return this.resultNode;
    }

    public void setResultNode(IdentNode resultNode) {
        this.resultNode = resultNode;
    }

    public IdentNode getScopeNode() {
        return this.scopeNode;
    }

    public void setScopeNode(IdentNode scopeNode) {
        this.scopeNode = scopeNode;
    }

    public boolean isStatement() {
        return (this.flags & 2) != 0;
    }

    public void setIsStatement() {
        this.flags |= 2;
    }

    public boolean isAnonymous() {
        return (this.flags & 1) != 0;
    }

    public void setIsAnonymous() {
        this.flags |= 1;
    }

    public boolean needsSelfSymbol() {
        return (this.flags & 0x800) != 0;
    }

    public Node getSelfSymbolInit() {
        return this.selfSymbolInit;
    }

    public void setNeedsSelfSymbol(Node selfSymbolInit) {
        this.flags |= 0x800;
        this.selfSymbolInit = selfSymbolInit;
    }

    public void setUsesGlobalSymbol() {
        this.flags |= 0x1000;
        FunctionNode parentFn = this.findParentFunction();
        if (parentFn != null) {
            parentFn.setUsesGlobalSymbol();
        }
    }

    public void setUsesScopeSymbol(Symbol symbol) {
        if (symbol.getBlock() == this) {
            this.setNeedsScope();
        } else {
            this.flags |= 0x1000;
            FunctionNode parentFn = this.findParentFunction();
            if (parentFn != null) {
                parentFn.setUsesScopeSymbol(symbol);
            }
        }
    }

    public IdentNode getThisNode() {
        return this.thisNode;
    }

    public void setThisNode(IdentNode thisNode) {
        this.thisNode = thisNode;
    }

    public VarNode getFunctionVarNode() {
        return this.funcVarNode;
    }

    public void setFunctionVarNode(VarNode varNode) {
        this.funcVarNode = varNode;
    }

    public LineNumberNode getFunctionVarLineNumberNode() {
        return this.funcVarLineNumberNode;
    }

    public void setFunctionVarNode(VarNode varNode, LineNumberNode lineNumber) {
        this.funcVarNode = varNode;
        this.funcVarLineNumberNode = lineNumber;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Type getType() {
        return this.getReturnType();
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Type returnType) {
        this.returnType = Type.widest(this.returnType, returnType.isObject() ? Type.OBJECT : returnType);
    }

    public void setStrictMode(boolean isStrictMode) {
        this.flags = isStrictMode ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public boolean isStrictMode() {
        return (this.flags & 4) != 0;
    }

    public void setIsLowered() {
        this.flags |= 0x10;
    }

    public boolean isLowered() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public void addFunction(FunctionNode functionNode) {
        assert (functionNode != null);
        this.functions.add(functionNode);
    }

    @Override
    public void addFunctions(List<FunctionNode> functionNodes) {
        this.functions.addAll(functionNodes);
    }

    @Override
    public void setFunctions(List<FunctionNode> functionNodes) {
        this.functions = functionNodes;
    }

    public void addDeclaration(VarNode varNode) {
        this.declarations.add(varNode);
    }

    public List<VarNode> getDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    public CompileUnit getCompileUnit() {
        return this.compileUnit;
    }

    public void setCompileUnit(CompileUnit compileUnit) {
        this.compileUnit = compileUnit;
    }

    public MethodEmitter getMethodEmitter() {
        return this.method;
    }

    public void setMethodEmitter(MethodEmitter method) {
        this.method = method;
    }

    public void addReferencingParentBlock(Block parentBlock) {
        assert (parentBlock.getFunction() == this.function.findParentFunction());
        if (parentBlock != this.function.getParent()) {
            if (this.referencingParentBlocks == null) {
                this.referencingParentBlocks = new LinkedList<Block>();
            }
            this.referencingParentBlocks.add(parentBlock);
        }
    }

    public List<Block> getReferencingParentBlocks() {
        if (this.referencingParentBlocks == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.referencingParentBlocks);
    }

    public static enum Kind {
        NORMAL,
        SCRIPT,
        GETTER,
        SETTER;

    }
}

