/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.runtime.Source;

public class LineNumberNode
extends Node {
    private final int lineNumber;

    public LineNumberNode(Source source, long token, int lineNumber) {
        super(source, token, Token.descPosition(token));
        this.lineNumber = lineNumber;
    }

    private LineNumberNode(LineNumberNode lineNumberNode) {
        super(lineNumberNode);
        this.lineNumber = lineNumberNode.getLineNumber();
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new LineNumberNode(this);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("[|");
        sb.append(this.lineNumber);
        sb.append("|]");
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public boolean isDebug() {
        return true;
    }
}

