/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.PrototypeObject;
import jdk.nashorn.internal.runtime.GlobalFunctions;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;

public class ScriptFunctionImpl
extends ScriptFunction {
    private static final MethodHandle BOUND_FUNCTION = ScriptFunctionImpl.findOwnMH("boundFunction", Object.class, ScriptFunction.class, Object.class, Object[].class, Object.class, Object[].class);
    private static final MethodHandle BOUND_CONSTRUCTOR = ScriptFunctionImpl.findOwnMH("boundConstructor", Object.class, ScriptFunction.class, Object[].class, Object.class, Object[].class);
    private static final PropertyMap nasgenmap$;
    private static ScriptFunction typeErrorThrower;
    private static PropertyMap strictmodemap$;

    ScriptFunctionImpl(String name, MethodHandle invokeHandle, MethodHandle[] specs) {
        super(name, invokeHandle, nasgenmap$, null, specs, false, true);
        this.init();
    }

    ScriptFunctionImpl(String name, MethodHandle invokeHandle, PropertyMap map, MethodHandle[] specs) {
        super(name, invokeHandle, map.addAll(nasgenmap$), null, specs, false, true);
        this.init();
    }

    ScriptFunctionImpl(String name, MethodHandle methodHandle, ScriptObject scope, MethodHandle[] specs, boolean strict, boolean builtin) {
        super(name, methodHandle, ScriptFunctionImpl.getMap(strict), scope, specs, strict, builtin);
        this.init();
    }

    public ScriptFunctionImpl(ScriptFunctionData data, MethodHandle methodHandle, ScriptObject scope, MethodHandle allocator) {
        super(data, ScriptFunctionImpl.getMap(data.isStrict()), scope);
        if (data.getInvoker() == null) {
            data.setMethodHandles(methodHandle, allocator);
        }
        this.init();
    }

    static synchronized ScriptFunction getTypeErrorThrower() {
        if (typeErrorThrower == null) {
            ScriptFunctionImpl func = new ScriptFunctionImpl("TypeErrorThrower", Lookup.TYPE_ERROR_THROWER_SETTER, null, null, false, false);
            func.setConstructHandle(null);
            func.setPrototype(ScriptRuntime.UNDEFINED);
            typeErrorThrower = func;
        }
        return typeErrorThrower;
    }

    static synchronized PropertyMap newThrowerProperty(PropertyMap map, String name, int flags) {
        return map.newProperty(name, flags, Lookup.TYPE_ERROR_THROWER_GETTER, Lookup.TYPE_ERROR_THROWER_SETTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyMap getMap(boolean strict) {
        if (strict) {
            Class<ScriptFunctionImpl> clazz = ScriptFunctionImpl.class;
            synchronized (ScriptFunctionImpl.class) {
                if (strictmodemap$ == null) {
                    strictmodemap$ = nasgenmap$;
                    strictmodemap$ = ScriptFunctionImpl.newThrowerProperty(strictmodemap$, "arguments", 6);
                    strictmodemap$ = ScriptFunctionImpl.newThrowerProperty(strictmodemap$, "caller", 6);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return strictmodemap$;
            }
        }
        return nasgenmap$;
    }

    static ScriptFunctionImpl newAnonymousFunction() {
        return new AnonymousFunction();
    }

    public static ScriptFunction makeFunction(String name, MethodHandle methodHandle, MethodHandle[] specs, boolean strict) {
        ScriptFunctionImpl func = new ScriptFunctionImpl(name, methodHandle, null, specs, strict, true);
        func.setConstructHandle(null);
        func.setPrototype(ScriptRuntime.UNDEFINED);
        return func;
    }

    public static ScriptFunction makeFunction(String name, MethodHandle methodHandle, MethodHandle[] specs) {
        return ScriptFunctionImpl.makeFunction(name, methodHandle, specs, false);
    }

    public static ScriptFunction makeFunction(String name, MethodHandle methodHandle) {
        return ScriptFunctionImpl.makeFunction(name, methodHandle, null);
    }

    @Override
    public ScriptFunction makeBoundFunction(Object thiz, Object[] args) {
        Object[] allArgs = args;
        if (allArgs == null) {
            allArgs = ScriptRuntime.EMPTY_ARRAY;
        }
        Object boundThiz = this.convertThisObject(thiz);
        MethodHandle boundMethod = Lookup.MH.insertArguments(BOUND_FUNCTION, 0, this, boundThiz, allArgs);
        ScriptFunction boundFunc = ScriptFunctionImpl.makeFunction("", boundMethod, null, true);
        MethodHandle consHandle = this.getConstructHandle();
        if (consHandle != null) {
            consHandle = Lookup.MH.insertArguments(BOUND_CONSTRUCTOR, 0, this, allArgs);
        }
        boundFunc.setConstructHandle(consHandle);
        int newArity = this.getArity();
        if (newArity != -1) {
            newArity -= Math.min(newArity, allArgs.length);
        }
        boundFunc.setArity(newArity);
        return boundFunc;
    }

    private static Object boundFunction(ScriptFunction wrapped, Object boundThiz, Object[] boundArgs, Object thiz, Object[] args) {
        Object[] allArgs = new Object[boundArgs.length + args.length];
        System.arraycopy(boundArgs, 0, allArgs, 0, boundArgs.length);
        System.arraycopy(args, 0, allArgs, boundArgs.length, args.length);
        return ScriptRuntime.apply(wrapped, boundThiz, allArgs);
    }

    private static Object boundConstructor(ScriptFunction wrapped, Object[] boundArgs, Object thiz, Object[] args) {
        Object[] allArgs = new Object[boundArgs.length + args.length];
        System.arraycopy(boundArgs, 0, allArgs, 0, boundArgs.length);
        System.arraycopy(args, 0, allArgs, boundArgs.length, args.length);
        return ScriptRuntime.construct(wrapped, allArgs);
    }

    @Override
    protected final ScriptObject getObjectPrototype() {
        return Global.objectPrototype();
    }

    private void init() {
        this.setProto(Global.instance().getFunctionPrototype());
        this.setPrototype(new PrototypeObject(this));
        if (this.isStrict()) {
            ScriptFunction func = ScriptFunctionImpl.getTypeErrorThrower();
            this.setUserAccessors("arguments", func, func);
            this.setUserAccessors("caller", func, func);
        }
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        try {
            return MethodHandles.lookup().findStatic(ScriptFunctionImpl.class, name, Lookup.MH.type(rtype, types));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new MethodHandleFactory.LookupException(e);
        }
    }

    static {
        PropertyMap map = PropertyMap.newMap(ScriptFunctionImpl.class);
        map = Lookup.newProperty(map, "prototype", 6, G$PROTOTYPE, S$PROTOTYPE);
        map = Lookup.newProperty(map, "length", 7, G$LENGTH, null);
        nasgenmap$ = map = Lookup.newProperty(map, "name", 7, G$NAME, null);
    }

    private static class AnonymousFunction
    extends ScriptFunctionImpl {
        private static final PropertyMap nasgenmap$$ = PropertyMap.newMap(AnonymousFunction.class);

        AnonymousFunction() {
            super("", GlobalFunctions.ANONYMOUS, nasgenmap$$, null);
        }
    }
}

