/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.preferences;

import java.io.File;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.codeception.preferences.Bundle;
import org.netbeans.modules.php.codeception.preferences.CodeceptionPreferences;
import org.netbeans.modules.php.codeception.util.CodeceptionUtils;
import org.openide.filesystems.FileUtil;

public final class CodeceptionPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public CodeceptionPreferencesValidator validate(PhpModule phpModule) {
        this.validateCodecept(CodeceptionPreferences.isCustomCodeceptEnabled(phpModule), CodeceptionPreferences.getCustomCodeceptPath(phpModule));
        return this;
    }

    public CodeceptionPreferencesValidator validateCodecept(boolean codeceptEnabled, @NullAllowed String codeceptPath) {
        String warning;
        if (codeceptEnabled && (warning = CodeceptionUtils.validateCodeceptPath(codeceptPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"codeceptPath", warning));
        }
        return this;
    }

    public CodeceptionPreferencesValidator validateCodeceptionYml(boolean codeceptionYmlEnabled, @NullAllowed String codeceptionYmlPath) {
        if (codeceptionYmlEnabled) {
            String fileName;
            File file;
            this.validatePath(codeceptionYmlEnabled, codeceptionYmlPath, "codeception.yml", "codeceptionYmlPath");
            if (codeceptionYmlPath != null && (file = new File(codeceptionYmlPath)).exists() && !"codeception.yml".equals(fileName = FileUtil.toFileObject((File)file).getNameExt())) {
                this.result.addWarning(new ValidationResult.Message((Object)"codeceptionYmlPath", Bundle.CodeceptionPreferencesValidator_incorrect_codeception_yml_fileName()));
            }
        }
        return this;
    }

    private void validatePath(boolean pathEnabled, String path, String label, String source) {
        if (!pathEnabled) {
            return;
        }
        String warning = FileUtils.validateFile((String)label, (String)path, (boolean)false);
        if (warning != null) {
            this.result.addError(new ValidationResult.Message((Object)source, warning));
        }
    }

    public ValidationResult getResult() {
        return this.result;
    }
}

