/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;

public final class MyRandomAccessFile
extends RandomAccessFile {
    private static final int MAX_BUF_SIZE = 0x100000;
    private MappedByteBuffer buffer;
    private long bufferShift;
    private long bufferSize;
    private final FileChannel channel;
    private boolean doSeek = false;
    private long postponedSeek = 0L;
    private final String fileName;

    public MyRandomAccessFile(String fileName) throws IOException {
        super(fileName, "r");
        this.fileName = fileName;
        this.channel = this.getChannel();
        this.bufferSize = Math.min(this.channel.size(), 1048575L);
        this.bufferShift = 0L;
        try {
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
        }
        catch (IOException ex) {
            this.channel.close();
            this.close();
            throw ex;
        }
    }

    public int read() throws IOException {
        if (this.doSeek) {
            this.doSeek = false;
            this._seek(this.postponedSeek);
        }
        if (this.buffer.remaining() == 0) {
            if (this.bufferShift + this.bufferSize < this.channel.size()) {
                long position = this.bufferShift + this.bufferSize;
                this.bufferShift += 524288L;
                this.bufferSize = Math.min(this.channel.size() - this.bufferShift, 1048575L);
                ByteOrder order = this.buffer.order();
                this.buffer.clear();
                this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
                this.buffer.order(order);
                this.buffer.position((int)(position - this.bufferShift));
                return this.read();
            }
            return -1;
        }
        return 0xFF & this.buffer.get();
    }

    public MappedByteBuffer getBuffer() throws IOException {
        if (this.doSeek) {
            this.doSeek = false;
            this._seek(this.postponedSeek);
        }
        return this.buffer;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.doSeek) {
            this.doSeek = false;
            this._seek(this.postponedSeek);
        }
        if (this.buffer.remaining() >= len) {
            this.buffer.get(b, off, len);
            return len;
        }
        long position = this.getFilePointer();
        if (position >= this.channel.size()) {
            return -1;
        }
        this.bufferShift = Math.max(position - 524288L, 0L);
        this.bufferSize = Math.min(this.channel.size() - this.bufferShift, 1048575L);
        ByteOrder order = this.buffer.order();
        this.buffer.clear();
        this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
        this.buffer.order(order);
        this.buffer.position((int)(position - this.bufferShift));
        if (len <= this.buffer.remaining()) {
            this.buffer.get(b, off, len);
            return len;
        }
        len = this.buffer.remaining();
        this.buffer.get(b, off, len);
        return len;
    }

    public int remaining() throws IOException {
        if (this.doSeek) {
            this.doSeek = false;
            this._seek(this.postponedSeek);
        }
        return this.buffer.remaining();
    }

    public long getFilePointer() throws IOException {
        if (this.doSeek) {
            return this.postponedSeek;
        }
        return (long)this.buffer.position() + this.bufferShift;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L || pos > this.channel.size()) {
            throw new IOException("Wrong position " + pos);
        }
        this.doSeek = true;
        this.postponedSeek = pos;
    }

    private void _seek(long pos) throws IOException {
        long filePointer = this.getFilePointer();
        if (pos == filePointer) {
            return;
        }
        if (pos >= this.bufferShift && pos < this.bufferShift + this.bufferSize) {
            this.buffer.position((int)(pos - this.bufferShift));
        } else {
            this.bufferShift = Math.max(pos - 524288L, 0L);
            this.bufferSize = Math.min(this.channel.size() - this.bufferShift, 1048575L);
            ByteOrder order = this.buffer.order();
            this.buffer.clear();
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
            this.buffer.order(order);
            this.buffer.position((int)(pos - this.bufferShift));
        }
    }

    public void dispose() {
        try {
            this.buffer.clear();
            this.channel.close();
            this.close();
        }
        catch (IOException ex) {
            Dwarf.LOG.log(Level.INFO, "Cannot close file " + this.fileName, ex);
        }
    }
}

