/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SearchPanel
extends JPanel {
    private static final long serialVersionUID = 26389784456741L;
    private final RequestProcessor rp;
    private final UiUtils.SearchWindow.SearchWindowSupport support;
    private List<String> foundItems;
    private DialogDescriptor descriptor;
    private RequestProcessor.Task detectTask;
    private JLabel detectedFilesLabel;
    private JList<String> foundItemsList;
    private JScrollPane foundItemsScrollPane;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    private SearchPanel(UiUtils.SearchWindow.SearchWindowSupport support) {
        assert (support != null);
        this.support = support;
        this.initComponents();
        this.rp = new RequestProcessor("PHP Search Panel detection thread (" + support.getPleaseWaitPart() + ")", 1, true);
        Mnemonics.setLocalizedText((JLabel)this.detectedFilesLabel, (String)support.getListTitle());
        this.messageLabel.setText(NbBundle.getMessage(SearchPanel.class, (String)"LBL_PleaseWait", (Object)support.getPleaseWaitPart()));
    }

    public static SearchPanel create(UiUtils.SearchWindow.SearchWindowSupport support) {
        return new SearchPanel(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, this.support.getWindowTitle(), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.cancelDetection();
            }
        });
        if (this.foundItems == null) {
            this.descriptor.setValid(false);
            this.foundItemsList.setEnabled(true);
            this.progressBar.setIndeterminate(true);
            this.detectTask = this.rp.create(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    final List<String> allItems = SearchPanel.this.support.detect();
                    assert (allItems != null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchPanel.this.updateFoundItems(allItems);
                        }
                    });
                }
            });
            this.detectTask.schedule(0);
        } else {
            this.updateFoundItems(this.foundItems);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return this.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public List<String> getFoundItems() {
        return this.foundItems;
    }

    public String getSelectedItem() {
        return this.foundItemsList.getSelectedValue();
    }

    void cancelDetection() {
        if (this.detectTask != null) {
            this.detectTask.cancel();
        }
    }

    void updateFoundItems(List<String> foundItems) {
        this.foundItems = foundItems;
        this.foundItemsList.setEnabled(true);
        this.foundItemsList.setListData((String[])foundItems.toArray(new String[foundItems.size()]));
        String message = null;
        if (foundItems.isEmpty()) {
            message = this.support.getNoItemsFound();
        } else {
            message = " ";
            this.foundItemsList.setSelectedIndex(0);
        }
        this.messageLabel.setText(message);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(this.getBackground());
        this.descriptor.setValid(true);
    }

    private void initComponents() {
        this.detectedFilesLabel = new JLabel();
        this.foundItemsScrollPane = new JScrollPane();
        this.foundItemsList = new JList();
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.detectedFilesLabel.setLabelFor(this.foundItemsList);
        Mnemonics.setLocalizedText((JLabel)this.detectedFilesLabel, (String)"title");
        this.foundItemsList.setSelectionMode(0);
        this.foundItemsList.setEnabled(false);
        this.foundItemsScrollPane.setViewportView(this.foundItemsList);
        this.foundItemsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersList.AccessibleContext.accessibleName"));
        this.foundItemsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersList.AccessibleContext.accessibleDescription"));
        this.messageLabel.setLabelFor(this.progressBar);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)"please wait...");
        this.progressBar.setString(" ");
        this.progressBar.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.foundItemsScrollPane, GroupLayout.Alignment.LEADING, -1, 291, Short.MAX_VALUE).addComponent(this.progressBar, GroupLayout.Alignment.LEADING, -1, 291, Short.MAX_VALUE).addComponent(this.detectedFilesLabel, GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.detectedFilesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.foundItemsScrollPane, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addGap(0, 0, 0)));
        this.detectedFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.detectedFilesLabel.AccessibleContext.accessibleName"));
        this.detectedFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.detectedFilesLabel.AccessibleContext.accessibleDescription"));
        this.foundItemsScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersScrollPane.AccessibleContext.accessibleName"));
        this.foundItemsScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersScrollPane.AccessibleContext.accessibleDescription"));
        this.messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.messageLabel.AccessibleContext.accessibleName"));
        this.messageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.messageLabel.AccessibleContext.accessibleDescription"));
        this.progressBar.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.progressBar.AccessibleContext.accessibleName"));
        this.progressBar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.progressBar.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.AccessibleContext.accessibleDescription"));
    }

    public static interface Detector {
        public List<String> detect();
    }

    public static final class Strings {
        final String windowTitle;
        final String listTitle;
        final String pleaseWaitPart;
        final String noItemsFound;

        public Strings(String windowTitle, String listTitle, String pleaseWaitPart, String noItemsFound) {
            assert (windowTitle != null);
            assert (listTitle != null);
            assert (pleaseWaitPart != null);
            assert (noItemsFound != null);
            this.windowTitle = windowTitle;
            this.listTitle = listTitle;
            this.pleaseWaitPart = pleaseWaitPart;
            this.noItemsFound = noItemsFound;
        }
    }
}

