/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.GitRepositories;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.GitURI;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.SearchHistorySupport;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class FilesystemInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private final Set<VCSFileProxy> filesToRefresh = new HashSet<VCSFileProxy>();
    private final Map<VCSFileProxy, Set<VCSFileProxy>> lockedRepositories = new HashMap<VCSFileProxy, Set<VCSFileProxy>>(5);
    private final RequestProcessor.Task refreshTask;
    private final RequestProcessor.Task lockedRepositoryRefreshTask;
    private final RequestProcessor.Task refreshOwnersTask;
    private static final RequestProcessor rp = new RequestProcessor("GitRemoteRefresh", 1, true);
    private final GitFolderEventsHandler gitFolderEventsHandler;
    private final CommandUsageLogger commandLogger;
    private static final boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.git.autoRefreshDisabled", "false"));
    private static final String INDEX_FILE_NAME = "index";
    private static final String HEAD_FILE_NAME = "HEAD";
    private static final String REFS_FILE_NAME = "refs";
    private static final Logger LOG = Logger.getLogger(FilesystemInterceptor.class.getName());
    private static final EnumSet<FileInformation.Status> STATUS_VCS_MODIFIED_ATTRIBUTE = EnumSet.of(FileInformation.Status.NEW_HEAD_WORKING_TREE, FileInformation.Status.IN_CONFLICT, FileInformation.Status.MODIFIED_HEAD_INDEX, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE);
    private final Map<VCSFileProxy, Long> createdFolders = new LinkedHashMap<VCSFileProxy, Long>(){

        @Override
        public Long put(VCSFileProxy key, Long value) {
            long t = System.currentTimeMillis();
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if ((Long)e.getValue() >= t - 600000L) continue;
                it.remove();
            }
            return super.put(key, value);
        }
    };
    final ProgressMonitor.DefaultProgressMonitor shutdownMonitor = new ProgressMonitor.DefaultProgressMonitor();

    public FilesystemInterceptor() {
        this.cache = Git.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask(), true);
        this.lockedRepositoryRefreshTask = rp.create((Runnable)new LockedRepositoryRefreshTask());
        this.gitFolderEventsHandler = new GitFolderEventsHandler();
        this.commandLogger = new CommandUsageLogger();
        this.refreshOwnersTask = rp.create(new Runnable(){

            @Override
            public void run() {
                Git git = Git.getInstance();
                git.clearAncestorCaches();
                git.versionedFilesChanged();
                VersioningSupport.versionedRootsChanged();
            }
        });
    }

    public long refreshRecursively(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
        VCSFileProxy metadataFolder;
        long retval = -1L;
        if (".git".equals(dir.getName()) || this.gitFolderEventsHandler.isMetadataFolder(dir)) {
            if (Git.STATUS_LOG.isLoggable(Level.FINER)) {
                Git.STATUS_LOG.log(Level.FINER, "Interceptor.refreshRecursively: {0}", dir.getPath());
            }
            children.clear();
            retval = this.gitFolderEventsHandler.refreshAdminFolder(dir);
            VCSFileProxy[] listFiles = dir.listFiles();
            if (listFiles != null) {
                for (VCSFileProxy ch : listFiles) {
                    if (!REFS_FILE_NAME.equals(ch.getName())) continue;
                    children.add((VCSFileProxy)ch);
                }
            }
        } else if (GitUtils.isPartOfGitMetadata(dir) && (metadataFolder = this.gitFolderEventsHandler.getMetadataForReferences(dir)) != null) {
            this.gitFolderEventsHandler.refreshReferences(metadataFolder, dir);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(VCSFileProxy file, boolean isDirectory) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "beforeCreate {0} - {1}", new Object[]{file, isDirectory});
        }
        if (GitUtils.isPartOfGitMetadata(file)) {
            return false;
        }
        if (!isDirectory && !file.exists()) {
            Git git = Git.getInstance();
            VCSFileProxy root = git.getRepositoryRoot(file);
            if (root == null) {
                return false;
            }
            GitClient client = null;
            try {
                client = git.getClient(root);
                client.reset(new VCSFileProxy[]{file}, HEAD_FILE_NAME, true, GitUtils.NULL_PROGRESS_MONITOR);
            }
            catch (GitException.MissingObjectException ex) {
                if (!HEAD_FILE_NAME.equals(ex.getObjectName())) {
                    LOG.log(Level.INFO, "beforeCreate(): File: {0} {1}", new Object[]{file.getPath(), ex.toString()});
                }
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, "beforeCreate(): File: {0} {1}", new Object[]{file.getPath(), ex.toString()});
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "beforeCreate(): finished: {0}", file);
            }
        }
        return false;
    }

    public void afterCreate(VCSFileProxy file) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "afterCreate {0}", file);
        }
        if (GitUtils.isPartOfGitMetadata(file) && "index.lock".equals(file.getName())) {
            this.commandLogger.locked(file);
        }
        if (GitUtils.isAdministrative(file)) {
            this.refreshOwnersTask.schedule(0);
        }
        this.addToCreated(file);
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file), true);
        }
    }

    public boolean beforeDelete(VCSFileProxy file) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "beforeDelete {0}", file);
        }
        if (file == null) {
            return false;
        }
        if (GitUtils.isPartOfGitMetadata(file)) {
            return false;
        }
        return !this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED);
    }

    public void doDelete(VCSFileProxy file) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "doDelete {0}", file);
        }
        if (file == null) {
            return;
        }
        Git git = Git.getInstance();
        VCSFileProxy root = git.getRepositoryRoot(file);
        GitClient client = null;
        try {
            if (GitUtils.getGitFolderForRoot(root).exists()) {
                client = git.getClient(root);
                client.remove(new VCSFileProxy[]{file}, false, GitUtils.NULL_PROGRESS_MONITOR);
            } else if (file.exists()) {
                VCSFileProxySupport.delete((VCSFileProxy)file);
                if (file.exists()) {
                    IOException ex = new IOException();
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, ""}));
                    throw ex;
                }
            }
            if (file.equals((Object)root)) {
                this.gitFolderEventsHandler.refreshIndexFileTimestamp(root);
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public void afterDelete(VCSFileProxy file) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "afterDelete {0}", file);
        }
        if (file == null) {
            return;
        }
        if (GitUtils.isPartOfGitMetadata(file) && "index.lock".equals(file.getName())) {
            this.commandLogger.unlocked(file);
        }
        if (".git".equals(file.getName())) {
            this.refreshOwnersTask.schedule(3000);
        }
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file), true);
        }
    }

    public boolean beforeMove(VCSFileProxy from, VCSFileProxy to) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "beforeMove {0} -> {1}", new Object[]{from, to});
        }
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Git hg = Git.getInstance();
        return hg.isManaged(from) && hg.isManaged(to);
    }

    public void doMove(VCSFileProxy from, VCSFileProxy to) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "doMove {0} -> {1}", new Object[]{from, to});
        }
        if (from == null || to == null || to.exists() && !this.equalPathsIgnoreCase(from, to)) {
            return;
        }
        Git git = Git.getInstance();
        VCSFileProxy root = git.getRepositoryRoot(from);
        VCSFileProxy dstRoot = git.getRepositoryRoot(to);
        GitClient client = null;
        try {
            if (root != null && root.equals((Object)dstRoot) && !this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                client = git.getClient(root);
                if (this.equalPathsIgnoreCase(from, to)) {
                    if (!VCSFileProxySupport.renameTo((VCSFileProxy)from, (VCSFileProxy)to)) {
                        throw new IOException(NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, ""}));
                    }
                    client.rename(from, to, true, GitUtils.NULL_PROGRESS_MONITOR);
                } else {
                    client.rename(from, to, false, GitUtils.NULL_PROGRESS_MONITOR);
                }
            } else {
                boolean result = VCSFileProxySupport.renameTo((VCSFileProxy)from, (VCSFileProxy)to);
                if (!result) {
                    throw new IOException(NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, ""}));
                }
                if (root != null) {
                    client = git.getClient(root);
                    client.remove(new VCSFileProxy[]{from}, true, GitUtils.NULL_PROGRESS_MONITOR);
                }
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private boolean equalPathsIgnoreCase(VCSFileProxy from, VCSFileProxy to) {
        return Utilities.isWindows() && from.equals((Object)to) || Utilities.isMac() && from.getPath().equalsIgnoreCase(to.getPath());
    }

    public void afterMove(VCSFileProxy from, VCSFileProxy to) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "afterMove {0} -> {1}", new Object[]{from, to});
        }
        if (from == null || to == null || !to.exists()) {
            return;
        }
        if (from.equals((Object)Git.getInstance().getRepositoryRoot(from)) || to.equals((Object)Git.getInstance().getRepositoryRoot(to))) {
            this.refreshOwnersTask.schedule(0);
        }
        if (!this.cache.getStatus(from).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(from), true);
        }
        this.addToCreated(to);
        if (!this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(to), true);
        }
    }

    public boolean beforeCopy(VCSFileProxy from, VCSFileProxy to) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "beforeCopy {0}->{1}", new Object[]{from, to});
        }
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Git git = Git.getInstance();
        return git.isManaged(from) && git.isManaged(to);
    }

    public void doCopy(VCSFileProxy from, VCSFileProxy to) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "doCopy {0}->{1}", new Object[]{from, to});
        }
        if (from == null || to == null || to.exists()) {
            return;
        }
        Git git = Git.getInstance();
        VCSFileProxy root = git.getRepositoryRoot(from);
        VCSFileProxy dstRoot = git.getRepositoryRoot(to);
        if (from.isDirectory()) {
            VCSFileProxySupport.copyDirFiles((VCSFileProxy)from, (VCSFileProxy)to, (boolean)true);
        } else {
            VCSFileProxySupport.copyFile((VCSFileProxy)from, (VCSFileProxy)to);
        }
        if (root == null || this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return;
        }
        GitClient client = null;
        try {
            if (root.equals((Object)dstRoot)) {
                client = git.getClient(root);
                client.copyAfter(from, to, GitUtils.NULL_PROGRESS_MONITOR);
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_CopyFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public void afterCopy(VCSFileProxy from, VCSFileProxy to) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "afterCopy {0}->{1}", new Object[]{from, to});
        }
        if (to == null) {
            return;
        }
        this.addToCreated(to);
        if (!this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(to), true);
        }
    }

    public void afterChange(VCSFileProxy file) {
        if (file.isDirectory()) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "afterChange {0}", new Object[]{file});
        }
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file), true);
        }
    }

    public boolean isMutable(VCSFileProxy file) {
        return GitUtils.isPartOfGitMetadata(file) || super.isMutable(file);
    }

    public Object getAttribute(VCSFileProxy file, String attrName) {
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new GitSearchHistorySupport(file);
        }
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            VCSFileProxy repoRoot = Git.getInstance().getRepositoryRoot(file);
            RepositoryInfo info = RepositoryInfo.getInstance(repoRoot);
            Map<String, GitRemoteConfig> remotes = info.getRemotes();
            StringBuilder sb = new StringBuilder();
            for (GitRemoteConfig rc : remotes.values()) {
                List uris = rc.getUris();
                for (int i = 0; i < uris.size(); ++i) {
                    try {
                        GitURI u = new GitURI((String)uris.get(i));
                        u = u.setUser(null).setPass(null);
                        sb.append(u.toString()).append(';');
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        if ("ProvidedExtensions.VCSIsModified".equals(attrName)) {
            VCSFileProxy repoRoot = Git.getInstance().getRepositoryRoot(file);
            Boolean modified = null;
            if (repoRoot != null) {
                Set<VCSFileProxy> coll = Collections.singleton(file);
                this.cache.refreshAllRoots(Collections.singletonMap(repoRoot, coll));
                modified = this.cache.containsFiles(coll, STATUS_VCS_MODIFIED_ATTRIBUTE, true);
            }
            return modified;
        }
        return super.getAttribute(file, attrName);
    }

    void pingRepositoryRootFor(VCSFileProxy file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        this.gitFolderEventsHandler.initializeFor(file);
    }

    Set<VCSFileProxy> getSeenRoots(VCSFileProxy repositoryRoot) {
        return this.gitFolderEventsHandler.getSeenRoots(repositoryRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runWithoutExternalEvents(VCSFileProxy repository, String commandName, Callable<T> callable) throws Exception {
        T t;
        block10: {
            block11: {
                assert (repository != null);
                try {
                    if (repository != null) {
                        this.gitFolderEventsHandler.enableEvents(repository, false);
                        this.commandLogger.lockedInternally(repository, commandName);
                    }
                    t = callable.call();
                    if (repository == null) break block10;
                    if (!LOG.isLoggable(Level.FINER)) break block11;
                }
                catch (Throwable throwable) {
                    if (repository != null) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{commandName, repository.getPath()});
                        }
                        if (EventQueue.isDispatchThread()) {
                            Git.getInstance().getRequestProcessor().post(new Runnable(repository){
                                final /* synthetic */ VCSFileProxy val$repository;
                                {
                                    this.val$repository = vCSFileProxy;
                                }

                                @Override
                                public void run() {
                                    FilesystemInterceptor.this.gitFolderEventsHandler.refreshIndexFileTimestamp(this.val$repository);
                                }
                            });
                        } else {
                            this.gitFolderEventsHandler.refreshIndexFileTimestamp(repository);
                        }
                        this.commandLogger.unlockedInternally(repository);
                        this.gitFolderEventsHandler.enableEvents(repository, true);
                    }
                    throw throwable;
                }
                LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{commandName, repository.getPath()});
            }
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
            } else {
                this.gitFolderEventsHandler.refreshIndexFileTimestamp(repository);
            }
            this.commandLogger.unlockedInternally(repository);
            this.gitFolderEventsHandler.enableEvents(repository, true);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCreated(VCSFileProxy createdFile) {
        if (!GitModuleConfig.getDefault().getAutoIgnoreFiles() || !createdFile.isDirectory()) {
            return;
        }
        Map<VCSFileProxy, Long> map = this.createdFolders;
        synchronized (map) {
            for (VCSFileProxy f : this.createdFolders.keySet()) {
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)f, (VCSFileProxy)createdFile)) continue;
                return;
            }
            this.createdFolders.put(createdFile, createdFile.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<VCSFileProxy> getCreatedFolders() {
        Map<VCSFileProxy, Long> map = this.createdFolders;
        synchronized (map) {
            return new HashSet<VCSFileProxy>(this.createdFolders.keySet());
        }
    }

    private Collection<VCSFileProxy> checkLockedRepositories(Collection<VCSFileProxy> additionalFilesToRefresh, boolean keepCached) {
        LinkedList<VCSFileProxy> retval = new LinkedList<VCSFileProxy>();
        Map<VCSFileProxy, Set<VCSFileProxy>> sortedFiles = GitUtils.sortByRepository(additionalFilesToRefresh);
        for (Map.Entry<VCSFileProxy, Set<VCSFileProxy>> e : sortedFiles.entrySet()) {
            Set<VCSFileProxy> alreadyPlanned = this.lockedRepositories.get(e.getKey());
            if (alreadyPlanned == null) {
                alreadyPlanned = new HashSet<VCSFileProxy>();
                this.lockedRepositories.put(e.getKey(), alreadyPlanned);
            }
            alreadyPlanned.addAll((Collection<VCSFileProxy>)e.getValue());
        }
        Iterator<Map.Entry<VCSFileProxy, Set<VCSFileProxy>>> it = this.lockedRepositories.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VCSFileProxy, Set<VCSFileProxy>> entry = it.next();
            VCSFileProxy repository = entry.getKey();
            if (!repository.exists()) {
                it.remove();
                continue;
            }
            if (GitUtils.isRepositoryLocked(repository)) {
                Git.STATUS_LOG.log(Level.FINE, "checkLockedRepositories(): Repository {0} locked, status refresh delayed", repository);
                continue;
            }
            retval.addAll((Collection<VCSFileProxy>)entry.getValue());
            if (keepCached) continue;
            it.remove();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reScheduleRefresh(int delayMillis, Set<VCSFileProxy> filesToRefresh, boolean log) {
        boolean changed;
        HashSet<VCSFileProxy> filteredFiles = new HashSet<VCSFileProxy>(filesToRefresh);
        Iterator it = filteredFiles.iterator();
        while (it.hasNext()) {
            if (!GitUtils.isPartOfGitMetadata((VCSFileProxy)it.next())) continue;
            it.remove();
        }
        Set<VCSFileProxy> set = this.filesToRefresh;
        synchronized (set) {
            changed = this.filesToRefresh.addAll(filteredFiles);
        }
        if (changed) {
            Git.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", filteredFiles);
            if (log) {
                for (VCSFileProxy file : filteredFiles) {
                    this.commandLogger.logModification(file);
                }
            }
            this.refreshTask.schedule(delayMillis);
        }
    }

    public static class GitSearchHistorySupport
    extends SearchHistorySupport {
        public GitSearchHistorySupport(VCSFileProxy file) {
            super(file);
        }

        protected boolean searchHistoryImpl(int line) throws IOException {
            VCSFileProxy file = this.getFile();
            SearchHistoryAction.openSearch(Git.getInstance().getRepositoryRoot(file), file, file.getName(), line);
            return true;
        }
    }

    private class GitFolderEventsHandler {
        private final HashMap<VCSFileProxy, Set<VCSFileProxy>> seenRoots = new HashMap();
        private final HashMap<VCSFileProxy, GitFolderTimestamps> timestamps = new HashMap(5);
        private final HashMap<VCSFileProxy, MetadataMapping> gitToMetadataFolder = new HashMap(5);
        private final HashMap<VCSFileProxy, VCSFileProxy> metadataToGitFolder = new HashMap(5);
        private final HashMap<VCSFileProxy, FileChangeListener> gitFolderRLs = new HashMap(5);
        private final HashSet<VCSFileProxy> disabledEvents = new HashSet(5);
        private final HashSet<VCSFileProxy> filesToInitialize = new HashSet();
        private final RequestProcessor.Task initializingTask = FilesystemInterceptor.access$2600().create(new Runnable(){

            @Override
            public void run() {
                GitFolderEventsHandler.this.initializeFiles();
            }
        });
        private final HashSet<VCSFileProxy> refreshedRepositories = new HashSet(5);
        private final RequestProcessor.Task refreshOpenFilesTask = FilesystemInterceptor.access$2600().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet repositories;
                HashSet hashSet = GitFolderEventsHandler.this.refreshedRepositories;
                synchronized (hashSet) {
                    repositories = new HashSet(GitFolderEventsHandler.this.refreshedRepositories);
                    GitFolderEventsHandler.this.refreshedRepositories.clear();
                }
                GitUtils.headChanged(repositories.toArray(new VCSFileProxy[repositories.size()]));
            }
        });
        private final GitRepositories gitRepositories = GitRepositories.getInstance();
        private final Set<VCSFileProxy> metadataFoldersToRefresh = new HashSet<VCSFileProxy>();
        private final RequestProcessor.Task refreshGitRepoTask = FilesystemInterceptor.access$2600().create((Runnable)new RefreshMetadata());

        private GitFolderEventsHandler() {
        }

        public void initializeFor(VCSFileProxy file) {
            if (this.addFileToInitialize(file)) {
                this.initializingTask.schedule(500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<VCSFileProxy> getSeenRoots(VCSFileProxy repositoryRoot) {
            Set<VCSFileProxy> seenRootsForRepository;
            HashSet<VCSFileProxy> retval = new HashSet<VCSFileProxy>();
            Set<VCSFileProxy> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                retval.addAll(seenRootsForRepository);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addSeenRoot(VCSFileProxy repositoryRoot, VCSFileProxy rootToAdd) {
            Set<VCSFileProxy> seenRootsForRepository;
            boolean added = false;
            Set<VCSFileProxy> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                if (!seenRootsForRepository.contains(repositoryRoot)) {
                    added = !GitUtils.prepareRootFiles(repositoryRoot, seenRootsForRepository, rootToAdd = rootToAdd.normalizeFile());
                }
            }
            return added;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<VCSFileProxy> getSeenRootsForRepository(VCSFileProxy repositoryRoot) {
            HashMap<VCSFileProxy, Set<VCSFileProxy>> hashMap = this.seenRoots;
            synchronized (hashMap) {
                Set<VCSFileProxy> seenRootsForRepository = this.seenRoots.get(repositoryRoot);
                if (seenRootsForRepository == null) {
                    seenRootsForRepository = new HashSet<VCSFileProxy>();
                    this.seenRoots.put(repositoryRoot, seenRootsForRepository);
                }
                return seenRootsForRepository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToInitialize(VCSFileProxy file) {
            HashSet<VCSFileProxy> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                return this.filesToInitialize.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VCSFileProxy getFileToInitialize() {
            VCSFileProxy nextFile = null;
            HashSet<VCSFileProxy> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                Iterator<VCSFileProxy> iterator = this.filesToInitialize.iterator();
                if (iterator.hasNext()) {
                    nextFile = iterator.next();
                    iterator.remove();
                }
            }
            return nextFile;
        }

        private GitFolderTimestamps scanGitFolderTimestamps(VCSFileProxy gitFolder) {
            VCSFileProxy metadataFolder = this.translateToMetadataFolder(gitFolder);
            VCSFileProxy indexFile = VCSFileProxy.createFileProxy((VCSFileProxy)metadataFolder, (String)FilesystemInterceptor.INDEX_FILE_NAME);
            VCSFileProxy headFile = VCSFileProxy.createFileProxy((VCSFileProxy)metadataFolder, (String)FilesystemInterceptor.HEAD_FILE_NAME);
            GitBranch activeBranch = null;
            RepositoryInfo info = RepositoryInfo.getInstance(gitFolder.getParentFile());
            if (info != null) {
                info.refresh();
                activeBranch = info.getActiveBranch();
            }
            VCSFileProxy refFile = headFile;
            if (activeBranch != null && !"(no branch)".equals(activeBranch.getName())) {
                refFile = VCSFileProxy.createFileProxy((VCSFileProxy)metadataFolder, (String)("refs/heads/" + activeBranch.getName()));
            }
            return new GitFolderTimestamps(indexFile, headFile, refFile, gitFolder, metadataFolder);
        }

        public void refreshIndexFileTimestamp(VCSFileProxy repository) {
            this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(GitUtils.getGitFolderForRoot(repository)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshIndexFileTimestamp(GitFolderTimestamps newTimestamps) {
            VCSFileProxy gitFolder = newTimestamps.getGitFolder();
            try {
                if (VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)VCSFileProxySupport.getFileSystem((VCSFileProxy)gitFolder).getTempFolder()), (VCSFileProxy)newTimestamps.getIndexFile())) {
                    return;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            final VCSFileProxy metadataFolder = newTimestamps.getMetadataFolder();
            boolean exists = newTimestamps.repositoryExists();
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                if (exists && !newTimestamps.isNewer(this.timestamps.get(gitFolder))) {
                    return;
                }
            }
            boolean add = false;
            boolean remove = false;
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap2 = this.timestamps;
            synchronized (hashMap2) {
                FileChangeListener fList;
                this.timestamps.remove(gitFolder);
                FileChangeListener list = this.gitFolderRLs.remove(gitFolder);
                if (exists) {
                    this.timestamps.put(gitFolder, newTimestamps);
                    if (list == null) {
                        fList = list = new FileChangeAdapter();
                        rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileObject fo = metadataFolder.toFileObject();
                                if (fo != null) {
                                    fo.addRecursiveListener(fList);
                                }
                            }
                        });
                    }
                    this.gitFolderRLs.put(gitFolder, list);
                    add = true;
                } else {
                    if (list != null) {
                        fList = list;
                        rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileObject fo = metadataFolder.toFileObject();
                                if (fo != null) {
                                    fo.removeRecursiveListener(fList);
                                }
                                Git.getInstance().versionedFilesChanged();
                            }
                        });
                    }
                    Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolderTimestamp: {0} no longer exists", gitFolder.getPath());
                    remove = true;
                }
                if (remove) {
                    this.gitRepositories.remove(gitFolder.getParentFile(), false);
                    this.gitToMetadataFolder.remove(gitFolder);
                    this.metadataToGitFolder.remove(metadataFolder);
                } else if (add) {
                    VCSFileProxy repository = gitFolder.getParentFile();
                    if (!repository.equals((Object)Git.getInstance().getRepositoryRoot(repository))) {
                        Git.getInstance().versionedFilesChanged();
                    }
                    this.gitRepositories.add(repository, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFiles() {
            VCSFileProxy file;
            while ((file = this.getFileToInitialize()) != null) {
                VCSFileProxy repositoryRoot;
                if (Git.STATUS_LOG.isLoggable(Level.FINEST)) {
                    Git.STATUS_LOG.log(Level.FINEST, "GitFolderEventsHandler.initializeFiles: {0}", file.getPath());
                }
                if ((repositoryRoot = Git.getInstance().getRepositoryRoot(file)) == null || !this.addSeenRoot(repositoryRoot, file)) continue;
                if (Git.STATUS_LOG.isLoggable(Level.FINE)) {
                    Git.STATUS_LOG.log(Level.FINE, "initializeFiles: planning a scan for {0} - {1}", new Object[]{repositoryRoot.getPath(), file.getPath()});
                }
                FilesystemInterceptor.this.reScheduleRefresh(4000, Collections.singleton(file), false);
                VCSFileProxy gitFolder = GitUtils.getGitFolderForRoot(repositoryRoot);
                boolean refreshNeeded = false;
                HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
                synchronized (hashMap) {
                    VCSFileProxy metadataFolder;
                    if (!this.timestamps.containsKey(gitFolder) && VCSFileProxySupport.canRead((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)(metadataFolder = this.translateToMetadataFolder(gitFolder)), (String)FilesystemInterceptor.INDEX_FILE_NAME))) {
                        this.timestamps.put(gitFolder, null);
                        refreshNeeded = true;
                    }
                }
                if (!refreshNeeded) continue;
                this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(gitFolder));
            }
            if (Git.STATUS_LOG.isLoggable(Level.FINEST)) {
                Git.STATUS_LOG.log(Level.FINEST, "GitFolderEventsHandler.initializeFiles: finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long refreshAdminFolder(VCSFileProxy metadataFolder) {
            long lastModified = 0L;
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("versioning.git.handleExternalEvents", "true"))) {
                VCSFileProxy gitFolder;
                metadataFolder = metadataFolder.normalizeFile();
                if (Git.STATUS_LOG.isLoggable(Level.FINER)) {
                    Git.STATUS_LOG.log(Level.FINER, "refreshAdminFolder: special FS event handling for {0}", metadataFolder.getPath());
                }
                if (this.isEnabled(gitFolder = this.translateToGitFolder(metadataFolder))) {
                    GitFolderTimestamps cached;
                    Object object = this.timestamps;
                    synchronized (object) {
                        cached = this.timestamps.get(gitFolder);
                    }
                    if (cached == null || !cached.repositoryExists() || cached.isOutdated()) {
                        object = this.metadataFoldersToRefresh;
                        synchronized (object) {
                            if (this.metadataFoldersToRefresh.add(gitFolder)) {
                                this.refreshGitRepoTask.schedule(1000);
                            }
                        }
                    }
                }
            }
            return lastModified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshReferences(VCSFileProxy metadataFolder, VCSFileProxy triggerFolder) {
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("versioning.git.handleExternalEvents", "true"))) {
                metadataFolder = metadataFolder.normalizeFile();
                if (Git.STATUS_LOG.isLoggable(Level.FINER)) {
                    Git.STATUS_LOG.log(Level.FINER, "refreshReferences: special FS event handling for {0}", triggerFolder.getPath());
                }
                boolean refreshNeeded = false;
                VCSFileProxy gitFolder = this.translateToGitFolder(metadataFolder);
                if (this.isEnabled(gitFolder)) {
                    GitFolderTimestamps cached;
                    HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
                    synchronized (hashMap) {
                        cached = this.timestamps.get(gitFolder);
                    }
                    if (cached != null && cached.updateReferences(triggerFolder)) {
                        refreshNeeded = true;
                    }
                    if (refreshNeeded) {
                        VCSFileProxy repository = gitFolder.getParentFile();
                        RepositoryInfo.refreshAsync(repository);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshOpenFiles(VCSFileProxy repository) {
            boolean refreshPlanned;
            HashSet<VCSFileProxy> hashSet = this.refreshedRepositories;
            synchronized (hashSet) {
                refreshPlanned = !this.refreshedRepositories.add(repository);
            }
            if (!refreshPlanned) {
                this.refreshOpenFilesTask.schedule(3000);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enableEvents(VCSFileProxy repository, boolean enabled) {
            VCSFileProxy gitFolder = GitUtils.getGitFolderForRoot(repository).normalizeFile();
            HashSet<VCSFileProxy> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                if (enabled) {
                    this.disabledEvents.remove(gitFolder);
                } else {
                    this.disabledEvents.add(gitFolder);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isEnabled(VCSFileProxy gitFolder) {
            HashSet<VCSFileProxy> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                return !this.disabledEvents.contains(gitFolder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VCSFileProxy translateToMetadataFolder(VCSFileProxy gitFolder) {
            long ts;
            VCSFileProxy metadataFolder;
            MetadataMapping mapping;
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                mapping = this.gitToMetadataFolder.get(gitFolder);
            }
            if (mapping == null) {
                metadataFolder = gitFolder;
                ts = System.currentTimeMillis();
            } else {
                metadataFolder = mapping.metadataFolder;
                ts = mapping.ts;
            }
            if (gitFolder.isFile()) {
                ts = gitFolder.lastModified();
                if (mapping == null || mapping.ts < ts) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(gitFolder.getInputStream(false), "UTF-8"));
                        String line = br.readLine();
                        while (line != null) {
                            if ((line = line.trim()).startsWith("gitdir:")) {
                                VCSFileProxy tmp = (line = line.substring(7).trim()).startsWith("/") ? VCSFileProxySupport.getResource((VCSFileProxy)gitFolder, (String)line) : VCSFileProxySupport.getCanonicalFile((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)gitFolder, (String)line));
                                metadataFolder = tmp;
                                break;
                            }
                            line = br.readLine();
                        }
                    }
                    catch (IOException ex) {
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap2 = this.timestamps;
            synchronized (hashMap2) {
                this.gitToMetadataFolder.put(gitFolder, new MetadataMapping(metadataFolder, ts));
                this.metadataToGitFolder.put(metadataFolder, gitFolder);
            }
            return metadataFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VCSFileProxy translateToGitFolder(VCSFileProxy metadataFolder) {
            VCSFileProxy gitFolder;
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                gitFolder = this.metadataToGitFolder.get(metadataFolder);
            }
            if (gitFolder == null) {
                gitFolder = metadataFolder;
            }
            return gitFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isMetadataFolder(VCSFileProxy dir) {
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                return this.metadataToGitFolder.containsKey(dir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VCSFileProxy getMetadataForReferences(VCSFileProxy file) {
            ArrayList<VCSFileProxy> metadataFolders;
            HashMap<VCSFileProxy, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                metadataFolders = new ArrayList<VCSFileProxy>(this.metadataToGitFolder.keySet());
            }
            VCSFileProxy candidate = null;
            for (VCSFileProxy metadataFolder : metadataFolders) {
                String refsPath = VCSFileProxy.createFileProxy((VCSFileProxy)metadataFolder, (String)FilesystemInterceptor.REFS_FILE_NAME).getPath();
                if (!file.getPath().startsWith(refsPath) || candidate != null && candidate.getPath().length() >= metadataFolder.getPath().length()) continue;
                candidate = metadataFolder;
            }
            return candidate;
        }

        private class RefreshMetadata
        implements Runnable {
            private RefreshMetadata() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet<VCSFileProxy> stillLockedRepos = new HashSet<VCSFileProxy>();
                VCSFileProxy gitFolder = this.getNextRepository();
                while (gitFolder != null) {
                    if (GitUtils.isRepositoryLocked(gitFolder.getParentFile())) {
                        Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolder: replanning repository scan for locked {0}", gitFolder);
                        stillLockedRepos.add(gitFolder);
                    } else {
                        GitFolderEventsHandler.this.refreshIndexFileTimestamp(GitFolderEventsHandler.this.scanGitFolderTimestamps(gitFolder));
                        VCSFileProxy repository = gitFolder.getParentFile();
                        RepositoryInfo.refreshAsync(repository);
                        Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolder: planning repository scan for {0}", repository.getPath());
                        FilesystemInterceptor.this.reScheduleRefresh(3000, GitFolderEventsHandler.this.getSeenRoots(repository), false);
                        GitFolderEventsHandler.this.refreshOpenFiles(repository);
                    }
                    gitFolder = this.getNextRepository();
                }
                Set set = GitFolderEventsHandler.this.metadataFoldersToRefresh;
                synchronized (set) {
                    if (GitFolderEventsHandler.this.metadataFoldersToRefresh.addAll(stillLockedRepos)) {
                        GitFolderEventsHandler.this.refreshGitRepoTask.schedule(2000);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private VCSFileProxy getNextRepository() {
                VCSFileProxy gitFolder = null;
                Set set = GitFolderEventsHandler.this.metadataFoldersToRefresh;
                synchronized (set) {
                    if (!GitFolderEventsHandler.this.metadataFoldersToRefresh.isEmpty()) {
                        Iterator it = GitFolderEventsHandler.this.metadataFoldersToRefresh.iterator();
                        gitFolder = (VCSFileProxy)it.next();
                        it.remove();
                    }
                }
                return gitFolder;
            }
        }
    }

    private static class MetadataMapping {
        private final VCSFileProxy metadataFolder;
        private final long ts;

        public MetadataMapping(VCSFileProxy metadataFolder, long ts) {
            this.metadataFolder = metadataFolder;
            this.ts = ts;
        }
    }

    private static class GitFolderTimestamps {
        private final VCSFileProxy indexFile;
        private final long indexFileTS;
        private final VCSFileProxy headFile;
        private final long headFileTS;
        private final VCSFileProxy refFile;
        private final long refFileTS;
        private final VCSFileProxy gitFolder;
        private final VCSFileProxy metadataFolder;
        private long referencesFolderTS;

        public GitFolderTimestamps(VCSFileProxy indexFile, VCSFileProxy headFile, VCSFileProxy refFile, VCSFileProxy gitFolder, VCSFileProxy metadataFolder) {
            this.indexFile = indexFile;
            this.indexFileTS = indexFile.lastModified();
            this.headFile = headFile;
            this.headFileTS = headFile.lastModified();
            this.refFile = refFile;
            this.refFileTS = refFile.lastModified();
            this.gitFolder = gitFolder;
            this.metadataFolder = metadataFolder;
            this.referencesFolderTS = System.currentTimeMillis();
        }

        private VCSFileProxy getIndexFile() {
            return this.indexFile;
        }

        private boolean isNewer(GitFolderTimestamps other) {
            boolean newer = true;
            if (other != null) {
                newer = this.indexFileTS > other.indexFileTS || this.headFileTS > other.headFileTS || this.refFileTS > other.refFileTS;
            }
            return newer;
        }

        private VCSFileProxy getGitFolder() {
            return this.gitFolder;
        }

        private VCSFileProxy getMetadataFolder() {
            return this.metadataFolder;
        }

        private boolean repositoryExists() {
            return this.indexFileTS > 0L || this.gitFolder.exists();
        }

        private boolean isOutdated() {
            boolean upToDate;
            boolean bl = upToDate = this.indexFileTS >= this.indexFile.lastModified();
            if (upToDate) {
                boolean bl2 = upToDate = this.headFileTS >= this.headFile.lastModified();
            }
            if (upToDate) {
                upToDate = this.refFileTS >= this.refFile.lastModified();
            }
            return !upToDate;
        }

        private boolean updateReferences(VCSFileProxy triggerFolder) {
            boolean updated = false;
            long ts = triggerFolder.lastModified();
            if (ts > this.referencesFolderTS) {
                updated = true;
                this.referencesFolderTS = System.currentTimeMillis();
            }
            return updated;
        }
    }

    private class LockedRepositoryRefreshTask
    implements Runnable {
        private LockedRepositoryRefreshTask() {
        }

        @Override
        public void run() {
            if (!FilesystemInterceptor.this.checkLockedRepositories(Collections.emptySet(), true).isEmpty()) {
                FilesystemInterceptor.this.refreshTask.schedule(0);
            } else if (!FilesystemInterceptor.this.lockedRepositories.isEmpty()) {
                FilesystemInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    public static class ShutdownCallable
    implements Callable<Boolean> {
        @Override
        public Boolean call() throws Exception {
            LOG.log(Level.FINE, "Canceling the auto refresh progress monitor");
            Git.getInstance().getVCSInterceptor().shutdownMonitor.cancel();
            try {
                Git.getInstance().getVCSInterceptor().refreshTask.waitFinished(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<VCSFileProxy> files;
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(FilesystemInterceptor.this.refreshTask, Git.STATUS_LOG, "GitRemoteInterceptor.refreshTask")) {
                return;
            }
            Set set = FilesystemInterceptor.this.filesToRefresh;
            synchronized (set) {
                files = new HashSet(FilesystemInterceptor.this.filesToRefresh);
                FilesystemInterceptor.this.filesToRefresh.clear();
            }
            if (FilesystemInterceptor.this.shutdownMonitor.isCanceled()) {
                return;
            }
            if (!"false".equals(System.getProperty("versioning.git.delayStatusForLockedRepositories"))) {
                files = FilesystemInterceptor.this.checkLockedRepositories(files, false);
            }
            if (!files.isEmpty()) {
                FilesystemInterceptor.this.cache.refreshAllRoots(files, (ProgressMonitor)FilesystemInterceptor.this.shutdownMonitor);
            }
            if (!FilesystemInterceptor.this.lockedRepositories.isEmpty()) {
                FilesystemInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    private static class Events {
        long timeStarted;
        long timeFinished;
        long modifications;
        String commandName;

        private Events() {
        }

        private boolean isExternal() {
            return this.commandName == null;
        }
    }

    private static class CommandUsageLogger {
        private final Map<VCSFileProxy, Events> events = new HashMap<VCSFileProxy, Events>();

        private CommandUsageLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void locked(VCSFileProxy file) {
            VCSFileProxy gitFolder = this.getGitFolderFor(file);
            if (gitFolder != null && file.exists()) {
                long time = System.currentTimeMillis();
                Map<VCSFileProxy, Events> map = this.events;
                synchronized (map) {
                    Events ev = this.events.get(gitFolder);
                    if (ev == null || ev.isExternal() || ev.timeFinished > 0L && ev.timeFinished < time - 10000L) {
                        ev = new Events();
                        ev.timeStarted = time;
                        this.events.put(gitFolder, ev);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lockedInternally(VCSFileProxy repository, String commandName) {
            VCSFileProxy gitFolder = GitUtils.getGitFolderForRoot(repository);
            Events ev = new Events();
            ev.timeStarted = System.currentTimeMillis();
            ev.commandName = commandName;
            Map<VCSFileProxy, Events> map = this.events;
            synchronized (map) {
                this.events.put(gitFolder, ev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlocked(VCSFileProxy file) {
            VCSFileProxy gitFolder = this.getGitFolderFor(file);
            if (gitFolder != null) {
                Events ev;
                Map<VCSFileProxy, Events> map = this.events;
                synchronized (map) {
                    ev = this.events.remove(gitFolder);
                    if (ev != null && !ev.isExternal()) {
                        this.events.put(gitFolder, ev);
                        return;
                    }
                }
                if (ev != null) {
                    long time = System.currentTimeMillis() - ev.timeStarted;
                    Utils.logVCSCommandUsageEvent((String)"GIT", (long)time, (long)ev.modifications, (String)ev.commandName, (boolean)ev.isExternal());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlockedInternally(VCSFileProxy repository) {
            Events ev;
            VCSFileProxy gitFolder = GitUtils.getGitFolderForRoot(repository);
            Map<VCSFileProxy, Events> map = this.events;
            synchronized (map) {
                ev = this.events.get(gitFolder);
                if (ev == null) {
                    return;
                }
                if (ev.isExternal()) {
                    this.events.remove(gitFolder);
                }
            }
            ev.timeFinished = System.currentTimeMillis();
            long time = ev.timeFinished - ev.timeStarted;
            Utils.logVCSCommandUsageEvent((String)"GIT", (long)time, (long)ev.modifications, (String)ev.commandName, (boolean)ev.isExternal());
        }

        private VCSFileProxy getGitFolderFor(VCSFileProxy wlockFile) {
            VCSFileProxy repository = Git.getInstance().getRepositoryRoot(wlockFile);
            VCSFileProxy gitFolder = GitUtils.getGitFolderForRoot(repository);
            return gitFolder.equals((Object)wlockFile.getParentFile()) ? gitFolder : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logModification(VCSFileProxy file) {
            VCSFileProxy gitFolder;
            if (GitUtils.isPartOfGitMetadata(file)) {
                return;
            }
            VCSFileProxy repository = Git.getInstance().getRepositoryRoot(file);
            if (repository != null && (gitFolder = GitUtils.getGitFolderForRoot(repository)) != null) {
                Map<VCSFileProxy, Events> map = this.events;
                synchronized (map) {
                    Events ev = this.events.get(gitFolder);
                    if (ev != null) {
                        ++ev.modifications;
                    }
                }
            }
        }
    }
}

