/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.commit;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class IncludeInCommitAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        return this.include(repository, roots);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = super.enable(activatedNodes);
        if (enabled) {
            enabled = false;
            GitModuleConfig config = GitModuleConfig.getDefault();
            for (VCSFileProxy root : this.getCurrentContext(activatedNodes).getRootFiles()) {
                enabled = true;
                if (config.isExcludedFromCommit(root.getPath())) continue;
                enabled = false;
                break;
            }
        }
        return enabled;
    }

    public RequestProcessor.Task include(VCSFileProxy repository, VCSFileProxy[] roots) {
        List<String> toInclude = IncludeInCommitAction.filterRoots(roots);
        GitModuleConfig config = GitModuleConfig.getDefault();
        config.removeExclusionPaths(toInclude);
        ((IncludeInCommitAction)SystemAction.get(IncludeInCommitAction.class)).setEnabled(false);
        ((ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class)).setEnabled(false);
        return null;
    }

    private static List<String> filterRoots(VCSFileProxy[] roots) {
        LinkedList<String> toInclude = new LinkedList<String>();
        GitModuleConfig config = GitModuleConfig.getDefault();
        for (VCSFileProxy root : roots) {
            String path = root.getPath();
            if (!config.isExcludedFromCommit(path)) continue;
            toInclude.add(path);
        }
        return toInclude;
    }
}

