/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.diff;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.remotefs.versioning.api.ExportDiffSupport;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ExportUncommittedChangesAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.exportDiff(repository, roots, GitClient.DiffMode.HEAD_VS_WORKINGTREE);
    }

    void exportDiff(final Node[] selectedNodes, final GitClient.DiffMode diffMode) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                VCSContext context = ExportUncommittedChangesAction.this.getCurrentContext(selectedNodes);
                Map.Entry actionRoots = ExportUncommittedChangesAction.getActionRoots(context);
                if (actionRoots != null) {
                    ExportUncommittedChangesAction.this.exportDiff((VCSFileProxy)actionRoots.getKey(), (VCSFileProxy[])actionRoots.getValue(), diffMode);
                }
            }
        }, (int)0);
    }

    private void exportDiff(final VCSFileProxy repository, final VCSFileProxy[] roots, final GitClient.DiffMode diffMode) {
        VCSFileProxy[] files;
        if (roots.length == 0 || (files = Git.getInstance().getFileStatusCache().listFiles(new HashSet<VCSFileProxy>(Arrays.asList(roots)), this.diffModeToStatusSet(diffMode))).length == 0) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportUncommittedChangesAction.emptyContext"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExportDiffSupport(roots, GitModuleConfig.getDefault().getPreferences()){

                    public void writeDiffFile(final VCSFileProxy toFile) {
                        ExportUncommittedChangesAction.saveFolderToPrefs(toFile);
                        GitProgressSupport ps = new GitProgressSupport(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void perform() {
                                boolean success = false;
                                OutputStream out = null;
                                OutputLogger logger = this.getLogger();
                                try {
                                    GitClient client = this.getClient();
                                    ExportUncommittedChangesAction.ensureParentExists(toFile);
                                    out = new BufferedOutputStream(VCSFileProxySupport.getOutputStream((VCSFileProxy)toFile));
                                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(roots));
                                    this.setProgress(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportUncommittedChangesAction.preparingDiff"));
                                    client.exportDiff(files, diffMode, out, this.getProgressMonitor());
                                    if (!this.isCanceled()) {
                                        success = true;
                                    }
                                }
                                catch (Exception ex) {
                                    logger.outputInRed(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportUncommittedChangesAction.failed"));
                                    GitClientExceptionHandler.notifyException(ex, true);
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.flush();
                                            out.close();
                                        }
                                        catch (IOException ex) {}
                                    }
                                    if (success && VCSFileProxySupport.length((VCSFileProxy)toFile) > 0L) {
                                        VCSFileProxySupport.openFile((VCSFileProxy)toFile);
                                    } else {
                                        VCSFileProxySupport.delete((VCSFileProxy)toFile);
                                    }
                                }
                            }
                        };
                        ps.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"LBL_ExportUncommittedChangesAction_Progress")).waitFinished();
                    }
                }.export();
            }
        });
    }

    static void saveFolderToPrefs(VCSFileProxy file) {
        if (file.getParentFile() != null) {
            GitModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file.getParentFile().getPath());
        }
    }

    private static void ensureParentExists(VCSFileProxy destination) {
        VCSFileProxy parent = destination.getParentFile();
        if (parent != null) {
            VCSFileProxySupport.mkdirs((VCSFileProxy)parent);
        }
    }

    private EnumSet<FileInformation.Status> diffModeToStatusSet(GitClient.DiffMode diffMode) {
        switch (diffMode) {
            case HEAD_VS_WORKINGTREE: {
                return FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING;
            }
            case HEAD_VS_INDEX: {
                return FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX;
            }
            case INDEX_VS_WORKINGTREE: {
                return FileInformation.STATUS_MODIFIED_INDEX_VS_WORKING;
            }
        }
        throw new IllegalArgumentException("Unknown diff mode " + diffMode);
    }
}

