/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.repository;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.GitRepositoryState;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.JGitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public class RepositoryInfo {
    public static final String PROPERTY_ACTIVE_BRANCH = "prop.activeBranch";
    public static final String PROPERTY_HEAD = "prop.head";
    public static final String PROPERTY_STATE = "prop.state";
    public static final String PROPERTY_BRANCHES = "prop.branches";
    public static final String PROPERTY_TAGS = "prop.tags";
    public static final String PROPERTY_REMOTES = "prop.remotes";
    public static final String PROPERTY_STASH = "prop.stashes";
    private final Reference<VCSFileProxy> rootRef;
    private static final WeakHashMap<VCSFileProxy, RepositoryInfo> cache = new WeakHashMap(5);
    private static final Logger LOG = Logger.getLogger(RepositoryInfo.class.getName());
    private static final RequestProcessor rp = new RequestProcessor("RepositoryInfo", 1, true);
    private static final RequestProcessor.Task refreshTask = rp.create((Runnable)new RepositoryRefreshTask());
    private static final Set<RepositoryInfo> repositoriesToRefresh = new HashSet<RepositoryInfo>(2);
    private final PropertyChangeSupport propertyChangeSupport;
    private final Map<String, GitBranch> branches;
    private final Map<String, GitTag> tags;
    private final Map<String, GitRemoteConfig> remotes;
    private final List<GitRevisionInfo> stashes;
    private GitBranch activeBranch;
    private GitRepositoryState repositoryState;
    private final String name;
    private static final Set<String> logged = Collections.synchronizedSet(new HashSet());
    private PushMode pushMode = PushMode.ASK;
    private final ThreadLocal<List<PropertyChangeEvent>> eventsToFire = new ThreadLocal();

    private RepositoryInfo(VCSFileProxy root) {
        this.rootRef = new WeakReference<VCSFileProxy>(root);
        this.name = root.getName();
        this.branches = new LinkedHashMap<String, GitBranch>();
        this.tags = new HashMap<String, GitTag>();
        this.remotes = new HashMap<String, GitRemoteConfig>();
        this.stashes = new ArrayList<GitRevisionInfo>();
        this.activeBranch = GitBranch.NO_BRANCH_INSTANCE;
        this.repositoryState = GitRepositoryState.SAFE;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryInfo getInstance(VCSFileProxy repositoryRoot) {
        RepositoryInfo info = null;
        VCSFileProxy repositoryRootSingleInstance = Git.getInstance().getRepositoryRoot(repositoryRoot);
        if (repositoryRoot.equals((Object)repositoryRootSingleInstance)) {
            boolean refresh = false;
            WeakHashMap<VCSFileProxy, RepositoryInfo> weakHashMap = cache;
            synchronized (weakHashMap) {
                info = cache.get(repositoryRootSingleInstance);
                if (info == null) {
                    info = new RepositoryInfo(repositoryRootSingleInstance);
                    cache.put(repositoryRootSingleInstance, info);
                    refresh = true;
                }
            }
            if (refresh) {
                if (EventQueue.isDispatchThread()) {
                    LOG.log(Level.FINE, "getInstance (): had to schedule an async refresh for {0}", repositoryRoot);
                    RepositoryInfo.refreshAsync(repositoryRoot);
                } else {
                    info.refresh();
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        block15: {
            assert (!EventQueue.isDispatchThread());
            VCSFileProxy root = this.rootRef.get();
            GitClient client = null;
            try {
                if (root == null || !VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)root))) {
                    LOG.log(Level.WARNING, "refresh (): root is null, it has been collected in the meantime");
                    break block15;
                }
                if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)root))) {
                    LOG.log(Level.WARNING, "refresh (): file system is not connected");
                    break block15;
                }
                LOG.log(Level.FINE, "refresh (): starting for {0}", root);
                try {
                    this.eventsToFire.set(new ArrayList());
                    client = Git.getInstance().getClient(root);
                    Map<String, GitBranch> newBranches = client.getBranches(true, GitUtils.NULL_PROGRESS_MONITOR);
                    this.setBranches(newBranches);
                    Map<String, GitTag> newTags = client.getTags(GitUtils.NULL_PROGRESS_MONITOR, false);
                    this.setTags(newTags);
                    try {
                        this.refreshRemotes(client);
                    }
                    catch (GitException ex) {
                        LOG.log(logged.add(root.getPath() + ex.getMessage()) ? Level.INFO : Level.FINE, null, ex);
                    }
                    this.refreshStashes(client);
                    GitRepositoryState newState = client.getRepositoryState(GitUtils.NULL_PROGRESS_MONITOR);
                    this.setActiveBranch(newBranches);
                    this.setRepositoryState(newState);
                }
                finally {
                    List<PropertyChangeEvent> events = this.eventsToFire.get();
                    for (PropertyChangeEvent e : events) {
                        this.propertyChangeSupport.firePropertyChange(e);
                    }
                    this.eventsToFire.remove();
                }
            }
            catch (GitException ex) {
                Level level = root.exists() ? Level.INFO : Level.FINE;
                LOG.log(level, null, ex);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRemotes() throws GitException {
        assert (!EventQueue.isDispatchThread());
        GitClient client = null;
        try {
            VCSFileProxy root = this.rootRef.get();
            if (root == null) {
                LOG.log(Level.WARNING, "refreshRemotes (): root is null, it has been collected in the meantime");
            } else {
                LOG.log(Level.FINE, "refreshRemotes (): starting for {0}", root);
                client = Git.getInstance().getClient(root);
                this.refreshRemotes(client);
            }
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GitRevisionInfo> refreshStashes() throws GitException {
        assert (!EventQueue.isDispatchThread());
        GitClient client = null;
        try {
            VCSFileProxy root = this.rootRef.get();
            if (root == null) {
                LOG.log(Level.WARNING, "refreshRemotes (): root is null, it has been collected in the meantime");
            } else {
                LOG.log(Level.FINE, "refreshRemotes (): starting for {0}", root);
                client = Git.getInstance().getClient(root);
                this.refreshStashes(client);
            }
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return new ArrayList<GitRevisionInfo>(this.stashes);
    }

    private void setActiveBranch(Map<String, GitBranch> branches) throws GitException {
        for (Map.Entry<String, GitBranch> e : branches.entrySet()) {
            if (!e.getValue().isActive()) continue;
            GitBranch oldActiveBranch = this.activeBranch;
            this.activeBranch = e.getValue();
            if (oldActiveBranch == null || !oldActiveBranch.getName().equals(this.activeBranch.getName())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "active branch changed: {0} --- {1}", new Object[]{this.rootRef, this.activeBranch.getName()});
                }
                this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_ACTIVE_BRANCH, oldActiveBranch, this.activeBranch));
            }
            if (oldActiveBranch != null && oldActiveBranch.getId().equals(this.activeBranch.getId())) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "current HEAD changed: {0} --- {1}", new Object[]{this.rootRef, this.activeBranch.getId()});
            }
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_HEAD, oldActiveBranch, this.activeBranch));
        }
    }

    private void setRepositoryState(GitRepositoryState repositoryState) {
        GitRepositoryState oldState = this.repositoryState;
        this.repositoryState = repositoryState;
        if (!repositoryState.equals((Object)oldState)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "repository state changed: {0} --- {1}", new Object[]{oldState, repositoryState});
            }
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_STATE, oldState, repositoryState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBranches(Map<String, GitBranch> newBranches) {
        LinkedHashMap<String, GitBranch> oldBranches;
        boolean changed = false;
        Map<String, GitBranch> map = this.branches;
        synchronized (map) {
            oldBranches = new LinkedHashMap<String, GitBranch>(this.branches);
            this.branches.clear();
            this.branches.putAll(newBranches);
            changed = !RepositoryInfo.equalsBranches(oldBranches, newBranches);
        }
        if (changed) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_BRANCHES, Collections.unmodifiableMap(oldBranches), Collections.unmodifiableMap(new HashMap<String, GitBranch>(newBranches))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTags(Map<String, GitTag> newTags) {
        HashMap<String, GitTag> oldTags;
        boolean changed = false;
        Map<String, GitTag> map = this.tags;
        synchronized (map) {
            oldTags = new HashMap<String, GitTag>(this.tags);
            if (!RepositoryInfo.equalsTags(oldTags, newTags)) {
                this.tags.clear();
                this.tags.putAll(newTags);
                changed = true;
            }
        }
        if (changed) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_TAGS, Collections.unmodifiableMap(oldTags), Collections.unmodifiableMap(new HashMap<String, GitTag>(newTags))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRemotes(Map<String, GitRemoteConfig> newRemotes) {
        HashMap<String, GitRemoteConfig> oldRemotes;
        boolean changed = false;
        Map<String, GitRemoteConfig> map = this.remotes;
        synchronized (map) {
            oldRemotes = new HashMap<String, GitRemoteConfig>(this.remotes);
            if (!RepositoryInfo.equalsRemotes(oldRemotes, newRemotes)) {
                this.remotes.clear();
                this.remotes.putAll(newRemotes);
                changed = true;
            }
        }
        if (changed) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_REMOTES, Collections.unmodifiableMap(oldRemotes), Collections.unmodifiableMap(new HashMap<String, GitRemoteConfig>(newRemotes))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStashes(List<GitRevisionInfo> newStashes) {
        ArrayList<GitRevisionInfo> oldStash;
        boolean changed = false;
        List<GitRevisionInfo> list = this.stashes;
        synchronized (list) {
            oldStash = new ArrayList<GitRevisionInfo>(this.stashes);
            if (!RepositoryInfo.equals(oldStash, newStashes)) {
                this.stashes.clear();
                this.stashes.addAll(newStashes);
                changed = true;
            }
        }
        if (changed) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_STASH, Collections.unmodifiableList(oldStash), Collections.unmodifiableList(new ArrayList<GitRevisionInfo>(newStashes))));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public GitBranch getActiveBranch() {
        return this.activeBranch;
    }

    public GitRepositoryState getRepositoryState() {
        return this.repositoryState;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GitBranch> getBranches() {
        Map<String, GitBranch> map = this.branches;
        synchronized (map) {
            return new LinkedHashMap<String, GitBranch>(this.branches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GitTag> getTags() {
        Map<String, GitTag> map = this.tags;
        synchronized (map) {
            return new HashMap<String, GitTag>(this.tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GitRemoteConfig> getRemotes() {
        Map<String, GitRemoteConfig> map = this.remotes;
        synchronized (map) {
            return new HashMap<String, GitRemoteConfig>(this.remotes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GitRevisionInfo> getStashes() {
        List<GitRevisionInfo> list = this.stashes;
        synchronized (list) {
            return new ArrayList<GitRevisionInfo>(this.stashes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAsync(VCSFileProxy repositoryRoot) {
        RepositoryInfo info = null;
        WeakHashMap<VCSFileProxy, RepositoryInfo> weakHashMap = cache;
        synchronized (weakHashMap) {
            info = cache.get(repositoryRoot);
        }
        if (info != null) {
            info.refreshAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAsync() {
        boolean start = false;
        Set<RepositoryInfo> set = repositoriesToRefresh;
        synchronized (set) {
            start = repositoriesToRefresh.add(this);
        }
        if (start) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Planning refresh for {0}", this.rootRef.get());
            }
            refreshTask.schedule(3000);
        }
    }

    private static boolean equalsRemotes(Map<String, GitRemoteConfig> oldRemotes, Map<String, GitRemoteConfig> newRemotes) {
        boolean retval;
        boolean bl = retval = oldRemotes.size() == newRemotes.size() && oldRemotes.keySet().equals(newRemotes.keySet());
        if (retval) {
            for (Map.Entry<String, GitRemoteConfig> e : oldRemotes.entrySet()) {
                GitRemoteConfig oldRemote = e.getValue();
                GitRemoteConfig newRemote = newRemotes.get(e.getKey());
                if (oldRemote.getFetchRefSpecs().equals(newRemote.getFetchRefSpecs()) && oldRemote.getPushRefSpecs().equals(newRemote.getPushRefSpecs()) && oldRemote.getUris().equals(newRemote.getUris()) && oldRemote.getPushUris().equals(newRemote.getPushUris())) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private static boolean equals(List<GitRevisionInfo> oldList, List<GitRevisionInfo> newList) {
        boolean retval;
        boolean bl = retval = oldList.size() == newList.size();
        if (retval) {
            ListIterator<GitRevisionInfo> itOld = oldList.listIterator();
            ListIterator<GitRevisionInfo> itNew = newList.listIterator();
            while (itOld.hasNext()) {
                GitRevisionInfo oldInfo = itOld.next();
                GitRevisionInfo newInfo = itNew.next();
                if (oldInfo.getRevision().equals(newInfo.getRevision())) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private static boolean equalsBranches(Map<String, GitBranch> oldBranches, Map<String, GitBranch> newBranches) {
        boolean retval;
        boolean bl = retval = oldBranches.size() == newBranches.size() && oldBranches.keySet().equals(newBranches.keySet());
        if (retval) {
            for (Map.Entry<String, GitBranch> e : oldBranches.entrySet()) {
                GitBranch oldBranch = e.getValue();
                GitBranch newBranch = newBranches.get(e.getKey());
                if (oldBranch.getId().equals(newBranch.getId()) && RepositoryInfo.equalTracking(newBranch, oldBranch)) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private static boolean equalTracking(GitBranch newBranch, GitBranch oldBranch) {
        GitBranch tracked2;
        boolean equal;
        GitBranch tracked1 = newBranch.getTrackedBranch();
        boolean bl = equal = tracked1 == (tracked2 = oldBranch.getTrackedBranch());
        if (!equal) {
            equal = tracked1 != null && tracked2 != null && tracked1.getName().equals(tracked2.getName()) && tracked1.getId().equals(tracked2.getId());
        }
        return equal;
    }

    private static boolean equalsTags(Map<String, GitTag> oldTags, Map<String, GitTag> newTags) {
        boolean retval;
        boolean bl = retval = oldTags.size() == newTags.size() && oldTags.keySet().equals(newTags.keySet());
        if (retval) {
            for (Map.Entry<String, GitTag> e : oldTags.entrySet()) {
                GitTag oldTag = e.getValue();
                GitTag newTag = newTags.get(e.getKey());
                if (Objects.equals(oldTag.getTagId(), newTag.getTagId()) && Objects.equals(oldTag.getTagName(), newTag.getTagName()) && Objects.equals(oldTag.getTaggedObjectId(), newTag.getTaggedObjectId())) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private void refreshRemotes(GitClient client) throws GitException {
        Map<String, GitRemoteConfig> newRemotes = client.getRemotes(GitUtils.NULL_PROGRESS_MONITOR);
        this.setRemotes(newRemotes);
    }

    private void refreshStashes(GitClient client) throws GitException {
        this.setStashes(Arrays.asList(client.stashList(GitUtils.NULL_PROGRESS_MONITOR)));
    }

    private boolean refreshIfNotLocked() {
        VCSFileProxy root = this.rootRef.get();
        if (root != null && GitUtils.isRepositoryLocked(root)) {
            return false;
        }
        this.refresh();
        return true;
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        List<PropertyChangeEvent> events = this.eventsToFire.get();
        if (events != null) {
            events.add(event);
        } else {
            this.propertyChangeSupport.firePropertyChange(event);
        }
    }

    public PushMode getPushMode() {
        return this.getPushMode(this.rootRef.get());
    }

    private PushMode getPushMode(VCSFileProxy root) {
        if (root == null) {
            return this.pushMode;
        }
        if (!EventQueue.isDispatchThread()) {
            this.pushMode = JGitUtils.getPushMode(root);
        }
        return this.pushMode;
    }

    private static class RepositoryRefreshTask
    implements Runnable {
        private RepositoryRefreshTask() {
        }

        @Override
        public void run() {
            RepositoryInfo info;
            HashSet<RepositoryInfo> delayed = new HashSet<RepositoryInfo>();
            while ((info = this.getNextRepositoryInfo()) != null) {
                if (info.refreshIfNotLocked()) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "RepositoryRefreshTask: Repository {0} locked, info refresh delayed", info.getName());
                }
                delayed.add(info);
            }
            for (RepositoryInfo toRefresh : delayed) {
                toRefresh.refreshAsync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RepositoryInfo getNextRepositoryInfo() {
            RepositoryInfo info = null;
            Set set = repositoriesToRefresh;
            synchronized (set) {
                Iterator it = repositoriesToRefresh.iterator();
                if (it.hasNext()) {
                    info = (RepositoryInfo)it.next();
                    it.remove();
                }
            }
            return info;
        }
    }

    public static enum PushMode {
        UPSTREAM,
        ASK;

    }
}

