/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class HtmlTransferHandler
extends TransferHandler
implements UIResource {
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private int p0;
    private int p1;

    protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
        DataFlavor plainFlavor = null;
        DataFlavor refFlavor = null;
        DataFlavor stringFlavor = null;
        if (c instanceof JEditorPane) {
            for (int i = 0; i < flavors.length; ++i) {
                String mime = flavors[i].getMimeType();
                if (mime.startsWith(((JEditorPane)c).getEditorKit().getContentType())) continue;
                if (plainFlavor == null && mime.startsWith("text/plain")) {
                    plainFlavor = flavors[i];
                    continue;
                }
                if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                    refFlavor = flavors[i];
                    continue;
                }
                if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                stringFlavor = flavors[i];
            }
            if (plainFlavor != null) {
                return plainFlavor;
            }
            if (refFlavor != null) {
                return refFlavor;
            }
            if (stringFlavor != null) {
                return stringFlavor;
            }
            return null;
        }
        for (int i = 0; i < flavors.length; ++i) {
            String mime = flavors[i].getMimeType();
            if (mime.startsWith("text/plain")) {
                return flavors[i];
            }
            if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                refFlavor = flavors[i];
                continue;
            }
            if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
            stringFlavor = flavors[i];
        }
        if (refFlavor != null) {
            return refFlavor;
        }
        if (stringFlavor != null) {
            return stringFlavor;
        }
        return null;
    }

    protected void handleReaderImport(Reader in, JTextComponent c, boolean useRead) throws BadLocationException, IOException {
        if (useRead) {
            int startPosition = c.getSelectionStart();
            int endPosition = c.getSelectionEnd();
            int length = endPosition - startPosition;
            EditorKit kit = c.getUI().getEditorKit(c);
            Document doc = c.getDocument();
            if (length > 0) {
                doc.remove(startPosition, length);
            }
            kit.read(in, doc, startPosition);
        } else {
            int nch;
            char[] buff = new char[1024];
            boolean lastWasCR = false;
            StringBuffer sbuff = null;
            while ((nch = in.read(buff, 0, buff.length)) != -1) {
                if (sbuff == null) {
                    sbuff = new StringBuffer(nch);
                }
                int last = 0;
                block5: for (int counter = 0; counter < nch; ++counter) {
                    switch (buff[counter]) {
                        case '\r': {
                            if (lastWasCR) {
                                if (counter == 0) {
                                    sbuff.append('\n');
                                    continue block5;
                                }
                                buff[counter - 1] = 10;
                                continue block5;
                            }
                            lastWasCR = true;
                            continue block5;
                        }
                        case '\n': {
                            if (!lastWasCR) continue block5;
                            if (counter > last + 1) {
                                sbuff.append(buff, last, counter - last - 1);
                            }
                            lastWasCR = false;
                            last = counter;
                            continue block5;
                        }
                        default: {
                            if (!lastWasCR) continue block5;
                            if (counter == 0) {
                                sbuff.append('\n');
                            } else {
                                buff[counter - 1] = 10;
                            }
                            lastWasCR = false;
                        }
                    }
                }
                if (last >= nch) continue;
                if (lastWasCR) {
                    if (last >= nch - 1) continue;
                    sbuff.append(buff, last, nch - last - 1);
                    continue;
                }
                sbuff.append(buff, last, nch - last);
            }
            if (lastWasCR) {
                sbuff.append('\n');
            }
            c.replaceSelection(sbuff != null ? sbuff.toString() : "");
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        int actions = 0;
        if (!(c instanceof JPasswordField)) {
            actions = ((JTextComponent)c).isEditable() ? 3 : 1;
        }
        return actions;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        this.exportComp = (JTextComponent)comp;
        this.shouldRemove = true;
        this.p0 = this.exportComp.getSelectionStart();
        this.p1 = this.exportComp.getSelectionEnd();
        return this.p0 != this.p1 ? new HtmlTransferable(this.exportComp, this.p0, this.p1) : null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.shouldRemove && action == 2) {
            HtmlTransferable t = (HtmlTransferable)data;
            t.removeText();
        }
        this.exportComp = null;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        JTextComponent c = (JTextComponent)comp;
        if (c == this.exportComp && c.getCaretPosition() >= this.p0 && c.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean imported = false;
        DataFlavor importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c);
        if (importFlavor != null) {
            try {
                InputContext ic;
                JEditorPane ep;
                boolean useRead = false;
                if (comp instanceof JEditorPane && !(ep = (JEditorPane)comp).getContentType().startsWith("text/plain") && importFlavor.getMimeType().startsWith(ep.getContentType())) {
                    useRead = true;
                }
                if ((ic = c.getInputContext()) != null) {
                    ic.endComposition();
                }
                Reader r = importFlavor.getReaderForText(t);
                this.handleReaderImport(r, c, useRead);
                imported = true;
            }
            catch (UnsupportedFlavorException | IOException | BadLocationException ufe) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        JTextComponent c = (JTextComponent)comp;
        if (!c.isEditable() || !c.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(flavors, c) != null;
    }

    private static class BasicTransferable
    implements Transferable,
    UIResource {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        public BasicTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nRicher = richerFlavors != null ? richerFlavors.length : 0;
            int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
            int nString = this.isPlainSupported() ? stringFlavors.length : 0;
            int nFlavors = nRicher + nHTML + nPlain + nString;
            DataFlavor[] flavors = new DataFlavor[nFlavors];
            int nDone = 0;
            if (nRicher > 0) {
                System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
                nDone += nRicher;
            }
            if (nHTML > 0) {
                System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
                nDone += nHTML;
            }
            if (nPlain > 0) {
                System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
                nDone += nPlain;
            }
            if (nString > 0) {
                System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
                nDone += nString;
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            if (this.isRicherFlavor(flavor)) {
                return this.getRicherData(flavor);
            }
            if (this.isHTMLFlavor(flavor)) {
                String data = this.getHTMLData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isRicherFlavor(DataFlavor flavor) {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
            for (int i = 0; i < nFlavors; ++i) {
                if (!richerFlavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = htmlFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = stringFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException cle) {
                System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
            }
        }
    }

    static class HtmlTransferable
    extends BasicTransferable {
        Position p0;
        Position p1;
        String mimeType;
        String richText;
        JTextComponent c;

        HtmlTransferable(JTextComponent c, int start, int end) {
            super(null, null);
            this.c = c;
            Document doc = c.getDocument();
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
                this.plainData = c.getSelectedText();
                if (c instanceof JEditorPane) {
                    JEditorPane ep = (JEditorPane)c;
                    this.mimeType = ep.getContentType();
                    if (this.mimeType.startsWith("text/plain")) {
                        return;
                    }
                    StringWriter sw = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                    ep.getEditorKit().write(sw, doc, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    if (this.mimeType.startsWith("text/html")) {
                        this.htmlData = sw.toString();
                    } else {
                        this.richText = sw.toString();
                    }
                }
            }
            catch (IOException | BadLocationException ble) {
                // empty catch block
            }
        }

        void removeText() {
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    Document doc = this.c.getDocument();
                    doc.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected DataFlavor[] getRicherFlavors() {
            if (this.richText == null) {
                return null;
            }
            try {
                DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                return flavors;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.richText == null) {
                return null;
            }
            if (String.class.equals(flavor.getRepresentationClass())) {
                return this.richText;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(this.richText);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new ByteArrayInputStream(this.richText.getBytes());
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

