/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.core.WikiText;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.netbeans.modules.mylyn.util.WikiPanel;
import org.netbeans.modules.mylyn.util.wiki.WikiEditPanel;

public class WikiUtils {
    private static final Logger LOG = Logger.getLogger("org.netbeans.mylym.utils.WikiUtils");

    private WikiUtils() {
    }

    public static WikiPanel getWikiPanel(String wikiLanguage, boolean editing, boolean switchable) {
        return new WikiEditPanel(wikiLanguage, editing, switchable);
    }

    public static String getHtmlFormatText(String wikiFormatText, String language) {
        if (language == null || language.isEmpty()) {
            LOG.log(Level.FINE, "Wiki language name is empty");
            return null;
        }
        MarkupLanguage markupLanguage = WikiText.getMarkupLanguage((String)language);
        if (markupLanguage == null) {
            LOG.log(Level.FINE, "Markup language for name {0} not found", language);
            return null;
        }
        MarkupParser parser = new MarkupParser(markupLanguage);
        String dirtyHtml = parser.parseToHtml(wikiFormatText);
        return WikiUtils.cleanHtmlTags(dirtyHtml);
    }

    private static String cleanHtmlTags(String html) {
        html = html.replaceFirst("<\\?xml.*?>", "");
        html = html.replaceAll("<html.*?>", "<html>");
        boolean remove = (html = html.replaceAll("<head>.*</head>", "")).contains("<body><p>");
        if (remove) {
            html = html.replaceFirst("<body><p>", "<body>");
            html = html.replaceFirst("</p>", "");
        }
        return html;
    }
}

