/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

class HistoryActionSupport<H> {
    private final Callback<H> callback;
    private static final Logger LOG = Logger.getLogger(HistoryActionSupport.class.getName());

    public HistoryActionSupport(Callback<H> callback) {
        this.callback = callback;
    }

    protected String getRevisionShort() {
        Node node2;
        if (this.callback.getContext() == null) {
            return null;
        }
        Collection nodes = this.callback.getContext().lookupAll(Node.class);
        HistoryEntryWrapper<H> he = null;
        Iterator i$ = nodes.iterator();
        while (i$.hasNext() && (he = this.callback.lookupEntry(node2 = (Node)i$.next())) == null) {
        }
        if (he == null) {
            LOG.log(Level.WARNING, "No history entry under the nodes");
            for (Node node2 : nodes) {
                LOG.log(Level.INFO, "Node {0} --- {1}", new Object[]{node2, node2.getLookup().lookupAll(Object.class)});
            }
            assert (he != null);
        }
        return he == null ? null : he.getRevisionShort();
    }

    protected void performAction(Node[] activatedNodes) {
        HashMap m = new HashMap(activatedNodes.length);
        for (Node node : activatedNodes) {
            HistoryEntryWrapper<H> he = this.callback.lookupEntry(node);
            if (he == null) continue;
            Collection fos = node.getLookup().lookupAll(VCSFileProxy.class);
            assert (fos != null);
            HashSet<VCSFileProxy> files = (HashSet<VCSFileProxy>)m.get(he);
            if (files == null) {
                files = new HashSet<VCSFileProxy>();
                m.put(he, files);
            }
            for (VCSFileProxy f : fos) {
                if (f == null) continue;
                files.add(f);
            }
        }
        for (Map.Entry e : m.entrySet()) {
            Set files = (Set)e.getValue();
            if (files == null || files.isEmpty()) continue;
            this.callback.call(((HistoryEntryWrapper)e.getKey()).getHistoryEntry(), (Set)e.getValue());
        }
    }

    boolean hasEntryAndFiles(Node[] nodes) {
        boolean multipleHistory = this.callback.isMultipleHistory();
        VCSFileProxy file = null;
        HistoryEntryWrapper<H> historyEntry = null;
        for (Node node : nodes) {
            HistoryEntryWrapper<H> he = this.callback.lookupEntry(node);
            if (he == null) continue;
            if (historyEntry == null) {
                historyEntry = he;
            } else if (!(multipleHistory || he.getDateTime().equals(historyEntry.getDateTime()) && he.getRevision().equals(historyEntry.getRevision()))) {
                return false;
            }
            Collection<VCSFileProxy> fos = this.lookupFiles(node);
            if (fos == null) continue;
            for (VCSFileProxy f : fos) {
                if (f == null) continue;
                file = f;
                break;
            }
            if (!multipleHistory || historyEntry == null || file == null) continue;
            return true;
        }
        return historyEntry != null && file != null;
    }

    private Collection<? extends VCSFileProxy> lookupFiles(Node node) {
        return node.getLookup().lookupAll(VCSFileProxy.class);
    }

    static interface HistoryEntryWrapper<H> {
        public H getHistoryEntry();

        public String getRevisionShort();

        public Date getDateTime();

        public String getRevision();
    }

    public static interface Callback<H> {
        public void call(H var1, Set<VCSFileProxy> var2);

        public HistoryEntryWrapper<H> lookupEntry(Node var1);

        public Lookup getContext();

        public boolean isMultipleHistory();
    }
}

