/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cordova.CordovaPlatform;
import org.netbeans.modules.cordova.options.Bundle;
import org.netbeans.modules.cordova.options.MobilePlatformsOptionsPanelController;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.ProvisioningProfile;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class MobilePlatformsPanel
extends JPanel {
    private final MobilePlatformsOptionsPanelController controller;
    private DocumentListener documentL;
    private String codeSignIdentity;
    private Collection<? extends ProvisioningProfile> provisioningProfiles;
    private String provisioningProfilePath;
    private boolean inited = false;
    private JPanel androidPanel;
    private JButton androidSdkBrowse;
    private JLabel androidSdkDownload;
    private JTextField androidSdkField;
    private JLabel androidSdkLabel;
    private JLabel androidVersion;
    private JLabel cordovaVersionLabel;
    private JLabel envVarWarnLabel;
    private JPanel iOSPanel;
    private JLabel identityLabel;
    private JTextField identityTextField;
    private JButton provisioningBrowse;
    private JComboBox provisioningCombo;
    private JLabel provisioningProfile;

    MobilePlatformsPanel(MobilePlatformsOptionsPanelController controller) {
        this.controller = controller;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(Bundle.LBL_PleaseWait(), 0), "Center");
    }

    private void initComponents() {
        this.provisioningBrowse = new JButton();
        this.androidPanel = new JPanel();
        this.androidSdkLabel = new JLabel();
        this.androidSdkField = new JTextField();
        this.androidSdkBrowse = new JButton();
        this.androidSdkDownload = new JLabel();
        this.androidVersion = new JLabel();
        this.envVarWarnLabel = new JLabel();
        this.iOSPanel = new JPanel();
        this.identityLabel = new JLabel();
        this.identityTextField = new JTextField();
        this.provisioningProfile = new JLabel();
        this.provisioningCombo = new JComboBox();
        this.cordovaVersionLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.provisioningBrowse, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.androidSdkBrowse.text"));
        Mnemonics.setLocalizedText((JLabel)this.androidSdkLabel, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.androidSdkLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.androidSdkBrowse, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.androidSdkBrowse.text"));
        this.androidSdkBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobilePlatformsPanel.this.androidSdkBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.androidSdkDownload, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.androidSdkDownload.text"));
        this.androidSdkDownload.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MobilePlatformsPanel.this.androidSdkDownloadMouseClicked(evt);
            }
        });
        this.envVarWarnLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.envVarWarnLabel, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.envVarWarnLabel.text"));
        GroupLayout androidPanelLayout = new GroupLayout(this.androidPanel);
        this.androidPanel.setLayout(androidPanelLayout);
        androidPanelLayout.setHorizontalGroup(androidPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(androidPanelLayout.createSequentialGroup().addContainerGap().addGroup(androidPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(androidPanelLayout.createSequentialGroup().addComponent(this.androidSdkLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(androidPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(androidPanelLayout.createSequentialGroup().addComponent(this.androidSdkField, -1, 357, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.androidSdkBrowse)).addGroup(androidPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.androidVersion, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.androidSdkDownload, -2, -1, -2)))).addComponent(this.envVarWarnLabel)).addContainerGap()));
        androidPanelLayout.setVerticalGroup(androidPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(androidPanelLayout.createSequentialGroup().addContainerGap(18, Short.MAX_VALUE).addGroup(androidPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.androidSdkLabel).addComponent(this.androidSdkField, -2, -1, -2).addComponent(this.androidSdkBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(androidPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.androidSdkDownload, -2, -1, -2).addComponent(this.androidVersion, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.envVarWarnLabel, -2, -1, -2).addContainerGap()));
        Mnemonics.setLocalizedText((JLabel)this.identityLabel, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.identityLabel.text"));
        this.identityTextField.setText("iPhone Developer");
        Mnemonics.setLocalizedText((JLabel)this.provisioningProfile, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"MobilePlatformsPanel.provisioningProfile.text"));
        this.provisioningCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MobilePlatformsPanel.this.provisioningComboItemStateChanged(evt);
            }
        });
        GroupLayout iOSPanelLayout = new GroupLayout(this.iOSPanel);
        this.iOSPanel.setLayout(iOSPanelLayout);
        iOSPanelLayout.setHorizontalGroup(iOSPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iOSPanelLayout.createSequentialGroup().addContainerGap().addGroup(iOSPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.identityLabel).addComponent(this.provisioningProfile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(iOSPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.identityTextField, -1, 347, Short.MAX_VALUE).addComponent(this.provisioningCombo, 0, -1, Short.MAX_VALUE)).addGap(100, 100, 100)));
        iOSPanelLayout.setVerticalGroup(iOSPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iOSPanelLayout.createSequentialGroup().addContainerGap().addGroup(iOSPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.identityLabel).addComponent(this.identityTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(iOSPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.provisioningProfile).addComponent(this.provisioningCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.cordovaVersionLabel, (String)NbBundle.getMessage(MobilePlatformsPanel.class, (String)"LBL_Cordova_Version"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.androidPanel, -1, -1, Short.MAX_VALUE).addComponent(this.iOSPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cordovaVersionLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.androidPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.iOSPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.cordovaVersionLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void androidSdkBrowseActionPerformed(ActionEvent evt) {
        File sdkDir = new FileChooserBuilder(MobilePlatformsPanel.class).setDirectoriesOnly(true).setTitle(Bundle.LBL_AndroidPath()).showOpenDialog();
        if (sdkDir != null) {
            this.androidSdkField.setText(sdkDir.getAbsolutePath());
        }
    }

    private void androidSdkDownloadMouseClicked(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://developer.android.com/sdk/index.html"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void provisioningComboItemStateChanged(ItemEvent evt) {
        this.fireChanged();
    }

    void load() {
        MobilePlatform iosPlatform = PlatformManager.getPlatform((String)"ios");
        this.codeSignIdentity = iosPlatform.getCodeSignIdentity();
        this.provisioningProfiles = iosPlatform.getProvisioningProfiles();
        this.provisioningProfilePath = iosPlatform.getProvisioningProfilePath();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MobilePlatformsPanel.this.setupComponenets();
            }
        });
        final CordovaPlatform.Version cordovaVersion = CordovaPlatform.getDefault().getVersion();
        if (cordovaVersion != null) {
            CordovaPlatform.getDefault().isReady();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MobilePlatformsPanel.this.displayCordovaVersion(cordovaVersion);
            }
        });
    }

    void setupComponenets() {
        if (!this.inited) {
            this.removeAll();
            this.initComponents();
            boolean androidHomeSet = System.getenv("ANDROID_HOME") != null;
            this.envVarWarnLabel.setVisible(Utilities.isUnix() && !Utilities.isMac() && !androidHomeSet);
            this.documentL = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    MobilePlatformsPanel.this.fireChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    MobilePlatformsPanel.this.fireChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    MobilePlatformsPanel.this.fireChanged();
                }
            };
            this.identityTextField.setEnabled(Utilities.isMac());
            this.provisioningCombo.setEnabled(Utilities.isMac());
            this.inited = true;
        }
        if (this.documentL != null) {
            this.androidSdkField.getDocument().removeDocumentListener(this.documentL);
        }
        this.androidSdkField.setText(PlatformManager.getPlatform((String)"android").getSdkLocation());
        this.identityTextField.setText(this.codeSignIdentity);
        this.provisioningCombo.setModel(new DefaultComboBoxModel<Object>(this.provisioningProfiles.toArray()));
        for (ProvisioningProfile provisioningProfile : this.provisioningProfiles) {
            if (!provisioningProfile.getPath().equals(this.provisioningProfilePath)) continue;
            this.provisioningCombo.setSelectedItem(provisioningProfile);
        }
        this.androidSdkField.getDocument().addDocumentListener(this.documentL);
        this.identityTextField.getDocument().addDocumentListener(this.documentL);
        this.validate();
    }

    private void displayCordovaVersion(CordovaPlatform.Version cordovaVersion) {
        if (cordovaVersion != null) {
            this.cordovaVersionLabel.setText(NbBundle.getMessage(MobilePlatformsPanel.class, (String)"LBL_Cordova_Version", (Object)cordovaVersion.getApiVersion().toString()));
        } else {
            this.cordovaVersionLabel.setText(NbBundle.getMessage(MobilePlatformsPanel.class, (String)"LBL_Cordova_Not_Found"));
            this.cordovaVersionLabel.setForeground(Color.red);
        }
    }

    private void fireChanged() {
        boolean isChanged;
        String sdkLocation;
        MobilePlatform androidPlatform = PlatformManager.getPlatform((String)"android");
        String string = sdkLocation = androidPlatform == null ? "" : androidPlatform.getSdkLocation();
        if (sdkLocation == null) {
            sdkLocation = "";
        }
        boolean bl = isChanged = !sdkLocation.equals(this.androidSdkField.getText().trim());
        if (this.identityTextField.isEnabled()) {
            MobilePlatform iosPlatform = PlatformManager.getPlatform((String)"ios");
            String signIdentity = iosPlatform == null ? "" : iosPlatform.getCodeSignIdentity();
            isChanged |= !signIdentity.equals(this.identityTextField.getText().trim());
            ProvisioningProfile prov = (ProvisioningProfile)this.provisioningCombo.getSelectedItem();
            if (prov != null && iosPlatform != null) {
                isChanged |= !iosPlatform.getProvisioningProfilePath().equals(prov.getPath());
            }
        }
        this.controller.changed(isChanged);
    }

    void store() {
        MobilePlatform iOSPlatform;
        MobilePlatform androidPlatform = PlatformManager.getPlatform((String)"android");
        if (androidPlatform != null && this.androidSdkField != null) {
            androidPlatform.setSdkLocation(this.androidSdkField.getText());
        }
        if ((iOSPlatform = PlatformManager.getPlatform((String)"ios")) != null && this.identityTextField != null && this.provisioningCombo != null) {
            iOSPlatform.setCodeSignIdentity(this.identityTextField.getText());
            ProvisioningProfile prov = (ProvisioningProfile)this.provisioningCombo.getSelectedItem();
            if (prov != null) {
                iOSPlatform.setProvisioningProfilePath(prov.getPath());
            }
        }
    }

    boolean valid() {
        boolean adroidValid;
        if (!this.inited) {
            return true;
        }
        File androidLoc = new File(this.androidSdkField.getText());
        File androidTools = new File(androidLoc, "platform-tools");
        boolean bl = adroidValid = this.androidSdkField.getText().isEmpty() || androidLoc.exists() && androidLoc.isDirectory() && androidTools.exists() && androidTools.isDirectory();
        if (!adroidValid) {
            this.androidVersion.setText(Bundle.ERR_NoAndroid());
            this.androidVersion.setForeground(Color.red);
        } else {
            this.androidVersion.setText("");
            this.androidVersion.setForeground(UIManager.getColor("Label.foreground"));
        }
        return adroidValid;
    }
}

