/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.wizard;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.project.ConfigUtils;
import org.netbeans.modules.cordova.wizard.Bundle;
import org.netbeans.modules.web.clientproject.spi.ClientProjectExtender;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class CordovaProjectExtender
implements ClientProjectExtender {
    public WizardDescriptor.Panel<WizardDescriptor>[] createWizardPanels() {
        return new WizardDescriptor.Panel[0];
    }

    public void apply(FileObject projectRoot, FileObject siteRoot, String librariesPath) {
        try {
            CordovaProjectExtender.createMobileConfigs(projectRoot);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void createMobileConfigs(FileObject projectRoot) throws IOException {
        File f = new File(projectRoot.getPath() + "/nbproject/configs/ios.properties");
        if (!f.exists()) {
            EditableProperties ios = new EditableProperties(true);
            ios.put("display.name", Bundle.LBL_iPhoneSimulator());
            ios.put("type", "ios");
            ios.put("device", "emulator");
            ios.put("ios.build.sdk", PlatformManager.getPlatform((String)"ios").getPrefferedTarget().getIdentifier());
            ios.put("ios.build.arch", "i386");
            ConfigUtils.createConfigFile(projectRoot, "ios", ios);
        }
        FileObject fob = FileUtil.toFileObject((File)f);
        assert (fob != null);
        f = new File(projectRoot.getPath() + "/nbproject/configs/ios_1.properties");
        if (!f.exists()) {
            EditableProperties iosdev = new EditableProperties(true);
            iosdev.put("display.name", Bundle.LBL_iPhoneDevice());
            iosdev.put("type", "ios");
            iosdev.put("device", "device");
            String sim = PlatformManager.getPlatform((String)"ios").getPrefferedTarget().getIdentifier();
            iosdev.put("ios.build.sdk", sim.replace("iphonesimulator", "iphoneos"));
            iosdev.put("ios.build.arch", sim.startsWith("iphonesimulator6") ? "armv6 armv7" : "armv7 armv7s");
            ConfigUtils.createConfigFile(projectRoot, "ios", iosdev);
        }
        fob = FileUtil.toFileObject((File)f);
        assert (fob != null);
        f = new File(projectRoot.getPath() + "/nbproject/configs/android.properties");
        if (!f.exists()) {
            EditableProperties androide = new EditableProperties(true);
            androide.put("display.name", Bundle.LBL_AndroidEmulator());
            androide.put("type", "android");
            androide.put("device", "emulator");
            ConfigUtils.createConfigFile(projectRoot, "android", androide);
        }
        fob = FileUtil.toFileObject((File)f);
        assert (fob != null);
        f = new File(projectRoot.getPath() + "/nbproject/configs/android_1.properties");
        if (!f.exists()) {
            EditableProperties androidd = new EditableProperties(true);
            androidd.put("display.name", Bundle.LBL_AndroidDevice());
            androidd.put("type", "android");
            androidd.put("device", "device");
            ConfigUtils.createConfigFile(projectRoot, "android", androidd);
        }
        fob = FileUtil.toFileObject((File)f);
        assert (fob != null);
    }

    public WizardDescriptor.Panel<WizardDescriptor>[] createInitPanels() {
        return new WizardDescriptor.Panel[0];
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
    }
}

