/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

final class RootsListener {
    private static final Logger LOG = Logger.getLogger(RootsListener.class.getName());
    private static final boolean USE_RECURSIVE_LISTENERS = Util.getSystemBoolean("netbeans.indexing.recursiveListeners", true);
    private static volatile boolean useAsyncListneres = Util.getSystemBoolean("netbeans.indexing.asyncListeners", true);
    private static final RequestProcessor RP = new RequestProcessor(RootsListener.class);
    private FileChangeListener sourcesListener;
    private FileChangeListener binariesListener;
    private final Map<URL, File> sourceRoots = new HashMap<URL, File>();
    private final Map<URL, Pair<File, Boolean>> binaryRoots = new HashMap<URL, Pair<File, Boolean>>();
    private volatile boolean listens;

    private RootsListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListener(FileChangeListener sourcesListener, FileChangeListener binariesListener) {
        assert (sourcesListener != null && binariesListener != null || sourcesListener == null && binariesListener == null) : "Both sourcesListener and binariesListener must either be null or non-null";
        RootsListener rootsListener = this;
        synchronized (rootsListener) {
            if (sourcesListener != null) {
                assert (this.sourcesListener == null) : "Already using " + this.sourcesListener + "and " + this.binariesListener + ", won't attach " + sourcesListener + " and " + binariesListener;
                assert (this.sourceRoots.isEmpty()) : "Expecting no source roots: " + this.sourceRoots;
                assert (this.binaryRoots.isEmpty()) : "Expecting no binary roots: " + this.binaryRoots;
                this.sourcesListener = sourcesListener;
                this.binariesListener = binariesListener;
                if (!USE_RECURSIVE_LISTENERS) {
                    FileUtil.addFileChangeListener((FileChangeListener)this.sourcesListener);
                }
                this.listens = true;
            } else {
                assert (this.sourcesListener != null) : "RootsListeners are already dormant";
                if (!USE_RECURSIVE_LISTENERS) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this.sourcesListener);
                }
                for (Map.Entry<URL, File> entry : this.sourceRoots.entrySet()) {
                    RootsListener.safeRemoveRecursiveListener(this.sourcesListener, entry.getValue());
                }
                this.sourceRoots.clear();
                for (Map.Entry<URL, File> entry : this.binaryRoots.entrySet()) {
                    if (((Boolean)((Pair)entry.getValue()).second()).booleanValue()) {
                        RootsListener.safeRemoveFileChangeListener(this.binariesListener, (File)((Pair)entry.getValue()).first());
                        continue;
                    }
                    RootsListener.safeRemoveRecursiveListener(this.binariesListener, (File)((Pair)entry.getValue()).first());
                }
                this.binaryRoots.clear();
                this.sourcesListener = null;
                this.binariesListener = null;
                this.listens = false;
            }
        }
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    synchronized boolean addBinary(@NonNull URL root) {
        if (this.binariesListener != null && !this.binaryRoots.containsKey(root)) {
            File f = null;
            URL archiveUrl = FileUtil.getArchiveFile((URL)root);
            try {
                URI uri;
                URI uRI = uri = archiveUrl != null ? archiveUrl.toURI() : root.toURI();
                if (uri.getScheme().equals("file")) {
                    f = BaseUtilities.toFile((URI)uri);
                }
            }
            catch (URISyntaxException use) {
                LOG.log(Level.INFO, "Can't convert: {0} to java.io.File, due to: {1}, (archive url: {2}).", new Object[]{root, use.getMessage(), archiveUrl});
            }
            if (f != null) {
                if (archiveUrl != null) {
                    this.safeAddFileChangeListener(this.binariesListener, f);
                } else {
                    this.safeAddRecursiveListener(this.binariesListener, f, null);
                }
                this.binaryRoots.put(root, (Pair<File, Boolean>)Pair.of((Object)f, (Object)(archiveUrl != null ? 1 : 0)));
            }
        }
        return this.listens;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    synchronized boolean addSource(@NonNull URL root, @NullAllowed ClassPath.Entry entry) {
        if (this.sourcesListener != null && !this.sourceRoots.containsKey(root) && root.getProtocol().equals("file")) {
            try {
                File f = BaseUtilities.toFile((URI)root.toURI());
                this.safeAddRecursiveListener(this.sourcesListener, f, entry);
                this.sourceRoots.put(root, f);
            }
            catch (URISyntaxException use) {
                LOG.log(Level.INFO, null, use);
            }
        }
        return this.listens;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    synchronized void removeBinaries(@NonNull Iterable<? extends URL> roots) {
        for (URL uRL : roots) {
            Pair<File, Boolean> pair;
            if (this.binariesListener == null || (pair = this.binaryRoots.remove(uRL)) == null) continue;
            if (((Boolean)pair.second()).booleanValue()) {
                RootsListener.safeRemoveFileChangeListener(this.binariesListener, (File)pair.first());
                continue;
            }
            RootsListener.safeRemoveRecursiveListener(this.binariesListener, (File)pair.first());
        }
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    synchronized void removeSources(@NonNull Iterable<? extends URL> roots) {
        for (URL uRL : roots) {
            File f;
            if (this.sourcesListener == null || (f = this.sourceRoots.remove(uRL)) == null) continue;
            RootsListener.safeRemoveRecursiveListener(this.sourcesListener, f);
        }
    }

    boolean hasRecursiveListeners() {
        return USE_RECURSIVE_LISTENERS;
    }

    @NonNull
    static RootsListener newInstance() {
        return new RootsListener();
    }

    static void setUseAsyncListneres(boolean asyncListeners) {
        useAsyncListneres = asyncListeners;
    }

    private void safeAddFileChangeListener(final @NonNull FileChangeListener listener, final @NonNull File path) {
        RootsListener.performSave(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FileUtil.addFileChangeListener((FileChangeListener)listener, (File)path);
                return null;
            }
        });
    }

    private static void safeRemoveFileChangeListener(final @NonNull FileChangeListener listener, final @NonNull File path) {
        RootsListener.performSave(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FileUtil.removeFileChangeListener((FileChangeListener)listener, (File)path);
                return null;
            }
        });
    }

    private void safeAddRecursiveListener(final @NonNull FileChangeListener listener, final @NonNull File path, final @NullAllowed ClassPath.Entry entry) {
        if (USE_RECURSIVE_LISTENERS) {
            final FileFilter filter = entry == null ? null : new FileFilter(){

                @Override
                public boolean accept(@NonNull File pathname) {
                    try {
                        return entry.includes(BaseUtilities.toURI((File)pathname).toURL());
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return true;
                    }
                }
            };
            RootsListener.performAsync(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FileUtil.addRecursiveListener((FileChangeListener)listener, (File)path, (FileFilter)filter, (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return !RootsListener.this.listens;
                        }
                    });
                    return null;
                }
            });
        }
    }

    private static void safeRemoveRecursiveListener(final @NonNull FileChangeListener listener, final @NonNull File path) {
        if (USE_RECURSIVE_LISTENERS) {
            RootsListener.performAsync(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FileUtil.removeRecursiveListener((FileChangeListener)listener, (File)path);
                    return null;
                }
            });
        }
    }

    private static <T> void performAsync(final @NonNull Callable<T> action) {
        if (useAsyncListneres) {
            RP.execute(new Runnable(){

                @Override
                public void run() {
                    RootsListener.performSave(action);
                }
            });
        } else {
            RootsListener.performSave(action);
        }
    }

    private static <T> T performSave(@NonNull Callable<T> action) {
        try {
            return action.call();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.FINE, null, e);
            return null;
        }
    }
}

