/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JavaProjectsTabOperator;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.NewJavaProjectNameLocationStepOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.PluginsOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.DeleteAction;
import org.netbeans.jellytools.actions.EditAction;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.modules.form.FormDesignerOperator;
import org.netbeans.jellytools.nodes.JavaProjectRootNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jellytools.nodes.SourcePackagesNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.junit.NbPerformanceTest;
import org.netbeans.modules.performance.utilities.PerformanceTestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class CommonUtilities {
    public static final String SOURCE_PACKAGES = "Source Packages";
    public static final String TEST_PACKAGES = "Test Packages";
    private static PerformanceTestCase test = null;
    private static DocumentBuilderFactory dbf = null;
    private static DocumentBuilder db = null;
    private static Document allPerfDoc = null;
    private static Element testResultsTag;
    private static Element testTag;
    private static Element perfDataTag;
    private static Element testSuiteTag;
    private static String projectsDir;
    private static String tempDir;

    public static String getProjectsDir() {
        return projectsDir;
    }

    public static String getTempDir() {
        return tempDir;
    }

    public static void cleanTempDir() throws IOException {
        File dir = new File(tempDir);
        CommonUtilities.deleteFile(dir);
        dir.mkdirs();
    }

    public static void deleteFile(File file) throws IOException {
        boolean result;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                CommonUtilities.deleteFile(files[i]);
            }
        }
        if (!(result = file.delete())) {
            throw new IOException("Cannot delete file, file = " + file.getPath());
        }
    }

    public static String getTimeIndex() {
        return new SimpleDateFormat("HHmmssS", Locale.US).format(new Date());
    }

    public static void closeBluePrints() {
        new TopComponentOperator(Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.blueprints.Bundle", (String)"LBL_Tab_Title")).close();
    }

    public static void closeAllDocuments() {
        EditorOperator.closeDiscardAll();
    }

    public static void closeMemoryToolbar() {
        try {
            FileObject fo = FileUtil.getConfigFile((String)"Toolbars/Memory");
            if (fo != null) {
                fo.delete();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        CommonUtilities.maximizeWholeNetbeansWindow();
    }

    public static void installPlugin(String name) {
        PluginsOperator po = PluginsOperator.invoke();
        po.install(name);
        po.close();
    }

    private static void closeToolbar(String menu) {
        MainWindowOperator mainWindow = MainWindowOperator.getDefault();
        JMenuBarOperator menuBar = new JMenuBarOperator(mainWindow.getJMenuBar());
        JMenuItemOperator menuItem = menuBar.showMenuItem(menu, "|");
        if (menuItem.isSelected()) {
            menuItem.push();
        } else {
            menuItem.pushKey(27);
            mainWindow.pushKey(27);
        }
    }

    public static void workarroundMainMenuRolledUp() {
        if (System.getProperty("java.version").indexOf("1.4") != -1) {
            String helpMenu = Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/Help") + "|" + Bundle.getStringTrimmed((String)"org.netbeans.core.actions.Bundle", (String)"About");
            String about = Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle_nb", (String)"CTL_About_Title");
            new ActionNoBlock(helpMenu, null).perform();
            new NbDialogOperator(about).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jEditProjectOpen() {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        int BUFFER = 2048;
        try {
            int numRead;
            URL url = new URL("http://spbweb.russia.sun.com/~ok153203/jEdit41.zip");
            out = new BufferedOutputStream(new FileOutputStream(System.getProperty("nbjunit.workdir") + File.separator + "tmpdir" + File.separator + "jEdit41.zip"));
            conn = url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(new File(System.getProperty("nbjunit.workdir") + File.separator + "tmpdir" + File.separator + "jEdit41.zip"));
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory()) {
                    new File(System.getProperty("nbjunit.workdir") + File.separator + ".." + File.separator + "data" + File.separator + entry.getName()).mkdir();
                    continue;
                }
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(System.getProperty("nbjunit.workdir") + File.separator + ".." + File.separator + "data" + File.separator + entry.getName());
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = zis.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return System.getProperty("nbjunit.workdir") + File.separator + "tmpdir" + File.separator + "jEdit41.zip";
    }

    public static void openFiles(String project, String[][] files_path) {
        Node[] openFileNodes = new Node[files_path.length];
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(project);
        for (int i = 0; i < files_path.length; ++i) {
            openFileNodes[i] = new Node((Node)sourcePackagesNode, files_path[i][0] + '|' + files_path[i][1]);
        }
        new OpenAction().performAPI(openFileNodes);
    }

    public static void copyFile(File f1, File f2) throws FileNotFoundException, IOException {
        int data;
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f1));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f2));
        while ((data = ((InputStream)fis).read()) != -1) {
            ((OutputStream)fos).write(data);
        }
    }

    public static EditorOperator openFile(Node fileNode, String filename, boolean waitforeditor) {
        new OpenAction().performAPI(fileNode);
        if (waitforeditor) {
            EditorOperator editorOperator = new EditorOperator(filename);
            return editorOperator;
        }
        return null;
    }

    public static EditorOperator openFile(String project, String filepackage, String filename, boolean waitforeditor) {
        return CommonUtilities.openFile(new Node((Node)new SourcePackagesNode(project), filepackage + "|" + filename), filename, waitforeditor);
    }

    public static EditorOperator editFile(String project, String filepackage, String filename) {
        Node filenode = new Node((Node)new SourcePackagesNode(project), filepackage + "|" + filename);
        new EditAction().performAPI(filenode);
        EditorOperator editorOperator = new EditorOperator(filename);
        return editorOperator;
    }

    public static FormDesignerOperator openSmallFormFile() {
        Node openFile = new Node((Node)new SourcePackagesNode("PerformanceTestData"), "org.netbeans.test.performance|JFrame20kB.java");
        new OpenAction().performAPI(openFile);
        return new FormDesignerOperator("JFrame20kB");
    }

    public static void insertToFile(String filename, int line, String text, boolean save) {
        EditorOperator editorOperator = new EditorOperator(filename);
        editorOperator.setCaretPositionToLine(line);
        editorOperator.insert(text);
        if (save) {
            editorOperator.save();
        }
    }

    public static String createproject(String category, String project, boolean wait) {
        ProjectsTabOperator.invoke();
        NewProjectWizardOperator wizard = NewProjectWizardOperator.invoke();
        wizard.selectCategory(category);
        wizard.selectProject(project);
        wizard.next();
        NewJavaProjectNameLocationStepOperator wizard_location = new NewJavaProjectNameLocationStepOperator();
        wizard_location.txtProjectLocation().clearText();
        wizard_location.txtProjectLocation().typeText(CommonUtilities.getTempDir());
        String pname = wizard_location.txtProjectName().getText() + System.currentTimeMillis();
        wizard_location.txtProjectName().clearText();
        wizard_location.txtProjectName().typeText(pname);
        wizard.finish();
        CommonUtilities.waitForProjectCreation(10000, wait);
        return pname;
    }

    protected static void waitForProjectCreation(int delay, boolean wait) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException exc) {
            exc.printStackTrace(System.err);
        }
        if (wait) {
            CommonUtilities.waitForPendingBackgroundTasks();
        }
    }

    public static void deleteProject(String project) {
        CommonUtilities.deleteProject(project, false);
    }

    public static void deleteProject(String project, boolean waitStatus) {
        new DeleteAction().performAPI((Node)ProjectsTabOperator.invoke().getProjectRootNode(project));
        NbDialogOperator deleteProject = new NbDialogOperator("Delete Project");
        JCheckBoxOperator delete_sources = new JCheckBoxOperator((ContainerOperator)deleteProject);
        if (delete_sources.isEnabled()) {
            delete_sources.changeSelection(true);
        }
        deleteProject.yes();
        CommonUtilities.waitForPendingBackgroundTasks();
        if (waitStatus) {
            MainWindowOperator.getDefault().waitStatusText("Finished building " + project + " (clean)");
        }
        try {
            new NbDialogOperator("Question").yes();
        }
        catch (Exception exc) {
            System.err.println("No Question dialog rises - no problem this is just workarround!");
            exc.printStackTrace(System.err);
        }
    }

    public static void buildProject(String project) {
        JavaProjectRootNode prn = JavaProjectsTabOperator.invoke().getJavaProjectRootNode(project);
        prn.buildProject();
        Operator.StringComparator sc = MainWindowOperator.getDefault().getComparator();
        MainWindowOperator.getDefault().setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(false, true));
        MainWindowOperator.getDefault().waitStatusText("Finished building ");
        MainWindowOperator.getDefault().setComparator(sc);
    }

    public static void actionOnProject(String project, String pushAction) {
        ProjectRootNode prn;
        try {
            prn = ProjectsTabOperator.invoke().getProjectRootNode(project);
        }
        catch (TimeoutExpiredException e) {
            prn = new ProjectsTabOperator().getProjectRootNode(project);
        }
        prn.callPopup().pushMenuNoBlock(pushAction);
    }

    public static void runProject(String project) {
        CommonUtilities.actionOnProject(project, "Run Project");
    }

    public static void debugProject(String project) {
        CommonUtilities.actionOnProject(project, "Debug Project");
    }

    public static void testProject(String project) {
        CommonUtilities.actionOnProject(project, "Test Project");
    }

    public static void deployProject(String project) {
        CommonUtilities.actionOnProject(project, "Deploy Project");
        CommonUtilities.waitForPendingBackgroundTasks();
        MainWindowOperator.getDefault().waitStatusText("Finished building " + project + " (run-deploy)");
    }

    public static void verifyProject(String project) {
        CommonUtilities.actionOnProject(project, "Verify Project");
        MainWindowOperator.getDefault().waitStatusText("Finished building " + project + " (verify)");
    }

    public static void waitProjectOpenedScanFinished(String projectFolder) {
    }

    public static void waitForPendingBackgroundTasks() {
    }

    public static void addApplicationServer() {
        String glassfishHome = System.getProperty("glassfish.home");
        if (glassfishHome == null) {
            throw new Error("Can't add GlassFish server. glassfish.home property is not set.");
        }
        String addServerMenuItem = Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle", (String)"LBL_Add_Server_Instance");
        String addServerInstanceDialogTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.wizard.Bundle", (String)"LBL_ASIW_Title");
        RuntimeTabOperator rto = RuntimeTabOperator.invoke();
        Node serversNode = new Node(rto.getRootNode(), "Servers");
        if (!serversNode.isChildPresent("GlassFish")) {
            serversNode.performPopupActionNoBlock(addServerMenuItem);
            WizardOperator addServerInstanceDialog = new WizardOperator(addServerInstanceDialogTitle);
            new JListOperator((ContainerOperator)addServerInstanceDialog, 1).selectItem("GlassFish Server");
            addServerInstanceDialog.next();
            new JTextFieldOperator((ContainerOperator)addServerInstanceDialog).setText(glassfishHome);
            addServerInstanceDialog.next();
            addServerInstanceDialog.finish();
        }
    }

    public static Node getTomcatServerNode() {
        return new Node(RuntimeTabOperator.invoke().getRootNode(), "Servers|Tomcat");
    }

    public static Node getApplicationServerNode() {
        return new Node(RuntimeTabOperator.invoke().getRootNode(), "Servers|GlassFish");
    }

    public static Node startTomcatServer() {
        Node node = CommonUtilities.performTomcatServerAction("Start");
        new EventTool().waitNoEvent(10000L);
        return node;
    }

    public static Node stopTomcatServer() {
        Node node = CommonUtilities.performTomcatServerAction("Stop");
        new EventTool().waitNoEvent(10000L);
        return node;
    }

    public static void addTomcatServer() {
        String appServerPath = System.getProperty("tomcat.installRoot");
        if (appServerPath == null) {
            throw new Error("Can't add tomcat server. tomcat.installRoot property is not set.");
        }
        String addServerMenuItem = Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle", (String)"LBL_Add_Server_Instance");
        String addServerInstanceDialogTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.wizard.Bundle", (String)"LBL_ASIW_Title");
        String nextButtonCaption = Bundle.getStringTrimmed((String)"org.openide.Bundle", (String)"CTL_NEXT");
        String finishButtonCaption = Bundle.getStringTrimmed((String)"org.openide.Bundle", (String)"CTL_FINISH");
        RuntimeTabOperator rto = RuntimeTabOperator.invoke();
        Node serversNode = new Node(rto.getRootNode(), "Servers");
        if (!serversNode.isChildPresent("Tomcat")) {
            serversNode.performPopupActionNoBlock(addServerMenuItem);
            NbDialogOperator addServerInstanceDialog = new NbDialogOperator(addServerInstanceDialogTitle);
            new JListOperator((ContainerOperator)addServerInstanceDialog, 1).selectItem("Tomcat");
            new JButtonOperator((ContainerOperator)addServerInstanceDialog, nextButtonCaption).push();
            new JTextFieldOperator((ContainerOperator)addServerInstanceDialog, 1).setText(appServerPath);
            new JCheckBoxOperator((ContainerOperator)addServerInstanceDialog, 1).changeSelection(false);
            new JButtonOperator((ContainerOperator)addServerInstanceDialog, finishButtonCaption).push();
        }
    }

    private static Node performTomcatServerAction(String action) {
        Node asNode = CommonUtilities.getTomcatServerNode();
        asNode.select();
        new EventTool().waitNoEvent(10000L);
        String serverIDEName = asNode.getText();
        CommonUtilities.log("ServerNode name = " + serverIDEName);
        JPopupMenuOperator popup = asNode.callPopup();
        if (popup == null) {
            throw new Error("Cannot get context menu for Tomcat server node ");
        }
        boolean startEnabled = popup.showMenuItem(action).isEnabled();
        if (startEnabled) {
            popup.pushMenuNoBlock(action);
        }
        return asNode;
    }

    public static void waitScanFinished() {
        try {
            new QueueTool().waitEmpty();
        }
        catch (TimeoutExpiredException tee) {
            CommonUtilities.getLog().println("The following exception is ignored");
            tee.printStackTrace(CommonUtilities.getLog());
        }
    }

    public static void initLog(PerformanceTestCase testCase) {
        test = testCase;
    }

    public static void closeLog() {
        test = null;
    }

    private static void log(String logMessage) {
        System.out.println("Utilities::" + logMessage);
        if (test != null) {
            test.log("Utilities::" + logMessage);
        }
    }

    private static PrintStream getLog() {
        if (test != null) {
            return test.getLog();
        }
        return System.out;
    }

    public static void killRunOnProject(String project) {
        CommonUtilities.killProcessOnProject(project, "run");
    }

    public static void killDebugOnProject(String project) {
        CommonUtilities.killProcessOnProject(project, "debug");
    }

    private static void killProcessOnProject(String project, String process) {
        RuntimeTabOperator runtime = RuntimeTabOperator.invoke();
        Node node = new Node(runtime.getRootNode(), "Processes|" + project + " (" + process + ")");
        node.select();
        node.performPopupAction("Terminate Process");
    }

    public static void xmlTestResults(String path, String suite, String name, String classname, String sname, String unit, String pass, long threshold, long[] results, int repeat) {
        int i;
        int i2;
        PrintStream out = System.out;
        System.out.println();
        System.out.println("#####  Results for " + name + "   #####");
        System.out.print("#####        [");
        for (i2 = 1; i2 <= repeat; ++i2) {
            System.out.print(results[i2] + "ms, ");
        }
        System.out.println("]");
        for (i2 = 1; i2 <= name.length() + 27; ++i2) {
            System.out.print("#");
        }
        System.out.println();
        System.out.println();
        path = System.getProperty("nbjunit.workdir");
        File resGlobal = new File(path + File.separator + "allPerformance.xml");
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!resGlobal.exists()) {
            try {
                resGlobal.createNewFile();
                out = new PrintStream(new FileOutputStream(resGlobal));
                out.print("<TestResults>\n");
                out.print("</TestResults>");
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            allPerfDoc = db.parse(resGlobal);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        testResultsTag = allPerfDoc.getDocumentElement();
        String buildNumber = System.getProperty("org.netbeans.performance.buildnumber");
        if (buildNumber != null) {
            testResultsTag.setAttribute("buildnumber", buildNumber);
        }
        testTag = null;
        for (i = 0; i < allPerfDoc.getElementsByTagName("Test").getLength(); ++i) {
            NamedNodeMap attributes = allPerfDoc.getElementsByTagName("Test").item(i).getAttributes();
            String nameFromDoc = attributes.getNamedItem("name").toString();
            String classnameFromDoc = attributes.getNamedItem("classname").toString();
            if (!("name=\"" + name + "\"").equalsIgnoreCase(nameFromDoc) || !("classname=\"" + classname + "\"").equalsIgnoreCase(classnameFromDoc)) continue;
            testTag = (Element)allPerfDoc.getElementsByTagName("Test").item(i);
            break;
        }
        if (testTag != null) {
            for (i = 1; i <= repeat; ++i) {
                perfDataTag = allPerfDoc.createElement("PerformanceData");
                if (i == 1) {
                    perfDataTag.setAttribute("runOrder", "1");
                } else {
                    perfDataTag.setAttribute("runOrder", "2");
                }
                perfDataTag.setAttribute("value", new Long(results[i]).toString());
                testTag.appendChild(perfDataTag);
            }
        } else {
            testTag = allPerfDoc.createElement("Test");
            testTag.setAttribute("name", name);
            testTag.setAttribute("unit", unit);
            testTag.setAttribute("results", pass);
            testTag.setAttribute("threshold", new Long(threshold).toString());
            testTag.setAttribute("classname", classname);
            for (i = 1; i <= repeat; ++i) {
                perfDataTag = allPerfDoc.createElement("PerformanceData");
                if (i == 1) {
                    perfDataTag.setAttribute("runOrder", "1");
                } else {
                    perfDataTag.setAttribute("runOrder", "2");
                }
                perfDataTag.setAttribute("value", new Long(results[i]).toString());
                testTag.appendChild(perfDataTag);
            }
        }
        testSuiteTag = null;
        if (suite != null) {
            for (i = 0; i < allPerfDoc.getElementsByTagName("Suite").getLength(); ++i) {
                org.w3c.dom.Node ni;
                NamedNodeMap attrs;
                org.w3c.dom.Node item;
                NodeList elem = allPerfDoc.getElementsByTagName("Suite");
                if (elem == null || (item = elem.item(i)) == null || (attrs = item.getAttributes()) == null || (ni = attrs.getNamedItem("suitename")) == null || !suite.equalsIgnoreCase(ni.getNodeValue())) continue;
                testSuiteTag = (Element)item;
                break;
            }
        }
        if (testSuiteTag == null) {
            testSuiteTag = allPerfDoc.createElement("Suite");
            testSuiteTag.setAttribute("name", sname);
            testSuiteTag.setAttribute("suitename", suite);
            testSuiteTag.appendChild(testTag);
        } else {
            testSuiteTag.appendChild(testTag);
        }
        testResultsTag.appendChild(testSuiteTag);
        try {
            out = new PrintStream(new FileOutputStream(resGlobal));
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        Transformer tr = null;
        try {
            tr = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            // empty catch block
        }
        tr.setOutputProperty("indent", "no");
        tr.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource docSrc = new DOMSource(allPerfDoc);
        StreamResult result = new StreamResult(out);
        try {
            tr.transform(docSrc, result);
        }
        catch (TransformerException ex) {
            // empty catch block
        }
        out.close();
    }

    public static void processUnitTestsResults(String className, NbPerformanceTest.PerformanceData pd) {
        CommonUtilities.processUnitTestsResults(className, className, pd);
    }

    public static void processUnitTestsResults(String className, String suiteName, NbPerformanceTest.PerformanceData pd) {
        long[] result = new long[2];
        result[1] = pd.value;
        CommonUtilities.xmlTestResults(System.getProperty("nbjunit.workdir"), "Unit Tests Suite", pd.name, className, suiteName, pd.unit, "passed", 120000L, result, 1);
    }

    public static void maximizeWholeNetbeansWindow() {
        MainWindowOperator.getDefault().maximize();
    }

    public static void setSpellcheckerEnabled(boolean enabled) {
        FileObject root = FileUtil.getConfigFile((String)"Spellcheckers");
        if (root != null) {
            FileObject[] children;
            for (FileObject fileObject : children = root.getChildren()) {
                try {
                    fileObject.setAttribute("Hidden", (Object)(!enabled ? 1 : 0));
                }
                catch (IOException ex) {
                    throw new JemmyException("Error while disabling spellchecker.", (Throwable)ex);
                }
            }
        }
    }

    static {
        testSuiteTag = null;
        String workDir = System.getProperty("nbjunit.workdir");
        String altPath = System.getProperty("nb_perf_alt_path");
        if (workDir != null) {
            projectsDir = altPath != null ? altPath + File.separator : workDir + File.separator;
            try {
                projectsDir = new File(projectsDir + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "nbextra" + File.separator + "data").getCanonicalPath() + File.separator;
            }
            catch (IOException ex) {
                System.err.println("Exception: " + ex);
            }
            tempDir = workDir + File.separator;
            try {
                File dir = new File(tempDir + File.separator + "tmpdir");
                tempDir = dir.getCanonicalPath() + File.separator;
                dir.mkdirs();
            }
            catch (IOException ex) {
                System.err.println("Exception: " + ex);
            }
        }
    }
}

