/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.IOException;
import java.net.URI;
import javax.lang.model.element.TypeElement;
import javax.sql.DataSource;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceSupport;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.clientproject.AppClientProvider;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JarContainerImpl
implements EnterpriseReferenceContainer {
    private Project webProject;
    private AntProjectHelper antHelper;
    private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";
    private AppClient webApp;

    public JarContainerImpl(Project p, ReferenceHelper helper, AntProjectHelper antHelper) {
        this.webProject = p;
        this.antHelper = antHelper;
    }

    public void setServiceLocatorName(String serviceLocator) throws IOException {
        EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
        ep.setProperty(SERVICE_LOCATOR_PROPERTY, serviceLocator);
        this.antHelper.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject(this.webProject);
    }

    public String addResourceRef(ResourceReference ref, FileObject referencingFile, String referencingClass) throws IOException {
        String resourceRefName = ref.getResRefName();
        AppClient ac = this.getAppClient();
        if (DataSource.class.getName().equals(ref.getResType())) {
            ResourceRef[] refs = ac.getResourceRef();
            for (int i = 0; i < refs.length; ++i) {
                boolean canCompareDefDesc;
                String newDefaultDescription = ref.getDefaultDescription();
                String existingDefaultDescription = refs[i].getDefaultDescription();
                boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                if (!DataSource.class.getName().equals(refs[i].getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(refs[i].getResRefName())) continue;
                return refs[i].getResRefName();
            }
        }
        if (!JarContainerImpl.isResourceRefUsed(ac, ref)) {
            resourceRefName = this.getUniqueName(ac, "ResourceRef", "ResRefName", ref.getResRefName());
            ResourceRef resourceRef = ac.newResourceRef();
            EnterpriseReferenceSupport.populate((ResourceReference)ref, (String)resourceRefName, (ResourceRef)resourceRef);
            this.getAppClient().addResourceRef(resourceRef);
            this.writeDD(referencingFile, referencingClass);
        }
        return resourceRefName;
    }

    public String addEjbLocalReference(EjbReference localRef, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencedClassName) throws IOException {
        throw new UnsupportedOperationException("Local references are not supported in App Client module.");
    }

    public String addEjbReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referenceClassName) throws IOException {
        return this.addReference(ref, refType, ejbRefName, referencingFile, referenceClassName);
    }

    public String addDestinationRef(MessageDestinationReference ref, FileObject referencingFile, String referencingClass) throws IOException {
        AppClient ac = this.getAppClient();
        String refName = this.getUniqueName(ac, "MessageDestinationRef", "MessageDestinationRefName", ref.getMessageDestinationRefName());
        try {
            MessageDestinationRef messageDestinationRef = ac.newMessageDestinationRef();
            EnterpriseReferenceSupport.populate((MessageDestinationReference)ref, (String)refName, (MessageDestinationRef)messageDestinationRef);
            ac.addMessageDestinationRef(messageDestinationRef);
            this.writeDD(referencingFile, referencingClass);
        }
        catch (VersionNotSupportedException ex) {
            // empty catch block
        }
        return refName;
    }

    public String getServiceLocatorName() {
        EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
        return ep.getProperty(SERVICE_LOCATOR_PROPERTY);
    }

    private AppClient getAppClient() throws IOException {
        if (this.webApp == null) {
            AppClientProvider jp = (AppClientProvider)this.webProject.getLookup().lookup(AppClientProvider.class);
            FileObject fo = jp.getDeploymentDescriptor();
            this.webApp = DDProvider.getDefault().getDDRoot(fo);
        }
        return this.webApp;
    }

    private String getUniqueName(AppClient wa, String beanName, String property, String originalValue) {
        String proposedValue = originalValue;
        int index = 1;
        while (wa.findBeanByName(beanName, property, proposedValue) != null) {
            proposedValue = originalValue + Integer.toString(index++);
        }
        return proposedValue;
    }

    private void writeDD(FileObject referencingFile, final String referencingClassName) throws IOException {
        final AppClientProvider jp = (AppClientProvider)this.webProject.getLookup().lookup(AppClientProvider.class);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)referencingFile);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws Exception {
                TypeElement typeElement = controller.getElements().getTypeElement(referencingClassName);
                if (JarContainerImpl.isDescriptorMandatory(jp.getJ2eeProfile()) || !InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)typeElement)) {
                    FileObject fo = jp.getDeploymentDescriptor();
                    JarContainerImpl.this.getAppClient().write(fo);
                }
            }
        }, true);
    }

    private String addReference(EjbReference ejbReference, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        String refName = ejbRefName;
        AppClient webApp = this.getAppClient();
        CommonDDBean bean = this.getAppClient().findBeanByName("EjbRef", "EjbRefName", ejbRefName);
        if (bean != null) {
            if (bean.getValue("Remote").equals(ejbReference.getRemote())) {
                return ejbRefName;
            }
            refName = this.getUniqueName(this.getAppClient(), "EjbRef", "EjbRefName", ejbRefName);
        }
        try {
            EjbRef newRef = (EjbRef)webApp.createBean("EjbRef");
            newRef.setEjbRefName(refName);
            newRef.setEjbRefType(ejbReference.getEjbRefType());
            newRef.setHome(ejbReference.getRemoteHome());
            newRef.setRemote(ejbReference.getRemote());
            this.getAppClient().addEjbRef(newRef);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            AntArtifact target = JarContainerImpl.getAntArtifact(ejbReference, refType);
            ProjectClassPathModifier.addAntArtifacts((AntArtifact[])new AntArtifact[]{target}, (URI[])new URI[]{target.getArtifactLocations()[0].normalize()}, (FileObject)referencingFile, (String)"classpath/compile");
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.writeDD(referencingFile, referencingClass);
        return refName;
    }

    private static AntArtifact getAntArtifact(EjbReference ejbReference, EjbReference.EjbRefIType refType) throws IOException {
        FileObject ejbReferenceEjbClassFO = SourceUtils.getFileObject((String)ejbReference.getComponentName(refType), (ClasspathInfo)ejbReference.getClasspathInfo());
        assert (ejbReferenceEjbClassFO != null) : "Reference FileObject not found: " + ejbReference.getComponentName(refType);
        Project otherPrj = FileOwnerQuery.getOwner((FileObject)ejbReferenceEjbClassFO);
        Project project = FileOwnerQuery.getOwner((FileObject)ejbReferenceEjbClassFO);
        AntArtifact[] antArtifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        boolean hasArtifact = antArtifacts != null && antArtifacts.length > 0;
        return hasArtifact ? antArtifacts[0] : null;
    }

    private static boolean isDescriptorMandatory(Profile j2eeVersion) {
        return Profile.J2EE_13.equals(j2eeVersion) || Profile.J2EE_14.equals(j2eeVersion);
    }

    private static boolean isResourceRefUsed(AppClient ac, ResourceReference resRef) {
        String resRefName = resRef.getResRefName();
        String resRefType = resRef.getResType();
        for (ResourceRef existingRef : ac.getResourceRef()) {
            if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
            return true;
        }
        return false;
    }
}

