/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.classpath.ClassPathSupportCallbackImpl;
import org.netbeans.modules.j2ee.clientproject.ui.AppClientLogicalViewProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.modules.javaee.project.api.ant.ui.logicalview.ExtraLibrariesNode;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class LibrariesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        AppClientProject project = (AppClientProject)p.getLookup().lookup(AppClientProject.class);
        assert (project != null);
        return new LibrariesNodeList(project);
    }

    private static class LibrariesNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String LIBRARIES = "Libs";
        private static final String TEST_LIBRARIES = "TestLibs";
        private final SourceRoots testSources;
        private final AppClientProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyEvaluator evaluator;
        private final UpdateHelper helper;
        private final ReferenceHelper resolver;
        private final ClassPathSupport cs;

        LibrariesNodeList(AppClientProject proj) {
            this.project = proj;
            this.testSources = this.project.getTestSourceRoots();
            AppClientLogicalViewProvider logView = (AppClientLogicalViewProvider)((Object)this.project.getLookup().lookup(AppClientLogicalViewProvider.class));
            assert (logView != null);
            this.evaluator = this.project.evaluator();
            this.helper = this.project.getUpdateHelper();
            this.resolver = this.project.getReferenceHelper();
            this.cs = new ClassPathSupport(this.evaluator, this.resolver, this.helper.getAntProjectHelper(), this.helper, (ClassPathSupport.Callback)new ClassPathSupportCallbackImpl(this.helper.getAntProjectHelper()));
        }

        public List<String> keys() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(LIBRARIES);
            URL[] testRoots = this.testSources.getRootURLs();
            boolean addTestSources = false;
            for (int i = 0; i < testRoots.length; ++i) {
                File f = new File(URI.create(testRoots[i].toExternalForm()));
                if (!f.exists()) continue;
                addTestSources = true;
                break;
            }
            if (addTestSources) {
                result.add(TEST_LIBRARIES);
            }
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(String key) {
            if (key == LIBRARIES) {
                return new LibrariesNode(NbBundle.getMessage(LibrariesNodeFactory.class, (String)"CTL_LibrariesNode"), (Project)this.project, this.evaluator, this.helper, this.resolver, "run.classpath", new String[]{"build.classes.dir"}, "platform.active", new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.resolver, (SourceRoots)this.project.getSourceRoots(), null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getSourceRoots()), null, ProjectUISupport.createPreselectPropertiesAction((Project)this.project, (String)"Libraries", (String)"COMPILE")}, "included-library", this.cs, (LibrariesNode.Callback)new ExtraLibrariesNode((Project)this.project, this.evaluator, "j2ee.server.instance", this.cs));
            }
            if (key == TEST_LIBRARIES) {
                return new LibrariesNode(NbBundle.getMessage(LibrariesNodeFactory.class, (String)"CTL_TestLibrariesNode"), (Project)this.project, this.evaluator, this.helper, this.resolver, "run.test.classpath", new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}, null, new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getTestSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.resolver, (SourceRoots)this.project.getTestSourceRoots(), null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getTestSourceRoots()), null, ProjectUISupport.createPreselectPropertiesAction((Project)this.project, (String)"Libraries", (String)"COMPILE_TESTS")}, null, this.cs, null);
            }
            assert (false) : "No node for key: " + key;
            return null;
        }

        public void addNotify() {
            this.testSources.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.testSources.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LibrariesNodeList.this.changeSupport.fireChange();
                }
            });
        }
    }
}

