/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.TreeTableOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.OptionsViewAction;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.nodes.Node;

public class OptionsOperator
extends NbDialogOperator {
    public static final int USER_LEVEL = 2;
    public static final int DEFAULT_LEVEL = 3;
    private static final Action invokeAction = new OptionsViewAction();
    private static final long BEFORE_EDITING_TIMEOUT = 2000L;
    private static int DEFINE_HERE = 0;
    private Component sourceInternal;
    private static final ComponentChooser optionsSubchooser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionsOperator() {
        super(OptionsOperator.waitJDialog((ComponentChooser)optionsSubchooser));
        String loadingLabel = Bundle.getString("org.netbeans.modules.options.Bundle", "CTL_Loading_Options");
        long waitTimeout = this.getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout");
        try {
            this.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 5000L);
            new JLabelOperator((ContainerOperator)this, loadingLabel).waitComponentShowing(false);
        }
        catch (TimeoutExpiredException e) {
        }
        finally {
            this.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", waitTimeout);
        }
    }

    public static OptionsOperator invoke() {
        invokeAction.perform();
        return new OptionsOperator();
    }

    public TreeTableOperator treeTable() {
        return new TreeTableOperator((ContainerOperator)this);
    }

    public int selectOption(String optionPath) {
        TreePath path = this.treeTable().tree().findPath(optionPath, "|");
        if (!this.treeTable().tree().isPathSelected(path)) {
            this.treeTable().tree().selectPath(path);
        }
        int result = this.treeTable().tree().getRowForPath(path);
        this.treeTable().scrollToCell(result, 0);
        new EventTool().waitNoEvent(500L);
        return result;
    }

    public PropertySheetOperator getPropertySheet(String optionPath) {
        this.selectOption(optionPath);
        final String nodeName = this.treeTable().tree().getSelectionPath().getLastPathComponent().toString();
        try {
            return (PropertySheetOperator)((Object)new Waiter(new Waitable(){

                public Object actionProduced(Object optionsOper) {
                    PropertySheetOperator pso = new PropertySheetOperator((ContainerOperator)((OptionsOperator)((Object)optionsOper)));
                    return pso.getDescriptionHeader().equals(nodeName) ? pso : null;
                }

                public String getDescription() {
                    return "Wait Property sheet for \"" + nodeName + "\" is showing.";
                }
            }).waitAction((Object)this));
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    public void showLevels() {
        if (this.treeTable().getColumnCount() == 2) {
            this.clickOnSecondHeader();
        }
    }

    public void hideLevels() {
        if (this.treeTable().getColumnCount() > 2) {
            this.clickOnSecondHeader();
        }
    }

    public void setLevel(String optionPath, final int level) {
        this.showLevels();
        int curLevel = this.getLevel(optionPath);
        this.getOutput().printLine("Setting " + level + " level for \"" + optionPath + "\" option. \nCurrent level: " + curLevel);
        final int row = this.selectOption(optionPath);
        if (level > curLevel) {
            this.produceNoBlocking(new Operator.NoBlockingAction("Setting property definition level"){

                public Object doAction(Object param) {
                    OptionsOperator.this.setLevel(row, level);
                    return null;
                }
            });
            JDialogOperator question = new JDialogOperator(Bundle.getString("org.openide.Bundle", "NTF_QuestionTitle"));
            new JButtonOperator((ContainerOperator)question, Bundle.getString("org.openide.Bundle", "CTL_YES")).push();
        } else if (level < curLevel) {
            this.setLevel(row, level);
        }
    }

    public int getLevel(String optionPath) {
        int row = this.selectOption(optionPath);
        if (this.getValue(row, 2) == DEFINE_HERE) {
            return 2;
        }
        if (this.getValue(row, 3) == DEFINE_HERE) {
            return 3;
        }
        return -1;
    }

    public void setUserLevel(String optionPath) {
        this.setLevel(optionPath, 2);
    }

    public void setDefaultLevel(String optionPath) {
        this.setLevel(optionPath, 3);
    }

    protected void setLevel(int row, int level) {
        if (level == 2) {
            this.defineHere(row, level);
        } else if (level == 3) {
            this.revertLevel(row, level);
        }
    }

    protected int getValue(int row, int column) {
        try {
            Node.Property property = (Node.Property)this.treeTable().getValueAt(row, column);
            return (Integer)property.getValue();
        }
        catch (IllegalAccessException e) {
            throw new JemmyException("Can not access value!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JemmyException("Can not access value!", (Throwable)e);
        }
    }

    protected void revertLevel(int row, int colIndex) {
        this.editLevel(row, colIndex, Bundle.getString("org.netbeans.modules.options.classic.Bundle", "LBL_action_revert"));
    }

    protected void defineHere(int row, int colIndex) {
        this.editLevel(row, colIndex, Bundle.getString("org.netbeans.modules.options.classic.Bundle", "LBL_action_define"));
    }

    protected void editLevel(int rowIndex, int colIndex, String value) {
        this.treeTable().clickOnCell(rowIndex, colIndex);
        JComboBoxOperator combo = new JComboBoxOperator((ContainerOperator)this.treeTable());
        this.getTimeouts().sleep("OptionsOperator.BeforeEditingTimeout");
        combo.selectItem(value);
    }

    protected void clickOnSecondHeader() {
        JTableHeader header = this.treeTable().getTableHeader();
        Rectangle rect = header.getHeaderRect(1);
        new ComponentOperator((Component)header).clickMouse(rect.x + rect.width / 2, rect.y + rect.height / 2, 1);
    }

    public Component getSource() {
        if (this.sourceInternal == null) {
            this.sourceInternal = super.getSource();
        }
        return this.sourceInternal;
    }

    public void selectCategory(final String name) {
        new EventTool().waitNoEvent(300L);
        final Operator.StringComparator comparator = this.getComparator();
        new JLabelOperator((ContainerOperator)this, new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                if ((comp.getClass().getName().equals("org.netbeans.modules.options.OptionsPanel$CategoryButton") || comp.getClass().getName().equals("org.netbeans.modules.options.OptionsPanel$NimbusCategoryButton")) && ((JLabel)comp).getText() != null) {
                    return comparator.equals(((JLabel)comp).getText(), name);
                }
                return false;
            }

            public String getDescription() {
                return "OptionsPanel$CategoryButton with text " + name;
            }
        }).clickMouse();
    }

    public void selectGeneral() {
        Bundle.getStringTrimmed("org.netbeans.modules.options.advanced.Bundle", "CTL_Advanced_Options");
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.core.ui.options.general.Bundle", "CTL_General_Options"));
    }

    public void selectEditor() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.editor.Bundle", "CTL_Editor"));
    }

    public void selectJava() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.java.Bundle", "OpenIDE-Module-Display-Category"));
    }

    public void selectFontAndColors() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.colors.Bundle", "CTL_Font_And_Color_Options"));
    }

    public void selectKeymap() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.keymap.Bundle", "CTL_Keymap_Options"));
    }

    public void selectMiscellaneous() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.advanced.Bundle", "CTL_Advanced_Options"));
    }

    public void verify() {
        this.btClose();
        this.btHelp();
        this.treeTable().verify();
    }

    static {
        Timeouts.initDefault((String)"OptionsOperator.BeforeEditingTimeout", (long)2000L);
        optionsSubchooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return null != new ComponentSearcher((Container)comp).findComponent(new ComponentChooser(){

                    public boolean checkComponent(Component comp) {
                        return comp.getClass().getName().endsWith("OptionsPanel");
                    }

                    public String getDescription() {
                        return "org.netbeans.modules.options.OptionsPanel";
                    }
                });
            }

            public String getDescription() {
                return "Options";
            }
        };
    }
}

