/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferences;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferencesValidator;
import org.netbeans.modules.javascript.jstestdriver.ui.customizer.Bundle;
import org.netbeans.modules.javascript.jstestdriver.util.JsTestDriverUtils;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class CustomizerJsTestDriver
extends JPanel {
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile String config;
    private ValidationResult validationResult;
    private JButton configBrowseButton;
    private JLabel configLabel;
    private JButton configSearchButton;
    private JTextField configTextField;

    public CustomizerJsTestDriver(Project project) {
        assert (EventQueue.isDispatchThread());
        assert (project != null);
        this.project = project;
        this.initComponents();
        this.init();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getConfig() {
        return this.config;
    }

    public String getWarningMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator i$ = this.validationResult.getWarnings().iterator();
        if (i$.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)i$.next();
            return message.getMessage();
        }
        return null;
    }

    public String getErrorMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator i$ = this.validationResult.getErrors().iterator();
        if (i$.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)i$.next();
            return message.getMessage();
        }
        return null;
    }

    private void init() {
        assert (EventQueue.isDispatchThread());
        this.configTextField.setText(JsTestDriverPreferences.getConfig(this.project));
        this.addListeners();
        this.validateData();
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.configTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        this.config = this.configTextField.getText();
        this.validationResult = new JsTestDriverPreferencesValidator().validateConfig(this.config).getResult();
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.configLabel = new JLabel();
        this.configTextField = new JTextField();
        this.configBrowseButton = new JButton();
        this.configSearchButton = new JButton();
        this.configLabel.setLabelFor(this.configTextField);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerJsTestDriver.class, (String)"CustomizerJsTestDriver.configLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configBrowseButton, (String)NbBundle.getMessage(CustomizerJsTestDriver.class, (String)"CustomizerJsTestDriver.configBrowseButton.text"));
        this.configBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJsTestDriver.this.configBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configSearchButton, (String)NbBundle.getMessage(CustomizerJsTestDriver.class, (String)"CustomizerJsTestDriver.configSearchButton.text"));
        this.configSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJsTestDriver.this.configSearchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.configLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configSearchButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configTextField, -2, -1, -2).addComponent(this.configBrowseButton).addComponent(this.configSearchButton)));
    }

    private void configBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(CustomizerJsTestDriver.class).setTitle(Bundle.CustomizerJsTestDriver_chooser_config()).setFilesOnly(true).setDefaultWorkingDirectory(JsTestDriverUtils.getJsTestDriverConfigDir(this.project)).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.configTextField.setText(file.getAbsolutePath());
        }
    }

    private void configSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File configFile = JsTestDriverUtils.findJsTestDriverConfig(JsTestDriverUtils.getJsTestDriverConfigDir(this.project));
        if (configFile != null) {
            this.configTextField.setText(configFile.getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.CustomizerJsTestDriver_config_none());
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            CustomizerJsTestDriver.this.validateData();
        }
    }
}

