/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.DeletableInstanceProperties;
import org.netbeans.modules.j2ee.deployment.impl.LazyDeploymentManager;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DefaultInstancePropertiesImpl
extends DeletableInstanceProperties
implements InstanceListener {
    private final String url;
    private FileObject fo;

    public DefaultInstancePropertiesImpl(String url) {
        this.url = url;
    }

    @Override
    public void instanceRemoved(String instance) {
        if (instance != null && this.url.equals(instance)) {
            this.fo = null;
        }
    }

    @Override
    public void instanceAdded(String instance) {
    }

    public void changeDefaultInstance(String oldInstance, String newInstance) {
    }

    @Override
    public String getProperty(String propname) throws IllegalStateException {
        String propString;
        Object propValue = this.getFileObject().getAttribute(propname);
        String string = propString = propValue == null ? null : propValue.toString();
        if ("password".equals(propname) && propValue == null) {
            propString = ServerRegistry.readPassword(this.url);
        }
        return propString;
    }

    @Override
    public Enumeration propertyNames() throws IllegalStateException {
        return this.getFileObject().getAttributes();
    }

    @Override
    public void setProperty(String propname, String value) throws IllegalStateException {
        try {
            String oldValue = this.getProperty(propname);
            if ("password".equals(propname)) {
                ServerRegistry.savePassword(this.url, value, NbBundle.getMessage(DefaultInstancePropertiesImpl.class, (String)"MSG_KeyringDefaultDisplayName"));
                this.getFileObject().setAttribute(propname, null);
            } else {
                this.getFileObject().setAttribute(propname, (Object)value);
            }
            this.firePropertyChange(new PropertyChangeEvent(this, propname, oldValue, value));
        }
        catch (IOException ioe) {
            String message = NbBundle.getMessage(DefaultInstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url);
            throw new IllegalStateException(Exceptions.attachLocalizedMessage((Throwable)ioe, (String)message));
        }
    }

    @Override
    public void setProperties(Properties props) throws IllegalStateException {
        this.getFileObject();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            this.setProperty(propName, propValue);
        }
    }

    @Override
    public DeploymentManager getDeploymentManager() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            return new LazyDeploymentManager(new LazyDeploymentManager.DeploymentManagerProvider(){

                @Override
                public DeploymentManager getDeploymentManager() {
                    return LazyDeploymentManager.getDeploymentManager(DefaultInstancePropertiesImpl.this.url);
                }
            });
        }
        return LazyDeploymentManager.getDeploymentManager(this.url);
    }

    @Override
    public void refreshServerInstance() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        if (inst != null) {
            inst.refresh();
        }
    }

    @Override
    boolean isDeleted() {
        if (this.fo != null) {
            return false;
        }
        if (ServerRegistry.getInstance().getServerInstance(this.url) == null) {
            return true;
        }
        return ServerRegistry.getInstanceFileObject(this.url) == null;
    }

    private FileObject getFileObject() {
        if (this.fo == null) {
            ServerInstance instance = ServerRegistry.getInstance().getServerInstance(this.url);
            if (instance == null) {
                throw new IllegalStateException(NbBundle.getMessage(DefaultInstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
            this.fo = ServerRegistry.getInstanceFileObject(this.url);
            if (this.fo == null) {
                throw new IllegalStateException(NbBundle.getMessage(DefaultInstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
        }
        return this.fo;
    }
}

