/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.directory_iterator;
import org.clang.tools.services.impl.SharedMemoryBufferCache;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;

public class DelegatingFileSystem
extends FileSystem {
    private static final boolean TRACE_TIME = Boolean.getBoolean("clank.fs.trace.time");
    private static final AtomicLong totalReadTime = TRACE_TIME ? new AtomicLong() : null;
    private static final AtomicLong totalReadCount = TRACE_TIME ? new AtomicLong() : null;
    private static final AtomicLong totalStatTime = TRACE_TIME ? new AtomicLong() : null;
    private static final AtomicLong totalStatCount = TRACE_TIME ? new AtomicLong() : null;
    private final FileSystem delegateFS;
    private final IntrusiveRefCntPtr<FileSystem> delegatePtr;
    private final SharedMemoryBufferCache sharedMemoryBufferCache;

    public static IntrusiveRefCntPtr<FileSystem> create(SharedMemoryBufferCache sharedMemoryBufferCache, IntrusiveRefCntPtr<FileSystem> toDelegate) {
        return new IntrusiveRefCntPtr((Object)new DelegatingFileSystem(sharedMemoryBufferCache, toDelegate));
    }

    private DelegatingFileSystem(SharedMemoryBufferCache sharedMemoryBufferCache, IntrusiveRefCntPtr<FileSystem> toDelegate) {
        assert (toDelegate != null);
        this.sharedMemoryBufferCache = sharedMemoryBufferCache;
        this.delegatePtr = toDelegate;
        this.delegateFS = (FileSystem)toDelegate.get();
    }

    private static void printStatistics(std.string Name, long readTime) {
        assert (TRACE_TIME);
        StringBuilder sb = new StringBuilder();
        sb.append("Reading ").append(Name).append(" took ").append(readTime).append(" ms").append("\nTotal reads: count=").append(totalReadCount.get()).append(" time=").append(totalReadTime.get()).append(" ms").append("\nTotal stats: count=").append(totalStatCount.get()).append(" time=").append(totalStatTime.get()).append(" ms").append("\n");
        llvm.errs().$out((CharSequence)sb.toString());
    }

    public void $destroy() {
        super.$destroy();
        this.delegatePtr.$destroy();
    }

    public ErrorOr<Status> status(Twine Path2) {
        long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
        ErrorOr stat = this.delegateFS.status(Path2);
        if (TRACE_TIME) {
            totalStatTime.addAndGet(System.currentTimeMillis() - time);
            totalStatCount.incrementAndGet();
        }
        return stat;
    }

    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBufferForFile(Twine Name, long FileSize, boolean RequiresNullTerminator, boolean IsVolatile) {
        ErrorOr out = this.sharedMemoryBufferCache.get(Name);
        if (out == null) {
            out = super.getBufferForFile(Name, FileSize, RequiresNullTerminator, IsVolatile);
            this.sharedMemoryBufferCache.put(Name, (ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>)out);
        }
        return out;
    }

    public ErrorOr<std_ptr.unique_ptr<File>> openFileForRead(Twine Path2) {
        long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
        ErrorOr result = this.delegateFS.openFileForRead(Path2);
        if (result.$boolean()) {
            DelegatingFile delegatingWrapper = new DelegatingFile((File)((std_ptr.unique_ptr)result.get()).get());
            std_ptr.unique_ptr upf = llvm.make_unique((Object)((Object)delegatingWrapper));
            result = new ErrorOr((Object)upf);
        }
        if (TRACE_TIME) {
            totalReadTime.addAndGet(System.currentTimeMillis() - time);
            totalReadCount.incrementAndGet();
        }
        return result;
    }

    public directory_iterator dir_begin(Twine Dir, std_errors.error_code EC) {
        return this.delegateFS.dir_begin(Dir, EC);
    }

    private static void convertMemoryBufferForJava(MemoryBuffer mb) {
        char.ptr bufferStart = mb.getBufferStart();
        if (Native.$is_array_based((char.ptr)bufferStart)) {
            char.ptr bufferEnd = mb.getBufferEnd();
            byte[] array = bufferStart.$array();
            assert (array == bufferEnd.$array());
            int startIdx = bufferStart.$index();
            int endIdx = bufferEnd.$index();
            byte CR = NativePointer.$((char)'\r');
            while (startIdx < endIdx) {
                byte cur;
                if ((cur = array[startIdx++]) >= 0 && cur <= 127 && cur != CR) continue;
                DelegatingFileSystem.convertMemoryBufferForJavaSlow(mb);
                break;
            }
        } else {
            DelegatingFileSystem.convertMemoryBufferForJavaSlow(mb);
        }
    }

    private static void convertMemoryBufferForJavaSlow(MemoryBuffer mb) {
        char.ptr bufferStart = mb.getBufferStart();
        char.ptr bufferEnd = mb.getBufferEnd();
        char.ptr from = (char.ptr)bufferStart.clone();
        char.ptr to = (char.ptr)from.clone();
        boolean prevWasCR = false;
        boolean changed = false;
        while (from.$noteq((Object)bufferEnd)) {
            byte c = from.$star();
            if (c == 13) {
                to.$set((byte)10);
                to.$postInc();
                prevWasCR = true;
                changed = true;
            } else {
                if (c == 10 && prevWasCR) {
                    changed = true;
                } else {
                    if (!changed) {
                        boolean bl = changed = (c & 0x80) != 0;
                    }
                    if (changed) {
                        if ((c & 0x80) == 0) {
                            to.$set(c);
                            to.$postInc();
                        } else if ((c & 0xC0) != 128) {
                            to.$set((byte)32);
                            to.$postInc();
                        }
                    } else {
                        to.$postInc();
                    }
                }
                prevWasCR = false;
            }
            from.$postInc();
        }
        while (to.$noteq((Object)bufferEnd)) {
            to.$set((byte)32);
            to.$postInc();
        }
    }

    private class DelegatingFile
    extends File {
        private final File delegate;

        public DelegatingFile(File delegate) {
            this.delegate = delegate;
        }

        public void $destroy() {
            super.$destroy();
            this.delegate.$destroy();
        }

        public ErrorOr<Status> status() {
            long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
            ErrorOr stat = this.delegate.status();
            if (TRACE_TIME) {
                time = System.currentTimeMillis() - time;
                totalStatCount.incrementAndGet();
                totalStatTime.addAndGet(time);
            }
            return stat;
        }

        public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name) {
            return this.getBuffer(Name, -1L, true, false);
        }

        public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize) {
            return this.getBuffer(Name, FileSize, true, false);
        }

        public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize, boolean RequiresNullTerminator) {
            return this.getBuffer(Name, FileSize, RequiresNullTerminator, false);
        }

        public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize, boolean RequiresNullTerminator, boolean IsVolatile) {
            ErrorOr buf = DelegatingFileSystem.this.sharedMemoryBufferCache.get(Name);
            if (buf == null) {
                long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
                buf = this.delegate.getBuffer(Name, FileSize, RequiresNullTerminator, IsVolatile);
                if (TRACE_TIME) {
                    time = System.currentTimeMillis() - time;
                    totalReadCount.incrementAndGet();
                    totalReadTime.addAndGet(time);
                    DelegatingFileSystem.printStatistics(Name.str(), time);
                }
                if (buf.$boolean()) {
                    MemoryBuffer mb = (MemoryBuffer)((std_ptr.unique_ptr)buf.$arrow()).$arrow();
                    DelegatingFileSystem.convertMemoryBufferForJava(mb);
                }
                DelegatingFileSystem.this.sharedMemoryBufferCache.put(Name, (ErrorOr<std_ptr.unique_ptr<MemoryBuffer>>)buf);
            }
            return buf;
        }

        public std_errors.error_code close() {
            return this.delegate.close();
        }

        public void setName(StringRef Name) {
            this.delegate.setName(Name);
        }

        public String toString() {
            return "{delegate=" + this.delegate + "}";
        }
    }
}

