/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.bower.exec.BowerExecutable;
import org.netbeans.modules.javascript.bower.util.FileUtils;
import org.openide.util.NbPreferences;

public final class BowerOptions {
    private static final String BOWER_PATH = "bower.path";
    private static final String PREFERENCES_PATH = "bower";
    private static final BowerOptions INSTANCE = new BowerOptions();
    private final Preferences preferences = NbPreferences.forModule(BowerOptions.class).node("bower");
    private volatile boolean bowerSearched = false;

    private BowerOptions() {
    }

    public static BowerOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getBower() {
        String path = this.preferences.get(BOWER_PATH, null);
        if (path == null && !this.bowerSearched) {
            this.bowerSearched = true;
            List<String> files = FileUtils.findFileOnUsersPath(BowerExecutable.BOWER_NAME);
            if (!files.isEmpty()) {
                path = files.get(0);
                this.setBower(path);
            }
        }
        return path;
    }

    public void setBower(String bower) {
        this.preferences.put(BOWER_PATH, bower);
    }
}

