/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class J2MESampleProjectGenerator {
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/j2me-embedded-project/1";
    private static final String ANT_BASED_PROJECT_NAMESPACE = "http://www.netbeans.org/ns/project/1";

    private J2MESampleProjectGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createProjectFromTemplate(FileObject template, File projectLocation, String name, String jdkPlatformName, String j2mePlatformName, String j2meDevice, String j2meConfig, String j2meProfile, String optionalApi, String bootclasspath, String platformType) throws IOException {
        assert (template != null && projectLocation != null && name != null);
        FileObject prjLoc = J2MESampleProjectGenerator.createProjectFolder(projectLocation);
        if (template.getExt().endsWith("zip")) {
            block16: {
                J2MESampleProjectGenerator.unzip(template.getInputStream(), prjLoc);
                try {
                    File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
                    Document doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)projXml).toString()), (boolean)false, (boolean)true, null, null);
                    NodeList nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                    if (nlist == null) break block16;
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        Node n = nlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        J2MESampleProjectGenerator.replaceText(e, name);
                    }
                    if (!jdkPlatformName.equals("default_platform")) {
                        Element root = doc.getDocumentElement();
                        Element config = XMLUtil.findElement((Element)root, (String)"configuration", (String)ANT_BASED_PROJECT_NAMESPACE);
                        Element data = XMLUtil.findElement((Element)config, (String)"data", (String)PROJECT_CONFIGURATION_NAMESPACE);
                        Node insertBefore = null;
                        for (Element e : XMLUtil.findSubElements((Element)data)) {
                            String n = e.getNodeName();
                            if ("name".equals(n) || "minimum-ant-version".equals(n)) continue;
                            insertBefore = e;
                            break;
                        }
                        Element explicitPlatformEl = insertBefore.getOwnerDocument().createElementNS(PROJECT_CONFIGURATION_NAMESPACE, "explicit-platform");
                        explicitPlatformEl.setAttribute("explicit-source-supported", "true");
                        data.insertBefore(explicitPlatformEl, insertBefore);
                    }
                    J2MESampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
                    FileObject projectProps = prjLoc.getFileObject("nbproject/project.properties");
                    if (projectProps == null) break block16;
                    FileLock lock = projectProps.lock();
                    try {
                        EditableProperties props = new EditableProperties(false);
                        try (InputStream in = projectProps.getInputStream();){
                            props.load(in);
                        }
                        props.setProperty("platform.active", j2mePlatformName);
                        props.setProperty("platform.sdk", jdkPlatformName);
                        props.setProperty("platform.device", j2meDevice);
                        props.setProperty("platform.configuration", j2meConfig);
                        props.setProperty("platform.profile", j2meProfile);
                        props.setProperty("platform.apis", optionalApi);
                        props.setProperty("platform.bootcp", bootclasspath);
                        props.setProperty("platform.type", platformType);
                        try (OutputStream out = projectProps.getOutputStream(lock);){
                            props.store(out);
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
                catch (IOException | IllegalArgumentException | DOMException | SAXException e) {
                    throw new IOException(e.toString());
                }
            }
            prjLoc.refresh(false);
        }
        return prjLoc;
    }

    private static FileObject createProjectFolder(File projectFolder) throws IOException {
        FileObject projLoc;
        Stack<String> nameStack = new Stack<String>();
        while ((projLoc = FileUtil.toFileObject((File)projectFolder)) == null) {
            nameStack.push(projectFolder.getName());
            projectFolder = projectFolder.getParentFile();
        }
        while (!nameStack.empty()) {
            projLoc = projLoc.createFolder((String)nameStack.pop());
            assert (projLoc != null);
        }
        return projLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(source);){
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                FileLock lock = destFile.lock();
                try {
                    OutputStream out = destFile.getOutputStream(lock);
                    Throwable throwable = null;
                    try {
                        FileUtil.copy((InputStream)zip, (OutputStream)out);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            return;
        }
    }

    private static File createPrivateProperties(FileObject fo) throws IOException {
        String[] nameElements = "nbproject/private/private.properties".split("/");
        for (int i = 0; i < nameElements.length - 1; ++i) {
            FileObject tmp = fo.getFileObject(nameElements[i]);
            if (tmp == null) {
                tmp = fo.createFolder(nameElements[i]);
            }
            fo = tmp;
        }
        fo = fo.createData(nameElements[nameElements.length - 1]);
        return FileUtil.toFile((FileObject)fo);
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try (OutputStream os = xml.getOutputStream(lock);){
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            lock.releaseLock();
        }
    }
}

