/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2me.project.wizard.Bundle;
import org.netbeans.modules.j2me.project.wizard.J2METargetChooserPanelGUI;
import org.netbeans.modules.j2me.project.wizard.NewJ2MEFileWizardIterator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class J2METargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    public static final String MIDLET_NAME = "MidletName";
    public static final String MIDLET_CLASSNAME = "MidletClassName";
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private J2METargetChooserPanelGUI gui;
    private final WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private final Project project;
    private final SourceGroup[] folders;
    private final NewJ2MEFileWizardIterator.Type type;
    private final boolean isValidPackageRequired;

    public J2METargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, NewJ2MEFileWizardIterator.Type type, boolean isValidPackageRequired) {
        this.project = project;
        this.folders = folders;
        this.bottomPanel = bottomPanel;
        this.type = type;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
        this.isValidPackageRequired = isValidPackageRequired;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new J2METargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.type);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return this.bottomPanel != null ? this.bottomPanel.getHelp() : null;
    }

    public boolean isValid() {
        String categories;
        if (this.gui == null) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.type == NewJ2MEFileWizardIterator.Type.PACKAGE) {
            if (this.gui.getTargetName() == null) {
                this.setErrorMessage("INFO_JavaTargetChooser_ProvidePackageName");
                return false;
            }
            if (!J2METargetChooserPanel.isValidPackageName(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            if (!J2METargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidFolder");
                return false;
            }
        } else if (this.type == NewJ2MEFileWizardIterator.Type.PKG_INFO) {
            if (this.gui.getTargetName() == null) {
                this.setErrorMessage("INFO_JavaTargetChooser_ProvideClassName");
                return false;
            }
            assert ("package-info".equals(this.gui.getTargetName()));
            if (!J2METargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            if (!J2METargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidFolder");
                return false;
            }
        } else {
            if (this.gui.getTargetName() == null) {
                this.setErrorMessage("INFO_JavaTargetChooser_ProvideClassName");
                return false;
            }
            if (!J2METargetChooserPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidClass");
                return false;
            }
            if (!J2METargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            if (!J2METargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidFolder");
                return false;
            }
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean returnValue = true;
        FileObject rootFolder = this.gui.getRootFolder();
        SpecificationVersion specVersion = null;
        if (this.type != NewJ2MEFileWizardIterator.Type.PACKAGE) {
            String sl = SourceLevelQuery.getSourceLevel((FileObject)rootFolder);
            specVersion = sl != null ? new SpecificationVersion(sl) : null;
        }
        String errorMessage = J2METargetChooserPanel.canUseFileName(rootFolder, this.gui.getPackageFileName(), this.gui.getTargetName(), template.getExt());
        if (this.gui != null) {
            this.wizard.getNotificationLineSupport().setErrorMessage(errorMessage);
        }
        if (errorMessage != null) {
            returnValue = false;
        }
        if (this.type != NewJ2MEFileWizardIterator.Type.PACKAGE && returnValue && this.gui.getPackageName().length() == 0 && specVersion != null && this.JDK_14.compareTo((Object)specVersion) <= 0) {
            if (this.isValidPackageRequired) {
                this.setInfoMessage("ERR_JavaTargetChooser_CantUseDefaultPackage");
                return false;
            }
            this.setErrorMessage("ERR_JavaTargetChooser_DefaultPackage");
        }
        if ((categories = (String)template.getAttribute("templateCategory")) != null && Arrays.asList(categories.split(",")).contains("jdk5") && specVersion != null && specVersion.compareTo((Object)this.JDK_14) <= 0) {
            this.wizard.getNotificationLineSupport().setErrorMessage(Bundle.ERR_JavaTargetChooser_WrongPlatform());
        }
        if (returnValue && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return returnValue;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }

    public void readSettings(WizardDescriptor wizard) {
        Object substitute;
        this.wizard = wizard;
        if (this.gui != null) {
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)wizard), preselectedFolder);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)wizard);
        }
        if (this.gui != null && (substitute = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            wizard.putProperty("NewFileWizard_Title", substitute);
        }
    }

    public void storeSettings(WizardDescriptor wizard) {
        Object value = wizard.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)wizard);
            }
            Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)this.getTargetFolderFromGUI(wizard));
            Templates.setTargetName((WizardDescriptor)wizard, (String)this.gui.getTargetName());
        }
        wizard.putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(value)) {
            wizard.putProperty(FOLDER_TO_DELETE, null);
        }
        if (this.gui.isMidlet()) {
            wizard.putProperty(MIDLET_NAME, (Object)this.gui.getTargetName());
            StringBuilder sbClassname = new StringBuilder();
            if (this.gui.getPackageName() != null && !this.gui.getPackageName().isEmpty()) {
                sbClassname.append(this.gui.getPackageName()).append(".");
            }
            sbClassname.append(this.gui.getTargetName());
            wizard.putProperty(MIDLET_CLASSNAME, (Object)sbClassname.toString());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void setErrorMessage(String key) {
        if (key == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setErrorMessage(NbBundle.getMessage(J2METargetChooserPanelGUI.class, (String)key));
        }
    }

    private void setInfoMessage(String key) {
        if (key == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setInformationMessage(NbBundle.getMessage(J2METargetChooserPanelGUI.class, (String)key));
        }
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wd) {
        assert (this.gui != null);
        FileObject rootFolder = this.gui.getRootFolder();
        if (!rootFolder.isValid()) {
            return null;
        }
        FileObject folder = null;
        if (this.type != NewJ2MEFileWizardIterator.Type.PACKAGE) {
            String packageFileName = this.gui.getPackageFileName();
            folder = rootFolder.getFileObject(packageFileName);
            if (folder == null) {
                try {
                    FileObject fo;
                    folder = rootFolder;
                    StringTokenizer tk = new StringTokenizer(packageFileName, "/");
                    String name = null;
                    while (tk.hasMoreTokens() && (fo = folder.getFileObject(name = tk.nextToken(), "")) != null) {
                        folder = fo;
                    }
                    folder = folder.createFolder(name);
                    FileObject toDelete = (FileObject)wd.getProperty(FOLDER_TO_DELETE);
                    if (toDelete == null) {
                        wd.putProperty(FOLDER_TO_DELETE, (Object)folder);
                    } else if (!toDelete.equals(folder)) {
                        toDelete.delete();
                        wd.putProperty(FOLDER_TO_DELETE, (Object)folder);
                    }
                    while (tk.hasMoreTokens()) {
                        name = tk.nextToken();
                        folder = folder.createFolder(name);
                    }
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    folder = null;
                }
            }
        } else {
            folder = rootFolder;
        }
        return folder;
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPackage(FileObject root, String path) {
        if (root == null) {
            return false;
        }
        if (path == null) {
            return false;
        }
        StringTokenizer tk = new StringTokenizer(path, ".");
        while (tk.hasMoreTokens()) {
            if ((root = root.getFileObject(tk.nextToken())) == null) {
                return true;
            }
            if (!root.isData()) continue;
            return false;
        }
        return true;
    }

    @NonNull
    static String[] getPackageAndSimpleName(@NonNull String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0) {
            return new String[]{name.substring(0, lastDot), lastDot == name.length() - 1 ? "" : name.substring(lastDot + 1)};
        }
        return new String[]{"", name};
    }

    private static boolean isValidTypeIdentifier(String ident) {
        return ident != null && !"".equals(ident) && Utilities.isJavaIdentifier((String)ident);
    }

    public static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension) {
        File targetPackage;
        StringBuilder sb;
        String newObjectNameToDisplay = newObjectName;
        if (newObjectName != null) {
            newObjectName = newObjectName.replace('.', '/');
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuilder();
            sb.append(newObjectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuilder();
            sb.append(newObjectNameToDisplay);
            sb.append('.');
            sb.append(extension);
            newObjectNameToDisplay = sb.toString();
        }
        String relFileName = folderName + "/" + newObjectName;
        if (targetFolder == null) {
            return NbBundle.getMessage(J2METargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        File file = targetPackage = folderName != null ? new File(FileUtil.toFile((FileObject)targetFolder), folderName) : FileUtil.toFile((FileObject)targetFolder);
        if (targetPackage != null ? targetPackage.exists() && !targetPackage.canWrite() : !targetFolder.canWrite()) {
            return NbBundle.getMessage(J2METargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (J2METargetChooserPanel.existFileName(targetFolder, relFileName)) {
            return NbBundle.getMessage(J2METargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)newObjectNameToDisplay);
        }
        return null;
    }

    private static boolean existFileName(FileObject targetFolder, String relFileName) {
        File fileForTargetFolder = FileUtil.toFile((FileObject)targetFolder);
        return fileForTargetFolder.exists() ? new File(fileForTargetFolder, relFileName).exists() : targetFolder.getFileObject(relFileName) != null;
    }
}

