/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout.javascript;

import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.html.knockout.KOUtils;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.web.common.api.LexerUtils;

public class KnockoutCodeCompletionItem
implements CompletionProposal {
    static final String KNOCKOUT_LABEL = "Knockout";
    private final int anchorOffset;
    private final ElementHandle element;

    public KnockoutCodeCompletionItem(ElementHandle element, int anchorOffset) {
        this.anchorOffset = anchorOffset;
        this.element = element;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        return this.element.getName();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return KNOCKOUT_LABEL;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return 20;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    static class KOComponentOptionConfigItem
    extends KOComponentItem {
        private final ElementHandle element;

        public KOComponentOptionConfigItem(ElementHandle element, CodeCompletionContext ccContext) {
            super(element, ccContext);
            this.element = element;
        }

        @Override
        public String getCustomInsertTemplate() {
            return this.element.getName() + ": { }";
        }
    }

    static class KOComponentOptionItem
    extends KOComponentItem {
        private final ElementHandle element;

        public KOComponentOptionItem(ElementHandle element, CodeCompletionContext ccContext) {
            super(element, ccContext);
            this.element = element;
        }

        @Override
        public String getCustomInsertTemplate() {
            return this.element.getName() + ": ";
        }
    }

    static class KOComponentItem
    extends KnockoutCodeCompletionItem {
        private final ElementHandle element;
        private final CodeCompletionContext context;

        public KOComponentItem(ElementHandle element, CodeCompletionContext ccContext) {
            super(element, ccContext.getCaretOffset());
            this.element = element;
            this.context = ccContext;
        }

        @Override
        public ImageIcon getIcon() {
            return KOUtils.KO_ICON;
        }

        @Override
        public int getAnchorOffset() {
            return this.context.getCaretOffset() - this.context.getPrefix().length();
        }

        @Override
        public String getCustomInsertTemplate() {
            int diff;
            TokenSequence ts;
            String result = this.element.getName();
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.getParserResult().getSnapshot().getSource().getDocument(true));
            if (th != null && (ts = LexerUtils.getTokenSequence((TokenHierarchy)th, (int)this.context.getCaretOffset(), (Language)JsTokenId.javascriptLanguage(), (boolean)false)) != null && ((diff = ts.move(this.context.getCaretOffset())) == 0 && ts.movePrevious() || ts.moveNext())) {
                boolean isInString;
                Token token = ts.token();
                JsTokenId id = (JsTokenId)token.id();
                if (id == JsTokenId.UNKNOWN && ts.movePrevious()) {
                    token = ts.token();
                    id = (JsTokenId)token.id();
                }
                boolean bl = isInString = id == JsTokenId.STRING_BEGIN || id == JsTokenId.STRING;
                if (!isInString) {
                    result = '\'' + result + '\'';
                }
            }
            return result;
        }
    }
}

