/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfo;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;

public class V8BreakpointsActiveService
implements JSBreakpointsInfo {
    private volatile boolean active = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public V8BreakpointsActiveService() {
        SessionActiveListener sal = new SessionActiveListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)sal);
    }

    public boolean isDefault() {
        FileObject mostRecentFile = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (mostRecentFile == null) {
            return false;
        }
        String mimeType = mostRecentFile.getMIMEType();
        return "text/javascript".equals(mimeType);
    }

    public boolean isAnnotatable(FileObject fo) {
        String mimeType = fo.getMIMEType();
        return "text/javascript".equals(mimeType);
    }

    public boolean isTransientURL(URL url) {
        return "js-scripts".equals(url.getProtocol());
    }

    public boolean areBreakpointsActivated() {
        return this.active;
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.pcs.firePropertyChange("breakpointsActive", !active, active);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private class SessionActiveListener
    extends DebuggerManagerAdapter
    implements BreakpointsHandler.BreakpointsActiveListener {
        private BreakpointsHandler bh = this.getCurrentBreakpointsHandler();

        public SessionActiveListener() {
            if (this.bh != null) {
                V8BreakpointsActiveService.this.active = this.bh.areBreakpointsActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("currentSession".equals(propertyName)) {
                BreakpointsHandler newBh = this.getCurrentBreakpointsHandler();
                SessionActiveListener sessionActiveListener = this;
                synchronized (sessionActiveListener) {
                    if (this.bh != null) {
                        this.bh.removeBreakpointsActiveListener(this);
                    }
                    this.bh = newBh;
                }
                if (newBh != null) {
                    V8BreakpointsActiveService.this.setActive(newBh.areBreakpointsActive());
                } else {
                    V8BreakpointsActiveService.this.setActive(true);
                }
            }
        }

        @Override
        public void breakpointsActivated(boolean activated) {
            V8BreakpointsActiveService.this.setActive(activated);
        }

        private BreakpointsHandler getCurrentBreakpointsHandler() {
            Session s = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (s != null) {
                V8Debugger debugger = (V8Debugger)s.lookupFirst(null, V8Debugger.class);
                if (debugger != null) {
                    BreakpointsHandler bh = debugger.getBreakpointsHandler();
                    bh.addBreakpointsActiveListener(this);
                    return bh;
                }
                return null;
            }
            return null;
        }
    }
}

