/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.EventListener;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.javascript2.debug.JSUtils;
import org.netbeans.modules.javascript2.debug.breakpoints.FutureLine;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class JSLineBreakpoint
extends Breakpoint {
    public static final String PROP_URL = "url";
    public static final String PROP_LINE = "line";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_FILE = "fileChanged";
    public static final String PROP_CONDITION = "condition";
    private Line line;
    private boolean isEnabled = true;
    private volatile String condition;
    private final FileRemoveListener myListener = new FileRemoveListener();
    private FileChangeListener myWeakListener;
    private final LineChangesListener lineChangeslistener = new LineChangesListener();
    private PropertyChangeListener lineChangesWeak;

    public JSLineBreakpoint(Line line) {
        this.line = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.dispose();
        Line oldLine = this.line;
        this.line = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
        this.firePropertyChange(PROP_LINE, oldLine, line);
    }

    public void setLine(int lineNumber) {
        Line cline;
        int lastLineNumber;
        if (this.line.getLineNumber() == lineNumber) {
            return;
        }
        LineCookie lineCookie = (LineCookie)this.line.getLookup().lookup(LineCookie.class);
        Line.Set lineSet = lineCookie.getLineSet();
        List lines = lineSet.getLines();
        if (lines.size() > 0 && lineNumber > (lastLineNumber = ((Line)lines.get(lines.size() - 1)).getLineNumber())) {
            lineNumber = lastLineNumber;
        }
        try {
            cline = lineSet.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioobex) {
            cline = lineSet.getCurrent(0);
        }
        this.setLine(cline);
    }

    public int getLineNumber() {
        return this.line.getLineNumber() + 1;
    }

    public FileObject getFileObject() {
        if (this.line instanceof FutureLine) {
            URL url = this.getURL();
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    LineCookie lineCookie = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                    if (lineCookie == null) {
                        return null;
                    }
                    Line l = lineCookie.getLineSet().getCurrent(this.getLineNumber() - 1);
                    this.setLine(l);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return fo;
        }
        return (FileObject)this.line.getLookup().lookup(FileObject.class);
    }

    public URL getURL() {
        if (this.line instanceof FutureLine) {
            return ((FutureLine)this.line).getURL();
        }
        return ((FileObject)this.line.getLookup().lookup(FileObject.class)).toURL();
    }

    public void disable() {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.isEnabled) {
            return;
        }
        this.isEnabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void dispose() {
        super.dispose();
        Line line = this.getLine();
        line.removePropertyChangeListener(this.lineChangesWeak);
        this.lineChangesWeak = null;
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.myWeakListener);
            this.myWeakListener = null;
        }
    }

    public final String getCondition() {
        return this.condition;
    }

    public final void setCondition(String condition) {
        String oldCondition = this.condition;
        if (condition != null && condition.equals(oldCondition) || condition == null && oldCondition == null) {
            return;
        }
        this.condition = condition;
        this.firePropertyChange(PROP_CONDITION, oldCondition, condition);
    }

    public final boolean isConditional() {
        return this.condition != null && !this.condition.isEmpty();
    }

    final void setValid(String message) {
        this.setValidity(Breakpoint.VALIDITY.VALID, message);
    }

    final void setInvalid(String message) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, message);
    }

    final void resetValidity() {
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
    }

    public String toString() {
        return "JSLineBreakpoint{line=" + this.line + ", FileObject = " + this.getFileObject() + ", isEnabled=" + this.isEnabled + ", condition=" + this.condition + '}';
    }

    private class LineChangesListener
    implements PropertyChangeListener {
        private LineChangesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JSLineBreakpoint.PROP_LINE_NUMBER.equals(evt.getPropertyName())) {
                JSLineBreakpoint.this.firePropertyChange(JSLineBreakpoint.PROP_LINE_NUMBER, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private class FileRemoveListener
    extends FileChangeAdapter {
        private FileRemoveListener() {
        }

        public void fileDeleted(FileEvent arg0) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)JSLineBreakpoint.this);
        }

        public void fileRenamed(FileRenameEvent fe) {
            FileObject renamedFo = fe.getFile();
            Line newLine = JSUtils.getLine(renamedFo, JSLineBreakpoint.this.getLine().getLineNumber() + 1);
            if (!newLine.equals(JSLineBreakpoint.this.getLine())) {
                JSLineBreakpoint.this.setLine(newLine);
            } else {
                JSLineBreakpoint.this.firePropertyChange(JSLineBreakpoint.PROP_FILE, fe.getName(), fe.getFile().getName());
            }
        }
    }
}

