/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.conf.Element;
import org.netbeans.modules.html.custom.conf.Tag;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    private static final String CONF_FILE_NAME = "customs.json";
    private static final Map<Project, Configuration> MAP = new WeakHashMap<Project, Configuration>();
    public static final String DESCRIPTION = "description";
    public static final String CONTEXT = "context";
    public static final String DOC = "doc";
    public static final String DOC_URL = "doc_url";
    public static final String REQUIRED = "required";
    public static final String ELEMENTS = "elements";
    public static final String ATTRIBUTES = "attributes";
    public static final String TYPE = "type";
    private final Map<String, Tag> tags = new HashMap<String, Tag>();
    private final Map<String, Attribute> attrs = new HashMap<String, Attribute>();
    public static final Configuration EMPTY = new Configuration();
    private FileObject configFile;
    private FileObject configFileDir;
    private JSONObject root;

    public static Configuration get(@NonNull FileObject file) {
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        return owner == null ? EMPTY : Configuration.get(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Configuration get(@NonNull Project project) {
        Map<Project, Configuration> map = MAP;
        synchronized (map) {
            Configuration conf = MAP.get(project);
            if (conf == null) {
                conf = new Configuration(project);
                MAP.put(project, conf);
            }
            return conf;
        }
    }

    private Configuration() {
    }

    public Configuration(Project project) {
        FileObject nbprojectDir = project.getProjectDirectory().getFileObject("nbproject");
        this.configFileDir = nbprojectDir == null ? project.getProjectDirectory() : nbprojectDir;
        this.configFile = this.configFileDir.getFileObject(CONF_FILE_NAME);
        if (this.configFile != null) {
            this.configFile.addFileChangeListener((FileChangeListener)new ConfigFileChangeListener());
            try {
                this.reload();
            }
            catch (IOException ex) {
                this.handleIOEFromReload(ex);
            }
        }
    }

    private void initConfigFile() throws IOException {
        if (this.configFile == null) {
            this.configFile = this.configFileDir.createData(CONF_FILE_NAME);
            this.configFile.addFileChangeListener((FileChangeListener)new ConfigFileChangeListener());
        }
    }

    public FileObject getProjectsConfigurationFile() {
        return this.configFile;
    }

    private void handleIOEFromReload(IOException e) {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getProjectsConfigurationFile());
        String projectDisplayName = project != null ? ProjectUtils.getInformation((Project)project).getDisplayName() : "???";
        String msg = String.format("An error found in the configuration file %s in the project %s: %s", this.getProjectsConfigurationFile().getNameExt(), projectDisplayName, e.getMessage());
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
    }

    public Collection<String> getTagsNames() {
        return this.tags.keySet();
    }

    public Collection<Tag> getTags() {
        return this.tags.values();
    }

    public Collection<String> getAttributesNames() {
        return this.attrs.keySet();
    }

    public Collection<Attribute> getAttributes() {
        return this.attrs.values();
    }

    public Tag getTag(String tagName) {
        return this.tags.get(tagName);
    }

    public Attribute getAttribute(String name) {
        return this.attrs.get(name);
    }

    public void add(Tag t) {
        this.tags.put(t.getName(), t);
    }

    public void remove(Tag t) {
        this.tags.remove(t.getName());
    }

    public void add(Attribute a) {
        this.attrs.put(a.getName(), a);
    }

    public void remove(Attribute a) {
        this.attrs.remove(a.getName());
    }

    private void reload() throws IOException {
        if (this.getProjectsConfigurationFile() != null) {
            this.tags.clear();
            this.attrs.clear();
            final Document document = this.getDocument(this.getProjectsConfigurationFile());
            final AtomicReference docContentRef = new AtomicReference();
            final AtomicReference bleRef = new AtomicReference();
            document.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        docContentRef.set(document.getText(0, document.getLength()));
                    }
                    catch (BadLocationException ex) {
                        bleRef.set(ex);
                    }
                }
            });
            if (bleRef.get() != null) {
                throw new IOException((Throwable)bleRef.get());
            }
            String content = (String)docContentRef.get();
            this.root = (JSONObject)JSONValue.parse((String)content);
            if (this.root != null) {
                JSONObject attributes;
                JSONObject elements = (JSONObject)this.root.get((Object)ELEMENTS);
                if (elements != null) {
                    List<Tag> rootTags = this.loadTags(elements, null);
                    for (Tag rootTag : rootTags) {
                        this.tags.put(rootTag.getName(), rootTag);
                    }
                }
                if ((attributes = (JSONObject)this.root.get((Object)ATTRIBUTES)) != null) {
                    List<Attribute> rootAttrs = this.loadAttributes(attributes, null);
                    for (Attribute a : rootAttrs) {
                        this.attrs.put(a.getName(), a);
                    }
                }
            }
        }
    }

    private Document getDocument(FileObject file) throws IOException {
        DataObject dobj = DataObject.find((FileObject)file);
        EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            return ec.openDocument();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject store() throws IOException {
        this.initConfigFile();
        JSONObject node = new JSONObject();
        this.storeTags(node, this.tags.values());
        this.storeAttributes(node, this.attrs.values());
        final String newContent = node.toJSONString();
        DataObject dobj = DataObject.find((FileObject)this.getProjectsConfigurationFile());
        EditorCookie editorCookie = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        final BaseDocument document = (BaseDocument)editorCookie.openDocument();
        final AtomicReference bleRef = new AtomicReference();
        final Reformat reformat = Reformat.get((Document)document);
        Preferences preferences = CodeStylePreferences.get((Document)document).getPreferences();
        preferences.put("wrapArrayInit", "WRAP_ALWAYS");
        preferences.put("wrapArrayInitItems", "WRAP_ALWAYS");
        preferences.put("wrapObjects", "WRAP_ALWAYS");
        preferences.put("wrapProperties", "WRAP_ALWAYS");
        document.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    document.remove(0, document.getLength());
                    document.insertString(0, newContent, null);
                }
                catch (BadLocationException ex) {
                    bleRef.set(ex);
                }
            }
        });
        if (bleRef.get() != null) {
            throw new IOException((Throwable)bleRef.get());
        }
        try {
            reformat.lock();
            document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        reformat.reformat(0, document.getLength());
                    }
                    catch (BadLocationException ex) {
                        bleRef.set(ex);
                    }
                }
            });
            if (bleRef.get() != null) {
                throw new IOException((Throwable)bleRef.get());
            }
        }
        finally {
            reformat.unlock();
        }
        editorCookie.saveDocument();
        return node;
    }

    private void storeTags(JSONObject node, Collection<Tag> tags) {
        JSONObject el = new JSONObject();
        node.put((Object)ELEMENTS, (Object)el);
        for (Tag t : tags) {
            this.storeTag(el, t);
        }
    }

    private void storeTag(JSONObject node, Tag t) {
        Collection<Attribute> attributes;
        JSONObject ctn = new JSONObject();
        node.put((Object)t.getName(), (Object)ctn);
        this.storeElement(ctn, t);
        Collection<Tag> children = t.getTags();
        if (!children.isEmpty()) {
            this.storeTags(ctn, children);
        }
        if (!(attributes = t.getAttributes()).isEmpty()) {
            this.storeAttributes(ctn, attributes);
        }
    }

    private void storeAttributes(JSONObject node, Collection<Attribute> attributes) {
        JSONObject el = new JSONObject();
        node.put((Object)ATTRIBUTES, (Object)el);
        for (Attribute t : attributes) {
            this.storeAttribute(el, t);
        }
    }

    private void storeAttribute(JSONObject node, Attribute t) {
        JSONObject ctn = new JSONObject();
        node.put((Object)t.getName(), (Object)ctn);
        String type = t.getType();
        if (type != null) {
            ctn.put((Object)TYPE, (Object)type);
        }
        this.storeElement(ctn, t);
    }

    private void storeElement(JSONObject ctn, Element t) {
        if (t.getDescription() != null) {
            ctn.put((Object)DESCRIPTION, (Object)t.getDescription());
        }
        if (t.getDocumentation() != null) {
            ctn.put((Object)DOC, (Object)t.getDocumentation());
        }
        if (t.getDocumentationURL() != null) {
            ctn.put((Object)DOC_URL, (Object)t.getDocumentationURL());
        }
        if (t.isRequired()) {
            ctn.put((Object)REQUIRED, (Object)Boolean.TRUE.toString());
        }
        Collection<String> contexts = t.getContexts();
        if (t.getParent() != null) {
            ArrayList<String> noParentInContexts = new ArrayList<String>();
            for (String ctx : contexts) {
                if (ctx.equals(t.getParent().getName())) continue;
                noParentInContexts.add(ctx);
            }
            contexts = noParentInContexts;
        }
        if (!contexts.isEmpty()) {
            if (contexts.size() == 1) {
                ctn.put((Object)CONTEXT, (Object)contexts.iterator().next());
            } else {
                ctn.put((Object)CONTEXT, contexts);
            }
        }
    }

    private List<Tag> loadTags(JSONObject node, Tag parent) {
        ArrayList<Tag> innerTags = new ArrayList<Tag>();
        for (Object key : node.keySet()) {
            JSONObject jsonAttributes;
            String name = (String)key;
            JSONObject val = (JSONObject)node.get((Object)name);
            LOGGER.log(Level.FINE, "element {0}: {1}", new Object[]{name, val});
            JSONArray contexts = new ArrayList();
            Object ctx = val.get((Object)CONTEXT);
            if (!(ctx instanceof JSONObject)) {
                if (ctx instanceof String) {
                    contexts.add((String)ctx);
                } else if (ctx instanceof JSONArray) {
                    contexts = (JSONArray)ctx;
                }
            }
            String description = null;
            Object jsonDescription = val.get((Object)DESCRIPTION);
            if (jsonDescription != null) {
                if (jsonDescription instanceof String) {
                    description = (String)jsonDescription;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have a string value!", DESCRIPTION);
                }
            }
            String doc = null;
            Object jsonDoc = val.get((Object)DOC);
            if (jsonDoc != null) {
                if (jsonDoc instanceof String) {
                    doc = (String)jsonDoc;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have a string value!", DOC);
                }
            }
            String docURL = null;
            Object jsonDocURL = val.get((Object)DOC_URL);
            if (jsonDocURL != null) {
                if (jsonDocURL instanceof String) {
                    docURL = (String)jsonDocURL;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have a string value!", DOC_URL);
                }
            }
            boolean required = false;
            Object jsonRequired = val.get((Object)REQUIRED);
            if (jsonRequired != null) {
                if (jsonRequired instanceof String) {
                    required = Boolean.parseBoolean((String)jsonRequired);
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have a string value!", REQUIRED);
                }
            }
            Tag tag = new Tag(name, description, doc, docURL, parent, required, contexts.toArray(new String[0]));
            Object jsonElements = val.get((Object)ELEMENTS);
            if (jsonElements != null) {
                if (jsonElements instanceof JSONObject) {
                    JSONObject els = (JSONObject)jsonElements;
                    List<Tag> elements = this.loadTags(els, tag);
                    tag.setChildren(elements);
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have a map value!", ELEMENTS);
                }
            }
            List<Attribute> attributes = (jsonAttributes = (JSONObject)val.get((Object)ATTRIBUTES)) != null ? this.loadAttributes(jsonAttributes, tag) : Collections.emptyList();
            tag.setAttributes(attributes);
            innerTags.add(tag);
        }
        return innerTags;
    }

    private List<Attribute> loadAttributes(JSONObject node, Tag tag) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Object key : node.keySet()) {
            String name = (String)key;
            Object value = node.get(key);
            LOGGER.log(Level.FINE, "attribute {0}: {1}", new Object[]{key, value});
            if (value instanceof String) {
                String type = (String)value;
                Attribute a = new Attribute(name, type, null, null, null, tag, false, new String[0]);
                attributes.add(a);
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            JSONObject val = (JSONObject)value;
            JSONArray contexts = new ArrayList();
            Object ctx = val.get((Object)CONTEXT);
            if (!(ctx instanceof JSONObject)) {
                if (ctx instanceof String) {
                    contexts.add((String)ctx);
                } else if (ctx instanceof JSONArray) {
                    contexts = (JSONArray)ctx;
                }
            }
            String type = null;
            Object jsonType = val.get((Object)TYPE);
            if (jsonType != null) {
                if (jsonType instanceof String) {
                    type = (String)jsonType;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have string value!", TYPE);
                }
            }
            String description = null;
            Object jsonDescription = val.get((Object)DESCRIPTION);
            if (jsonDescription != null) {
                if (jsonDescription instanceof String) {
                    description = (String)jsonDescription;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have string value!", DESCRIPTION);
                }
            }
            String doc = null;
            Object jsonDoc = val.get((Object)DOC);
            if (jsonDoc != null) {
                if (jsonDoc instanceof String) {
                    doc = (String)jsonDoc;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have string value!", DOC);
                }
            }
            String docURL = null;
            Object jsonDocURL = val.get((Object)DOC_URL);
            if (jsonDocURL != null) {
                if (jsonDocURL instanceof String) {
                    docURL = (String)jsonDocURL;
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have string value!", DOC_URL);
                }
            }
            boolean required = false;
            Object jsonRequired = val.get((Object)REQUIRED);
            if (jsonRequired != null) {
                if (jsonRequired instanceof String) {
                    required = Boolean.parseBoolean((String)jsonRequired);
                } else {
                    LOGGER.log(Level.WARNING, "The '{0}' key needs to have a string value!", REQUIRED);
                }
            }
            Attribute a = new Attribute(name, type, description, doc, docURL, tag, required, contexts.toArray(new String[0]));
            attributes.add(a);
        }
        return attributes;
    }

    private final class ConfigFileChangeListener
    extends FileChangeAdapter {
        private ConfigFileChangeListener() {
        }

        public void fileChanged(FileEvent fe) {
            LOGGER.log(Level.INFO, "Config file {0} changed - reloading configuration.", Configuration.this.configFile.getPath());
            try {
                Configuration.this.reload();
            }
            catch (IOException ex) {
                Configuration.this.handleIOEFromReload(ex);
            }
        }
    }
}

