/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.execution.CompileExecSupport;
import org.netbeans.modules.cnd.spi.toolchain.CompilerLineConvertor;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public abstract class CompileRunActionBase
extends AbstractExecutorRunAction {
    @Override
    protected boolean accept(DataObject object) {
        return object != null && object.getLookup().lookup(CompileExecSupport.class) != null;
    }

    protected void performAction(Node[] activatedNodes) {
        LifecycleManager.getDefault().saveAll();
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.performAction(activatedNodes[i]);
        }
    }

    public void performAction(Node node) {
        this.performAction(node, CompileRunActionBase.getProject(node));
    }

    private Future<Integer> performAction(final Node node, final Project project) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private NativeExecutionService es;

                public void doWork() {
                    this.es = CompileRunActionBase.this.prepare(node, project);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = CompileRunActionBase.getString("DLG_TITLE_Prepare", node.getName());
            String msg = CompileRunActionBase.getString("MSG_TITLE_Prepare", node.getName());
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            NativeExecutionService es = this.prepare(node, project);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private NativeExecutionService prepare(Node node, Project project) {
        Writer outputListener = null;
        CompileExecSupport ces = (CompileExecSupport)node.getLookup().lookup(CompileExecSupport.class);
        if (ces == null) {
            CompileRunActionBase.trace("Node " + node + " does not have CompileExecSupport");
            return null;
        }
        CompileRunActionBase.saveNode(node);
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        String bdir = ces.getRunDirectory();
        FileObject compileDirObject = RemoteFileUtil.getFileObject((FileObject)fileObject.getParent(), (String)bdir);
        if (compileDirObject == null) {
            CompileRunActionBase.trace("Run folder folder is null");
            return null;
        }
        String compileDir = compileDirObject.getPath();
        ExecutionEnvironment execEnv = CompileRunActionBase.getExecutionEnvironment(fileObject, project);
        if (FileSystemProvider.getExecutionEnvironment((FileObject)compileDirObject).isLocal()) {
            compileDir = CompileRunActionBase.convertToRemoteIfNeeded(execEnv, compileDir, project);
        }
        if (compileDir == null) {
            CompileRunActionBase.trace("Compile folder folder is null");
            return null;
        }
        CompilerSet compilerSet = CompileRunActionBase.getCompilerSet(node, project);
        if (compilerSet == null) {
            CompileRunActionBase.trace("Not found tool collection");
            return null;
        }
        String mimeType = fileObject.getMIMEType();
        Tool tool = null;
        if ("text/x-c++".equals(mimeType)) {
            tool = compilerSet.findTool((ToolKind)PredefinedToolKind.CCCompiler);
        } else if ("text/x-c".equals(mimeType)) {
            tool = compilerSet.findTool((ToolKind)PredefinedToolKind.CCompiler);
        } else if ("text/x-fortran".equals(mimeType)) {
            tool = compilerSet.findTool((ToolKind)PredefinedToolKind.FortranCompiler);
        }
        if (tool == null || tool.getPath() == null) {
            CompileRunActionBase.trace("Not found compiler");
            return null;
        }
        final String compilerPath = tool.getPath();
        final StringBuilder argsFlat = new StringBuilder();
        argsFlat.append(ces.getCompileFlags()).append(' ');
        argsFlat.append(fileObject.getNameExt()).append(' ');
        argsFlat.append("-o ").append(fileObject.getName()).append(' ');
        argsFlat.append(ces.getLinkFlags());
        Map<String, String> envMap = CompileRunActionBase.getEnv(execEnv, node, project, null);
        String tabName = this.getTabName(node, execEnv);
        InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
        _tab.closeInputOutput();
        final InputOutput inputOutput = IOProvider.getDefault().getIO(tabName, true);
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        RemoteSyncWorker syncWorker = RemoteSyncSupport.createSyncWorker((Lookup.Provider)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr());
        if (syncWorker != null && !syncWorker.startup(envMap)) {
            CompileRunActionBase.trace("RemoteSyncWorker is not started up");
            return null;
        }
        MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)execEnv);
        mm.putAll(envMap);
        CompileRunActionBase.traceExecutable(compilerPath, compileDir, argsFlat, execEnv.toString(), (Map<String, String>)mm.toMap());
        final Runnable runContext = this.getRunnable(tabName, inputOutput, execEnv, compileDir, fileObject.getName(), ces);
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
                inputOutput.getOut().println(compilerPath + " " + argsFlat.toString());
            }

            public void executionFinished(int rc) {
                if (rc == 0) {
                    runContext.run();
                }
            }
        };
        CompilerLineConvertor compilerLineConvertor = new CompilerLineConvertor(project, compilerSet, execEnv, compileDirObject, inputOutput);
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, (LineConvertor)compilerLineConvertor, syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(compileDir).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(mm);
        npb.redirectError();
        List<String> list = ImportUtils.parseArgs(argsFlat.toString());
        list = ImportUtils.normalizeParameters(list);
        npb.setExecutable(compilerPath);
        npb.setArguments(list.toArray(new String[list.size()]));
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).outLineBased(true).showProgress(!CndUtils.isStandalone()).postExecution((Runnable)processChangeListener).postMessageDisplayer((PostMessageDisplayer)new PostMessageDisplayer.Default("Compile")).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        return NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"Compile");
    }

    protected abstract String getTabName(Node var1, ExecutionEnvironment var2);

    protected abstract Runnable getRunnable(String var1, InputOutput var2, ExecutionEnvironment var3, String var4, String var5, CompileExecSupport var6);
}

