/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.Component;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.editor.filecreation.CndPanel;
import org.netbeans.modules.cnd.editor.filecreation.NewQtFormPanelGUI;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class NewQtFormPanel
extends CndPanel {
    private static final FormType[] FORM_TYPES = new FormType[]{new FormType("dialog-buttonsbottom.ui", "QDialog"), new FormType("dialog-buttonsright.ui", "QDialog"), new FormType("dialog-nobuttons.ui", "QDialog"), new FormType("mainwindow.ui", "QMainWindow"), new FormType("widget.ui", "QWidget")};

    NewQtFormPanel(Project project, SourceGroup[] folders) {
        super(project, folders, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        Object object = this.guiLock;
        synchronized (object) {
            if (this.gui == null) {
                this.gui = new NewQtFormPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), FORM_TYPES);
                this.gui.addChangeListener(this);
            }
        }
        return this.gui;
    }

    @Override
    protected void doStoreSettings(WizardDescriptor settings) {
        String table = ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).getReplaceableStringsTable();
        table = table + "\nCLASSNAME=" + this.getGui().getFormName();
        if (this.getGui().getHeaderFileName() != null) {
            table = table + "\nDEFAULT_HEADER_EXT=" + FileUtil.getExtension((String)this.getGui().getHeaderFileName());
            table = table + "\nWIDGETCLASSNAME=" + this.getGui().getFormType().widgetClassName;
        }
        ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).setReplaceableStringsTable(table);
    }

    NewQtFormPanelGUI getGui() {
        return (NewQtFormPanelGUI)this.gui;
    }

    @Override
    public boolean isValid() {
        String targetFolder;
        boolean ok = super.isValid();
        if (!ok) {
            this.setErrorMessage("");
            return false;
        }
        if (!CndLexerUtilities.isCppIdentifier((CharSequence)this.getGui().getFormName())) {
            this.setErrorMessage(NbBundle.getMessage(NewQtFormPanel.class, (String)"MSG_not_valid_formname"));
            return false;
        }
        FileObject groupFolder = this.getGui().getTargetGroup().getRootFolder();
        String errorMessage = NewQtFormPanel.canUseFileName(groupFolder, targetFolder = this.getGui().getTargetFolder(), this.getGui().getFormFileName(), false);
        if (errorMessage == null && this.getGui().getSourceFileName() != null && (errorMessage = NewQtFormPanel.canUseFileName(groupFolder, targetFolder, this.getGui().getSourceFileName(), false)) == null && this.getGui().getHeaderFileName() != null) {
            errorMessage = NewQtFormPanel.canUseFileName(groupFolder, targetFolder, this.getGui().getHeaderFileName(), false);
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    public static FileObject getTemplateFileObject(String formType) {
        return FileUtil.getConfigFile((String)("Templates/qtFiles/" + formType));
    }

    public static DataObject getTemplateDataObject(String formType) {
        FileObject fileObj = NewQtFormPanel.getTemplateFileObject(formType);
        if (fileObj != null) {
            try {
                return DataObject.find((FileObject)fileObj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTemplateDisplayName(String formType) {
        DataObject dataObj = NewQtFormPanel.getTemplateDataObject(formType);
        if (dataObj != null) {
            return dataObj.getNodeDelegate().getDisplayName();
        }
        return formType;
    }

    public static class FormType {
        public final String templateFileName;
        public final String templateDisplayName;
        public final String widgetClassName;

        public FormType(String file, String clazz) {
            this.templateFileName = file;
            this.templateDisplayName = NewQtFormPanel.getTemplateDisplayName(file);
            this.widgetClassName = clazz;
        }

        public String toString() {
            return this.templateDisplayName;
        }
    }
}

