/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars.models;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;

final class JSWatchVar
implements PropertyChangeListener {
    private final JPDADebugger debugger;
    private final JPDAWatch watch;
    private JSVariable jsVar;
    private boolean hasJSVar;

    JSWatchVar(JPDADebugger debugger, JPDAWatch watch) {
        this.debugger = debugger;
        this.watch = watch;
        ((Customizer)watch).addPropertyChangeListener(this);
    }

    static boolean is(Object var) {
        return var instanceof ObjectVariable && var instanceof JPDAWatch;
    }

    JPDAWatch getWatch() {
        return this.watch;
    }

    synchronized JSVariable getJSVar() {
        if (!this.hasJSVar && this.jsVar == null) {
            this.jsVar = JSVariable.createIfScriptObject(this.debugger, (ObjectVariable)this.watch, this.watch.getExpression());
            this.hasJSVar = true;
        }
        return this.jsVar;
    }

    JSVariable getJSVarIfExists() {
        return this.jsVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName())) {
            JSWatchVar jSWatchVar = this;
            synchronized (jSWatchVar) {
                this.jsVar = null;
                this.hasJSVar = false;
            }
        }
    }
}

