/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.propdos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.propdos.Issue164431Workaround;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.modules.propdos.PropertiesAdapter;
import org.netbeans.modules.propdos.PropertiesBasedDataObject;
import org.netbeans.modules.propdos.SelfSavingProperties;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class PropertiesBasedDataObject<T>
extends MultiDataObject {
    protected static final Logger LOGGER = Logger.getLogger(PropertiesBasedDataObject.class.getPackage().getName());
    private final InstanceContent internalContent = new InstanceContent();
    protected final InstanceContent content = new InstanceContent();
    private final Issue164431Workaround lkp;
    private final Class<T> type;
    private final PropsAdapter propsAdapter;
    private final L l = new L();

    protected PropertiesBasedDataObject(FileObject pf, MultiFileLoader loader, Class<T> type) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.type = type;
        this.lkp = new Issue164431Workaround(new C(), new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.internalContent), this.getCookieSet().getLookup(), new AbstractLookup((AbstractLookup.Content)this.content)});
        this.propsAdapter = new PropsAdapter();
        this.internalContent.add((Object)this.propsAdapter);
        this.internalContent.add((Object)this);
        this.getCookieSet().add((Node.Cookie)new IC());
        pf.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.l, (Object)pf));
    }

    private void replaceCreatedObject() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "replaceCreatedObject() on " + this.getPrimaryFile().getPath() + " for " + this.type().getName() + " discarding old InstanceContent.Converter and its" + " instance, and invoking onReplaceObject()");
        }
        this.lkp.replaceConverter(new C());
        this.propsAdapter.clear();
        this.onReplaceObject();
    }

    protected final void handleDelete() throws IOException {
        final FileObject parent = this.getPrimaryFile().getParent();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    PropertiesBasedDataObject.this.onDelete(parent);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            Logger.getLogger(PropertiesBasedDataObject.class.getName()).log(Level.FINE, e.getMessage(), e);
        }
        super.handleDelete();
    }

    protected abstract void onDelete(FileObject var1) throws Exception;

    protected void propertyChanged(String propertyName, String newValue) {
    }

    protected final Class<T> type() {
        return this.type;
    }

    protected abstract T createFrom(ObservableProperties var1);

    public final Lookup getLookup() {
        return this.lkp;
    }

    public boolean isCopyAllowed() {
        return false;
    }

    public boolean isMoveAllowed() {
        return false;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public final Sheet.Set getPropertiesAsPropertySet() {
        Sheet.Set result = Sheet.createExpertSet();
        ObservableProperties p = this.propsAdapter.asProperties();
        ArrayList props = new ArrayList(NbCollections.checkedSetByFilter(p.keySet(), String.class, (boolean)false));
        Collections.sort(props);
        for (String s : props) {
            result.put((Node.Property)new SP(s));
        }
        return result;
    }

    protected void onReplaceObject() {
    }

    protected final void refreshObject() {
        this.replaceCreatedObject();
    }

    private final class IC
    implements InstanceCookie.Of,
    InstanceCookie {
        private IC() {
        }

        public boolean instanceOf(Class<?> type) {
            return type.isAssignableFrom(PropertiesBasedDataObject.this.type);
        }

        public String instanceName() {
            return PropertiesBasedDataObject.this.getName();
        }

        public Class<?> instanceClass() throws IOException, ClassNotFoundException {
            return PropertiesBasedDataObject.this.type;
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return PropertiesBasedDataObject.this.getLookup().lookup(PropertiesBasedDataObject.this.type);
        }
    }

    private final class C
    implements InstanceContent.Convertor<C, T> {
        private C() {
        }

        public T convert(C arg0) {
            if (!PropertiesBasedDataObject.this.isValid()) {
                return null;
            }
            ObservableProperties props = PropertiesBasedDataObject.this.propsAdapter.asProperties();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Request for " + PropertiesBasedDataObject.this.type().getName() + " from " + PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " observable properties completed.  Invoking " + "createFrom() for " + this.getClass().getName() + " with " + props);
            }
            return props == null ? null : (Object)PropertiesBasedDataObject.this.createFrom(props);
        }

        public Class<? extends T> type(C arg0) {
            return PropertiesBasedDataObject.this.type;
        }

        public String id(C arg0) {
            return "" + System.identityHashCode(this);
        }

        public String displayName(C arg0) {
            return PropertiesBasedDataObject.this.getName();
        }
    }

    private final class JCSelfSavingProperties
    extends SelfSavingProperties {
        JCSelfSavingProperties() {
            super((DataObject)PropertiesBasedDataObject.this);
        }

        @Override
        protected void onWriteCompleted() throws IOException {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Write of " + PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " observable properties completed.  Invoking " + "replaceCreatedObject() for " + this.getClass().getName());
            } else if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINE, "Write of " + PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " observable properties completed.  Invoking " + "replaceCreatedObject() for " + this.getClass().getName() + " - data now" + this, new Exception());
            }
            PropertiesBasedDataObject.this.replaceCreatedObject();
        }
    }

    private final class PropsAdapter
    implements PropertiesAdapter {
        private SelfSavingProperties props;

        private PropsAdapter() {
        }

        synchronized void clear() {
            this.props = null;
        }

        synchronized Properties copy() {
            return this.props == null ? new Properties() : new Properties(this.props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized ObservableProperties asProperties() {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Fetch " + PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " as observable properties");
            }
            if (!PropertiesBasedDataObject.this.isValid()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " is invalid, returning null");
                }
                return null;
            }
            if (this.props == null) {
                this.props = new JCSelfSavingProperties();
                this.props.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)PropertiesBasedDataObject.this.l, (Object)this.props));
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "First load of " + PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " as observable properties");
                }
                try {
                    InputStream in = PropertiesBasedDataObject.this.getPrimaryFile().getInputStream();
                    try {
                        this.props.load(in);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Load of " + PropertiesBasedDataObject.this.getPrimaryFile().getPath() + " failed");
                    }
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.props;
        }
    }

    private final class SP
    extends PropertySupport.ReadOnly<String> {
        org.netbeans.modules.propdos.PropertiesBasedDataObject$SP.S s;

        SP(String name) {
            super(name, String.class, name, null);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return PropertiesBasedDataObject.this.propsAdapter.asProperties().getProperty(this.getName());
        }

        public String getShortDescription() {
            return PropertiesBasedDataObject.this.propsAdapter.asProperties().getProperty(this.getName());
        }

        public PropertyEditor getPropertyEditor() {
            return this.s == null ? (this.s = new S()) : this.s;
        }

        private final class S
        extends PropertyEditorSupport
        implements PropertyChangeListener {
            S() {
                super((Object)SP.this);
                ObservableProperties p = PropertiesBasedDataObject.this.propsAdapter.asProperties();
                p.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)p));
            }

            @Override
            public Object getValue() {
                return super.getValue();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SP.this.getName().equals(evt.getPropertyName())) {
                    super.firePropertyChange();
                }
            }
        }
    }

    private final class L
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private L() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertiesBasedDataObject.this.refreshObject();
            PropertiesBasedDataObject.this.propertyChanged(evt.getPropertyName(), (String)evt.getNewValue());
        }

        public void fileChanged(FileEvent fe) {
            if (!fe.isExpected()) {
                PropertiesBasedDataObject.this.propsAdapter.clear();
                PropertiesBasedDataObject.this.refreshObject();
                PropertiesBasedDataObject.this.propertyChanged(null, null);
            }
        }
    }
}

