/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.ide.JBossJaxWsStack;
import org.netbeans.modules.javaee.wildfly.ide.JpaSupportImpl;
import org.netbeans.modules.javaee.wildfly.util.WildFlyProperties;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WildflyJ2eePlatformFactory
extends J2eePlatformFactory {
    static final String HIBERNATE_JPA_PROVIDER = "org.hibernate.ejb.HibernatePersistence";
    static final String TOPLINK_JPA_PROVIDER = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    static final String KODO_JPA_PROVIDER = "kodo.persistence.PersistenceProviderImpl";
    private static final WeakHashMap<InstanceProperties, J2eePlatformImplImpl> instanceCache = new WeakHashMap();

    public synchronized J2eePlatformImpl getJ2eePlatformImpl(DeploymentManager dm) {
        WildflyDeploymentManager manager = (WildflyDeploymentManager)dm;
        InstanceProperties ip = manager.getInstanceProperties();
        if (ip == null) {
            throw new RuntimeException("Cannot create J2eePlatformImpl instance for " + manager.getUrl());
        }
        J2eePlatformImplImpl platform = instanceCache.get(ip);
        if (platform == null) {
            platform = new J2eePlatformImplImpl(manager.getProperties());
            instanceCache.put(ip, platform);
        }
        return platform;
    }

    public static class J2eePlatformImplImpl
    extends J2eePlatformImpl2 {
        private static final Set<J2eeModule.Type> MODULE_TYPES = new HashSet<J2eeModule.Type>();
        private static final Set<Profile> WILDFLY_PROFILES;
        private static final Set<Profile> EAP6_PROFILES;
        private static final Set<Profile> WILDFLY_WEB_PROFILES;
        private LibraryImplementation[] libraries;
        private final WildFlyProperties properties;

        public J2eePlatformImplImpl(WildFlyProperties properties) {
            this.properties = properties;
        }

        public Set<Profile> getSupportedProfiles() {
            if (this.properties.isWildfly()) {
                if (this.properties.isServletOnly()) {
                    return Collections.unmodifiableSet(WILDFLY_WEB_PROFILES);
                }
                return Collections.unmodifiableSet(WILDFLY_PROFILES);
            }
            return Collections.unmodifiableSet(EAP6_PROFILES);
        }

        public Set<Profile> getSupportedProfiles(J2eeModule.Type moduleType) {
            if (this.properties.isWildfly()) {
                return Collections.unmodifiableSet(WILDFLY_PROFILES);
            }
            return Collections.unmodifiableSet(EAP6_PROFILES);
        }

        public Set<J2eeModule.Type> getSupportedTypes() {
            return Collections.unmodifiableSet(MODULE_TYPES);
        }

        public Set getSupportedJavaPlatformVersions() {
            HashSet<String> versions = new HashSet<String>();
            versions.add("1.7");
            versions.add("1.8");
            return versions;
        }

        public JavaPlatform getJavaPlatform() {
            return this.properties.getJavaPlatform();
        }

        public File[] getPlatformRoots() {
            return new File[]{this.getServerHome(), this.getDomainHome()};
        }

        public File getServerHome() {
            return this.properties.getRootDir();
        }

        public File getDomainHome() {
            return this.properties.getServerDir();
        }

        public File getMiddlewareHome() {
            return null;
        }

        public LibraryImplementation[] getLibraries() {
            if (this.libraries == null) {
                this.initLibraries();
            }
            return (LibraryImplementation[])this.libraries.clone();
        }

        public void notifyLibrariesChanged() {
            this.initLibraries();
            this.firePropertyChange("libraries", null, this.libraries.clone());
        }

        public Image getIcon() {
            return null;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(WildflyJ2eePlatformFactory.class, (String)"TITLE_JBOSS_FACTORY");
        }

        public boolean isToolSupported(String toolName) {
            if ("jsr109".equals(toolName) && this.containsJaxWsLibraries()) {
                return true;
            }
            if ("wsimport".equals(toolName) && this.containsJaxWsLibraries()) {
                return true;
            }
            if ("wsgen".equals(toolName) && this.containsJaxWsLibraries()) {
                return true;
            }
            if ("JaxWs-in-j2ee14-supported".equals(toolName) && this.containsJaxWsLibraries()) {
                return true;
            }
            if (!this.containsJaxWsLibraries() && ("wscompile".equals(toolName) || "appClientRuntime".equals(toolName))) {
                return true;
            }
            if (WildflyJ2eePlatformFactory.HIBERNATE_JPA_PROVIDER.equals(toolName) || WildflyJ2eePlatformFactory.TOPLINK_JPA_PROVIDER.equals(toolName) || WildflyJ2eePlatformFactory.KODO_JPA_PROVIDER.equals(toolName)) {
                return this.containsPersistenceProvider(toolName);
            }
            if ("jpaversionverification".equals(toolName)) {
                return true;
            }
            if ("jpa1.0".equals(toolName)) {
                return true;
            }
            if ("jpa2.0".equals(toolName)) {
                return true;
            }
            if ("jpa2.1".equals(toolName)) {
                return this.properties.isWildfly();
            }
            if ("hibernatePersistenceProviderIsDefault2.0".equals(toolName)) {
                return true;
            }
            return "defaultPersistenceProviderJavaEE5".equals(toolName);
        }

        String getDefaultJpaProvider() {
            return WildflyJ2eePlatformFactory.HIBERNATE_JPA_PROVIDER;
        }

        private boolean containsJaxWsLibraries() {
            File[] jaxWsAPILib = new File(this.properties.getModulePath("org/jboss/ws/api/main")).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("jbossws-api") && name.endsWith("jar");
                }
            });
            if (jaxWsAPILib != null && jaxWsAPILib.length == 1 && jaxWsAPILib[0].exists()) {
                return true;
            }
            jaxWsAPILib = new File(this.properties.getModulePath("javax/xml/ws/api/main")).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("jboss-jaxws-api") && name.endsWith("jar");
                }
            });
            return jaxWsAPILib != null && jaxWsAPILib.length == 1 && jaxWsAPILib[0].exists();
        }

        boolean containsPersistenceProvider(String providerName) {
            return J2eePlatformImplImpl.containsService(this.libraries, "javax.persistence.spi.PersistenceProvider", providerName);
        }

        private static boolean containsService(LibraryImplementation[] libraries, String serviceName, String serviceImplName) {
            for (LibraryImplementation libImpl : libraries) {
                if (!J2eePlatformImplImpl.containsService(libImpl, serviceName, serviceImplName)) continue;
                return true;
            }
            return false;
        }

        private static boolean containsService(LibraryImplementation library, String serviceName, String serviceImplName) {
            List roots = library.getContent("classpath");
            for (URL rootUrl : roots) {
                String serviceRelativePath;
                FileObject archiveRoot;
                FileObject serviceFO;
                FileObject root = URLMapper.findFileObject((URL)rootUrl);
                if (root == null || !"jar".equals(rootUrl.getProtocol()) || (serviceFO = (archiveRoot = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)root))).getFileObject(serviceRelativePath = "META-INF/services/" + serviceName)) == null || !J2eePlatformImplImpl.containsService(serviceFO, serviceName, serviceImplName)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean containsService(FileObject serviceFO, String serviceName, String serviceImplName) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(serviceFO.getInputStream()));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return false;
                    int ci = line.indexOf(35);
                    if (ci < 0) continue;
                    line = line.substring(0, ci);
                } while (!line.trim().equals(serviceImplName));
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                Exceptions.attachLocalizedMessage((Throwable)ex, (String)serviceFO.toURL().toString());
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
            return false;
        }

        public File[] getToolClasspathEntries(String toolName) {
            if ("wsimport".equals(toolName)) {
                return this.getJaxWsLibraries();
            }
            if ("wsgen".equals(toolName)) {
                return this.getJaxWsLibraries();
            }
            if ("wscompile".equals(toolName)) {
                File root = InstalledFileLocator.getDefault().locate("modules/ext/jaxrpc16", null, false);
                return new File[]{new File(root, "saaj-api.jar"), new File(root, "saaj-impl.jar"), new File(root, "jaxrpc-api.jar"), new File(root, "jaxrpc-impl.jar")};
            }
            if ("appClientRuntime".equals(toolName)) {
                return new File(this.properties.getRootDir(), "client").listFiles(new FF());
            }
            return null;
        }

        private File[] getJaxWsLibraries() {
            File root = new File(this.properties.getRootDir(), "client");
            File jaxWsAPILib = new File(root, "jboss-jaxws.jar");
            if (jaxWsAPILib.exists()) {
                return new File[]{new File(root, "wstx.jar"), new File(root, "jaxws-tools.jar"), new File(root, "jboss-common-client.jar"), new File(root, "jboss-logging-spi.jar"), new File(root, "stax-api.jar"), new File(root, "jbossws-client.jar"), new File(root, "jboss-jaxws-ext.jar"), new File(root, "jboss-jaxws.jar"), new File(root, "jboss-saaj.jar")};
            }
            jaxWsAPILib = new File(root, "jbossws-native-jaxws.jar");
            if (jaxWsAPILib.exists()) {
                return new File[]{new File(root, "wstx.jar"), new File(root, "jaxws-tools.jar"), new File(root, "jboss-common-client.jar"), new File(root, "jboss-logging-spi.jar"), new File(root, "stax-api.jar"), new File(root, "jbossws-native-client.jar"), new File(root, "jbossws-native-jaxws-ext.jar"), new File(root, "jbossws-native-jaxws.jar"), new File(root, "jbossws-native-saaj.jar")};
            }
            jaxWsAPILib = new File(root, "jaxws-api.jar");
            if (jaxWsAPILib.exists()) {
                return new File[]{new File(root, "wstx.jar"), new File(root, "jaxws-tools.jar"), new File(root, "jboss-common-client.jar"), new File(root, "jboss-logging-spi.jar"), new File(root, "stax-api.jar"), new File(root, "jbossws-metro-client.jar"), new File(root, "saaj-api.jar")};
            }
            return null;
        }

        public String getToolProperty(String toolName, String propertyName) {
            if ("appClientRuntime".equals(toolName)) {
                if ("main.class".equals(propertyName)) {
                    return "";
                }
                if ("main.class.args".equals(propertyName)) {
                    return "";
                }
                if ("j2ee.clientName".equals(propertyName)) {
                    return "${jar.name}";
                }
                if ("jvm.opts".equals(propertyName)) {
                    return " -Djava.naming.factory.url.pkgs=org.jboss.ejb.client.naming";
                }
            }
            return null;
        }

        private void initLibraries() {
            LibraryImplementation lib = new J2eeLibraryTypeProvider().createLibrary();
            lib.setName(NbBundle.getMessage(WildflyJ2eePlatformFactory.class, (String)"TITLE_JBOSS_LIBRARY"));
            lib.setContent("classpath", this.properties.getClasses());
            lib.setContent("javadoc", this.properties.getJavadocs());
            lib.setContent("src", this.properties.getSources());
            this.libraries = new LibraryImplementation[]{lib};
        }

        public Lookup getLookup() {
            WSStack wsStack = WSStackFactory.createWSStack(JaxWs.class, (WSStackImplementation)new JBossJaxWsStack(this.properties.getRootDir()), (WSStack.Source)WSStack.Source.SERVER);
            Lookup baseLookup = Lookups.fixed((Object[])new Object[]{this.properties.getRootDir(), wsStack, new JpaSupportImpl(this), new JaxRsStackSupportImpl(this)});
            return LookupProviderSupport.createCompositeLookup((Lookup)baseLookup, (String)"J2EE/DeploymentPlugins/Wildlfy/Lookup");
        }

        static {
            MODULE_TYPES.add(J2eeModule.Type.EAR);
            MODULE_TYPES.add(J2eeModule.Type.WAR);
            MODULE_TYPES.add(J2eeModule.Type.EJB);
            MODULE_TYPES.add(J2eeModule.Type.RAR);
            MODULE_TYPES.add(J2eeModule.Type.CAR);
            WILDFLY_PROFILES = new HashSet<Profile>();
            WILDFLY_PROFILES.add(Profile.JAVA_EE_6_WEB);
            WILDFLY_PROFILES.add(Profile.JAVA_EE_6_FULL);
            WILDFLY_PROFILES.add(Profile.JAVA_EE_7_WEB);
            WILDFLY_PROFILES.add(Profile.JAVA_EE_7_FULL);
            EAP6_PROFILES = new HashSet<Profile>();
            EAP6_PROFILES.add(Profile.JAVA_EE_6_WEB);
            EAP6_PROFILES.add(Profile.JAVA_EE_6_FULL);
            WILDFLY_WEB_PROFILES = new HashSet<Profile>();
            WILDFLY_WEB_PROFILES.add(Profile.JAVA_EE_6_WEB);
            WILDFLY_WEB_PROFILES.add(Profile.JAVA_EE_7_WEB);
        }

        private class JaxRsStackSupportImpl
        implements JaxRsStackSupportImplementation {
            private static final String JAX_RS_APPLICATION_CLASS = "javax.ws.rs.core.Application";
            private J2eePlatformImplImpl j2eePlatform;

            JaxRsStackSupportImpl(J2eePlatformImplImpl j2eePlatform) {
                this.j2eePlatform = j2eePlatform;
            }

            public boolean addJsr311Api(Project project) {
                return this.isBundled(JAX_RS_APPLICATION_CLASS);
            }

            public boolean extendsJerseyProjectClasspath(Project project) {
                return this.isBundled(JAX_RS_APPLICATION_CLASS);
            }

            public void removeJaxRsLibraries(Project project) {
            }

            public void configureCustomJersey(Project project) {
            }

            public boolean isBundled(String classFqn) {
                this.j2eePlatform.getLibraries();
                for (LibraryImplementation lib : this.j2eePlatform.getLibraries()) {
                    List urls = lib.getContent("classpath");
                    for (URL url : urls) {
                        String path;
                        FileObject root = URLMapper.findFileObject((URL)url);
                        if (FileUtil.isArchiveFile((FileObject)root)) {
                            root = FileUtil.getArchiveRoot((FileObject)root);
                        }
                        if (root.getFileObject(path = classFqn.replace('.', '/') + ".class") == null) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        private static class FF
        implements FilenameFilter {
            private FF() {
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || new File(dir, name).isDirectory();
            }
        }
    }
}

