/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentFactory;
import org.netbeans.modules.javaee.wildfly.WildflyTargetModuleID;
import org.netbeans.modules.javaee.wildfly.config.WildflyConnectionFactory;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasource;
import org.netbeans.modules.javaee.wildfly.config.WildflyJaxrsResource;
import org.netbeans.modules.javaee.wildfly.config.WildflyMailSessionResource;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.netbeans.modules.javaee.wildfly.config.WildflyResourceAdapter;
import org.netbeans.modules.javaee.wildfly.config.WildflySocket;
import org.netbeans.modules.javaee.wildfly.ide.commands.Authentication;
import org.netbeans.modules.javaee.wildfly.ide.commands.WildflyManagementAPI;
import org.netbeans.modules.javaee.wildfly.ide.commands.WildflyModule;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyDatasourceNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyDestinationNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyEarApplicationNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyEjbComponentNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyEjbModuleNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyJaxrsResourceNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyWebModuleNode;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class WildflyClient {
    private static final Logger LOGGER = Logger.getLogger(WildflyClient.class.getName());
    private static final String SERVER_STATE = "server-state";
    private static final String SERVER_ENVIRONMENT = "server-environment";
    private static final String WEB_SUBSYSTEM = "undertow";
    private static final String EJB3_SUBSYSTEM = "ejb3";
    private static final String DATASOURCES_SUBSYSTEM = "datasources";
    private static final String MAIL_SUBSYSTEM = "mail";
    private static final String MESSAGING_SUBSYSTEM = "messaging";
    private static final String MESSAGING_ACTIVEMQ_SUBSYSTEM = "messaging-activemq";
    private static final String RESOURCE_ADAPTER_SUBSYSTEM = "resource-adapters";
    private static final String DATASOURCE_TYPE = "data-source";
    private static final String HORNETQ_SERVER_TYPE = "hornetq-server";
    private static final String MESSAGING_ACTIVEMQ_SERVER_TYPE = "server";
    private static final String MAIL_SESSION_TYPE = "mail-session";
    private static final String JMSQUEUE_TYPE = "jms-queue";
    private static final String JMSTOPIC_TYPE = "jms-topic";
    private static final String CONNECTION_FACTORY_TYPE = "connection-factory";
    private static final String RESOURCE_ADAPTER_TYPE = "resource-adapter";
    private final String serverAddress;
    private final int serverPort;
    private final CallbackHandler handler;
    private final InstanceProperties ip;
    private Object client;
    private final WildflyPluginUtils.Version version;

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServerLog() throws IOException {
        WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
        LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
        values.put("subsystem", "logging");
        values.put("periodic-rotating-file-handler", "FILE");
        return this.resolvePath(cl, values);
    }

    private String resolvePath(WildflyDeploymentFactory.WildFlyClassLoader cl, LinkedHashMap<Object, Object> values) throws IOException {
        try {
            Object readPathOperation = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readPathOperation, "operation"), "resolve-path");
            Object scannerAddress = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readPathOperation, "address"), scannerAddress);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readPathOperation, "relative-to-only"), "false");
            Object response = this.executeOnModelNode(cl, readPathOperation);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                return WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.readResult(cl, response));
            }
            return "";
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public WildflyClient(InstanceProperties ip, WildflyPluginUtils.Version version, String serverAddress, int serverPort) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.ip = ip;
        this.version = version;
        this.handler = new Authentication().getCallbackHandler();
    }

    public WildflyClient(InstanceProperties ip, WildflyPluginUtils.Version version, String serverAddress, int serverPort, String login, String password) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.ip = ip;
        this.version = version;
        this.handler = new Authentication(login, password.toCharArray()).getCallbackHandler();
    }

    private synchronized Object getClient(WildflyDeploymentFactory.WildFlyClassLoader cl) {
        if (this.client == null) {
            try {
                this.client = WildflyManagementAPI.createClient(cl, this.version, this.serverAddress, this.serverPort, this.handler);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, null, ex);
                return null;
            }
        }
        return this.client;
    }

    private synchronized void close() {
        try {
            if (this.client != null) {
                WildflyManagementAPI.closeClient(WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip), this.client);
            }
            this.client = null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    public synchronized void shutdownServer() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object shutdownOperation = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, shutdownOperation, "operation"), "shutdown");
            this.executeAsync(cl, shutdownOperation, null);
            this.close();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public synchronized boolean isServerRunning(String homeDir, String configFile) {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object statusOperation = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, statusOperation, "operation"), "read-attribute");
            WildflyManagementAPI.setModelNodeChildEmptyList(cl, WildflyManagementAPI.getModelNodeChild(cl, statusOperation, "address"));
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, statusOperation, "name"), SERVER_STATE);
            Object response = this.executeAsync(cl, statusOperation, null).get();
            if ("success".equals(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, response, "outcome"))) && !"starting".equals(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, response, "result"))) && !"stopping".equals(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, response, "result")))) {
                Pair<String, String> paths = this.getServerPaths(cl);
                if (paths != null) {
                    String homeDirNorm = homeDir == null ? null : FileUtil.normalizePath((String)homeDir);
                    String configFileNorm = configFile == null ? null : FileUtil.normalizePath((String)configFile);
                    return ((String)paths.first()).equals(homeDirNorm) && ((String)paths.second()).equals(configFileNorm);
                }
                return true;
            }
            return false;
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.FINE, null, ex.getTargetException());
            this.close();
            return false;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | ExecutionException ex) {
            LOGGER.log(Level.FINE, null, ex);
            this.close();
            return false;
        }
    }

    private synchronized Object executeOnModelNode(WildflyDeploymentFactory.WildFlyClassLoader cl, Object modelNode) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> modelClazz = cl.loadClass("org.jboss.dmr.ModelNode");
        Object clientLocal = this.getClient(cl);
        if (clientLocal == null) {
            throw new IOException("Not connected to WildFly server");
        }
        Method method = clientLocal.getClass().getMethod("execute", modelClazz);
        return method.invoke(clientLocal, modelNode);
    }

    private synchronized Object executeOnOperation(WildflyDeploymentFactory.WildFlyClassLoader cl, Object operation) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> operationClazz = cl.loadClass("org.jboss.as.controller.client.Operation");
        Object clientLocal = this.getClient(cl);
        if (clientLocal == null) {
            throw new IOException("Not connected to WildFly server");
        }
        Method method = clientLocal.getClass().getMethod("execute", operationClazz);
        return method.invoke(clientLocal, operation);
    }

    private synchronized Future<?> executeAsync(WildflyDeploymentFactory.WildFlyClassLoader cl, Object modelNode, Object operationMessageHandler) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> modelClazz = cl.loadClass("org.jboss.dmr.ModelNode");
        Class<?> handlerClazz = cl.loadClass("org.jboss.as.controller.client.OperationMessageHandler");
        Object clientLocal = this.getClient(cl);
        if (clientLocal == null) {
            throw new IOException("Not connected to WildFly server");
        }
        Method method = clientLocal.getClass().getMethod("executeAsync", modelClazz, handlerClazz);
        return (Future)method.invoke(clientLocal, modelNode, operationMessageHandler);
    }

    public Collection<WildflyModule> listAvailableModules() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyModule> modules = new ArrayList<WildflyModule>();
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, null);
            Object readDeployments = WildflyManagementAPI.createReadResourceOperation(cl, deploymentAddressModelNode, true);
            Object response = this.executeOnModelNode(cl, readDeployments);
            String httpPort = this.ip.getProperty("port");
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object result = WildflyManagementAPI.readResult(cl, response);
                List webapps = WildflyManagementAPI.modelNodeAsList(cl, result);
                for (Object application : webapps) {
                    String applicationName = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, application), "name"));
                    Object deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, application), "subsystem"), WEB_SUBSYSTEM);
                    WildflyModule module = new WildflyModule(applicationName, true);
                    if (WildflyManagementAPI.modelNodeIsDefined(cl, deployment)) {
                        String url = "http://" + this.serverAddress + ':' + httpPort + WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, deployment, "context-root"));
                        module.setUrl(url);
                    }
                    modules.add(module);
                }
            }
            return modules;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public Collection<WildflyWebModuleNode> listWebModules(Lookup lookup) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyWebModuleNode> modules = new ArrayList<WildflyWebModuleNode>();
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, null);
            Object readDeployments = WildflyManagementAPI.createReadResourceOperation(cl, deploymentAddressModelNode, true);
            Object response = this.executeOnModelNode(cl, readDeployments);
            String httpPort = this.ip.getProperty("port");
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object result = WildflyManagementAPI.readResult(cl, response);
                List webapps = WildflyManagementAPI.modelNodeAsList(cl, result);
                for (Object application : webapps) {
                    String applicationName = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, application), "name"));
                    if (!applicationName.endsWith(".war")) continue;
                    Object deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, application), "subsystem"), WEB_SUBSYSTEM);
                    if (WildflyManagementAPI.modelNodeIsDefined(cl, deployment)) {
                        String url = "http://" + this.serverAddress + ':' + httpPort + WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, deployment, "context-root"));
                        modules.add(new WildflyWebModuleNode(applicationName, lookup, url));
                        continue;
                    }
                    modules.add(new WildflyWebModuleNode(applicationName, lookup, null));
                }
            }
            return modules;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public String getWebModuleURL(String webModuleName) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, webModuleName);
            Object readDeployments = WildflyManagementAPI.createReadResourceOperation(cl, deploymentAddressModelNode, true);
            Object response = this.executeOnModelNode(cl, readDeployments);
            String httpPort = this.ip.getProperty("port");
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object subdeployment;
                Object result = WildflyManagementAPI.readResult(cl, response);
                String applicationName = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, result, "name"));
                if (applicationName.endsWith(".war")) {
                    Object deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, result, "subsystem"), WEB_SUBSYSTEM);
                    if (WildflyManagementAPI.modelNodeIsDefined(cl, deployment)) {
                        return "http://" + this.serverAddress + ':' + httpPort + WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, deployment, "context-root"));
                    }
                } else if (applicationName.endsWith(".ear") && WildflyManagementAPI.modelNodeIsDefined(cl, subdeployment = WildflyManagementAPI.getModelNodeChild(cl, result, "subdeployment"))) {
                    for (Object node : WildflyManagementAPI.modelNodeAsList(cl, subdeployment)) {
                        Object deployment;
                        Object child = WildflyManagementAPI.getModelNodeChildAtIndex(cl, node, 0);
                        if (!WildflyManagementAPI.modelNodeIsDefined(cl, child) || !WildflyManagementAPI.modelNodeIsDefined(cl, deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, child, "subsystem"), WEB_SUBSYSTEM))) continue;
                        return "http://" + this.serverAddress + ':' + httpPort + WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, deployment, "context-root"));
                    }
                }
            }
            return "";
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public Collection<WildflyEjbModuleNode> listEJBModules(Lookup lookup) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyEjbModuleNode> modules = new ArrayList<WildflyEjbModuleNode>();
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, null);
            Object readDeployments = WildflyManagementAPI.createReadResourceOperation(cl, deploymentAddressModelNode, true);
            Object response = this.executeOnModelNode(cl, readDeployments);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object result = WildflyManagementAPI.readResult(cl, response);
                List ejbs = WildflyManagementAPI.modelNodeAsList(cl, result);
                for (Object ejb : ejbs) {
                    Object deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, ejb), "subsystem"), EJB3_SUBSYSTEM);
                    if (!WildflyManagementAPI.modelNodeIsDefined(cl, deployment)) continue;
                    ArrayList<WildflyEjbComponentNode> ejbInstances = new ArrayList<WildflyEjbComponentNode>();
                    ejbInstances.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.ENTITY));
                    ejbInstances.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.MDB));
                    ejbInstances.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.SINGLETON));
                    ejbInstances.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.STATEFULL));
                    ejbInstances.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.STATELESS));
                    modules.add(new WildflyEjbModuleNode(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, ejb), "name")), lookup, ejbInstances, true));
                }
            }
            return modules;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public boolean startModule(WildflyTargetModuleID tmid) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, tmid.getModuleID());
            Object enableDeployment = WildflyManagementAPI.createOperation(cl, "redeploy", deploymentAddressModelNode);
            Object result = this.executeOnModelNode(cl, enableDeployment);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, result)) {
                tmid.setContextURL(this.getWebModuleURL(tmid.getModuleID()));
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public boolean startModule(String moduleName) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, moduleName);
            Object enableDeployment = WildflyManagementAPI.createOperation(cl, "redeploy", deploymentAddressModelNode);
            Object result = this.executeOnModelNode(cl, enableDeployment);
            return WildflyManagementAPI.isSuccessfulOutcome(cl, result);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public boolean stopModule(String moduleName) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, moduleName);
            Object enableDeployment = WildflyManagementAPI.createOperation(cl, "undeploy", deploymentAddressModelNode);
            return WildflyManagementAPI.isSuccessfulOutcome(cl, this.executeOnModelNode(cl, enableDeployment));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public boolean undeploy(String fileName) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, fileName);
            Object undeploy = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, undeploy, "operation"), "composite");
            WildflyManagementAPI.setModelNodeChildEmptyList(cl, WildflyManagementAPI.getModelNodeChild(cl, undeploy, "address"));
            Object steps = WildflyManagementAPI.getModelNodeChild(cl, undeploy, "steps");
            WildflyManagementAPI.addModelNodeChild(cl, steps, WildflyManagementAPI.createOperation(cl, "undeploy", deploymentAddressModelNode));
            WildflyManagementAPI.addModelNodeChild(cl, steps, WildflyManagementAPI.createRemoveOperation(cl, deploymentAddressModelNode));
            return WildflyManagementAPI.isSuccessfulOutcome(cl, this.executeOnModelNode(cl, undeploy));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public boolean deploy(DeploymentContext deployment) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            String fileName = deployment.getModuleFile().getName();
            this.undeploy(fileName);
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, fileName);
            Object deploy = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, deploy, "operation"), "composite");
            WildflyManagementAPI.setModelNodeChildEmptyList(cl, WildflyManagementAPI.getModelNodeChild(cl, deploy, "address"));
            Object steps = WildflyManagementAPI.getModelNodeChild(cl, deploy, "steps");
            Object addModule = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, addModule, "operation"), "add");
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChildAtPath(cl, addModule, new Object[]{"address", "deployment"}), fileName);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, addModule, "runtime-name"), fileName);
            WildflyManagementAPI.setModelNodeChildBytes(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChildAtIndex(cl, WildflyManagementAPI.getModelNodeChild(cl, addModule, "content"), 0), "bytes"), deployment.getModule().getArchive().asBytes());
            WildflyManagementAPI.addModelNodeChild(cl, steps, addModule);
            WildflyManagementAPI.addModelNodeChild(cl, steps, WildflyManagementAPI.createOperation(cl, "redeploy", deploymentAddressModelNode));
            Object result = this.executeOnModelNode(cl, deploy);
            return WildflyManagementAPI.isSuccessfulOutcome(cl, result);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public Collection<WildflyDatasourceNode> listDatasources(Lookup lookup) throws IOException {
        Set<Datasource> datasources = this.listDatasources();
        ArrayList<WildflyDatasourceNode> modules = new ArrayList<WildflyDatasourceNode>(datasources.size());
        for (Datasource ds : datasources) {
            modules.add(new WildflyDatasourceNode(((WildflyDatasource)ds).getName(), ds, lookup));
        }
        return modules;
    }

    private Set<Datasource> listDatasources() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            HashSet<Datasource> listedDatasources = new HashSet<Datasource>();
            Object readDatasources = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasources, "operation"), "read-children-names");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", DATASOURCES_SUBSYSTEM);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasources, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasources, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasources, "child-type"), DATASOURCE_TYPE);
            Object response = this.executeOnModelNode(cl, readDatasources);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List names = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object datasourceName : names) {
                    listedDatasources.add(this.getDatasource(cl, WildflyManagementAPI.modelNodeAsString(cl, datasourceName)));
                }
            }
            return listedDatasources;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private WildflyDatasource getDatasource(WildflyDeploymentFactory.WildFlyClassLoader cl, String name) throws IOException {
        try {
            Object readDatasource = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasource, "operation"), "read-resource");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", DATASOURCES_SUBSYSTEM);
            values.put(DATASOURCE_TYPE, name);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasource, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readDatasource, "recursive-depth"), 0);
            Object response = this.executeOnModelNode(cl, readDatasource);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object datasource = WildflyManagementAPI.readResult(cl, response);
                return new WildflyDatasource(name, WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, datasource, "jndi-name")), WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, datasource, "connection-url")), WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, datasource, "user-name")), WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, datasource, "password")), WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, datasource, "driver-class")));
            }
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private Pair<String, String> getServerPaths(WildflyDeploymentFactory.WildFlyClassLoader cl) {
        try {
            Object readEnvironment = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readEnvironment, "operation"), "read-resource");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("core-service", SERVER_ENVIRONMENT);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readEnvironment, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readEnvironment, "include-runtime"), true);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readEnvironment, "include-defaults"), true);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readEnvironment, "attributes-only"), true);
            Object response = this.executeOnModelNode(cl, readEnvironment);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object environment = WildflyManagementAPI.readResult(cl, response);
                String homeDir = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, environment, "home-dir"));
                String configDir = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, environment, "config-file"));
                if (homeDir != null && configDir != null) {
                    return Pair.of((Object)FileUtil.normalizePath((String)homeDir), (Object)FileUtil.normalizePath((String)configDir));
                }
            }
            return null;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            return null;
        }
    }

    public Collection<WildflyDestinationNode> listDestinations(Lookup lookup) throws IOException {
        List<MessageDestination> destinations = this.listDestinations();
        ArrayList<WildflyDestinationNode> modules = new ArrayList<WildflyDestinationNode>(destinations.size());
        for (MessageDestination destination : destinations) {
            modules.add(new WildflyDestinationNode(destination.getName(), destination, lookup));
        }
        return modules;
    }

    public List<WildflyDestinationNode> listDestinationForDeployment(Lookup lookup, String jeeDeploymentName) throws IOException {
        List<MessageDestination> destinations = this.listDestinationForDeployment(jeeDeploymentName);
        ArrayList<WildflyDestinationNode> modules = new ArrayList<WildflyDestinationNode>(destinations.size());
        for (MessageDestination destination : destinations) {
            modules.add(new WildflyDestinationNode(destination.getName(), destination, lookup));
        }
        return modules;
    }

    public List<MessageDestination> listDestinationForDeployment(String deployment) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<MessageDestination> destinations = new ArrayList<MessageDestination>();
            Object readHornetQServers = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "operation"), "read-children-names");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("deployment", deployment);
            values.put("subsystem", this.getMessagingSubsystem());
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "child-type"), this.getMessagingServerType());
            Object response = this.executeOnModelNode(cl, readHornetQServers);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List names = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object hornetqServer : names) {
                    String hornetqServerName = WildflyManagementAPI.modelNodeAsString(cl, hornetqServer);
                    destinations.addAll(this.getJMSDestinationForServerDeployment(deployment, hornetqServerName, MessageDestination.Type.QUEUE));
                    destinations.addAll(this.getJMSDestinationForServerDeployment(deployment, hornetqServerName, MessageDestination.Type.TOPIC));
                }
            }
            return destinations;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public List<MessageDestination> listDestinations() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<MessageDestination> destinations = new ArrayList<MessageDestination>();
            Object readHornetQServers = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "operation"), "read-children-names");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", this.getMessagingSubsystem());
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "child-type"), this.getMessagingServerType());
            Object response = this.executeOnModelNode(cl, readHornetQServers);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List names = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object hornetqServer : names) {
                    String hornetqServerName = WildflyManagementAPI.modelNodeAsString(cl, hornetqServer);
                    destinations.addAll(this.getJMSDestinationForServer(hornetqServerName, MessageDestination.Type.QUEUE));
                    destinations.addAll(this.getJMSDestinationForServer(hornetqServerName, MessageDestination.Type.TOPIC));
                }
            }
            return destinations;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private List<WildflyMessageDestination> getJMSDestinationForServerDeployment(String deployment, String serverName, MessageDestination.Type messageType) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyMessageDestination> listedDestinations = new ArrayList<WildflyMessageDestination>();
            Object readQueues = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "operation"), "read-children-resources");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("deployment", deployment);
            values.put("subsystem", this.getMessagingSubsystem());
            values.put(this.getMessagingServerType(), serverName);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "recursive-depth"), 0);
            if (messageType == MessageDestination.Type.QUEUE) {
                WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "child-type"), JMSQUEUE_TYPE);
            } else {
                WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "child-type"), JMSTOPIC_TYPE);
            }
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "include-runtime"), "true");
            Object response = this.executeOnModelNode(cl, readQueues);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List destinations = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object destination : destinations) {
                    Object value = WildflyManagementAPI.modelNodeAsPropertyForValue(cl, destination);
                    if (WildflyManagementAPI.modelNodeHasChild(cl, value, "entries")) {
                        List entries = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.modelNodeAsPropertyForValue(cl, destination), "entries"));
                        for (Object entry : entries) {
                            listedDestinations.add(new WildflyMessageDestination(WildflyManagementAPI.modelNodeAsString(cl, entry), messageType));
                        }
                        continue;
                    }
                    listedDestinations.add(new WildflyMessageDestination(WildflyManagementAPI.modelNodeAsPropertyForName(cl, destination), messageType));
                }
            }
            return listedDestinations;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private List<WildflyMessageDestination> getJMSDestinationForServer(String serverName, MessageDestination.Type messageType) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyMessageDestination> listedDestinations = new ArrayList<WildflyMessageDestination>();
            Object readQueues = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "operation"), "read-children-resources");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", this.getMessagingSubsystem());
            values.put(this.getMessagingServerType(), serverName);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "recursive-depth"), 0);
            if (messageType == MessageDestination.Type.QUEUE) {
                WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "child-type"), JMSQUEUE_TYPE);
            } else {
                WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readQueues, "child-type"), JMSTOPIC_TYPE);
            }
            Object response = this.executeOnModelNode(cl, readQueues);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List destinations = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object destination : destinations) {
                    Object value = WildflyManagementAPI.modelNodeAsPropertyForValue(cl, destination);
                    if (WildflyManagementAPI.modelNodeHasChild(cl, value, "entries")) {
                        List entries = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.modelNodeAsPropertyForValue(cl, destination), "entries"));
                        for (Object entry : entries) {
                            listedDestinations.add(new WildflyMessageDestination(WildflyManagementAPI.modelNodeAsString(cl, entry), messageType));
                        }
                        continue;
                    }
                    listedDestinations.add(new WildflyMessageDestination(WildflyManagementAPI.modelNodeAsPropertyForName(cl, destination), messageType));
                }
            }
            return listedDestinations;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public boolean addMessageDestinations(Collection<WildflyMessageDestination> destinations, InstanceProperties ip) throws IOException {
        boolean result = this.isServerRunning(ip.getProperty("root-dir"), ip.getProperty("config_file"));
        if (result) {
            for (WildflyMessageDestination destination : destinations) {
                result = result && this.addMessageDestination(destination);
            }
        }
        return result;
    }

    public boolean addMessageDestination(WildflyMessageDestination destination) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", this.getMessagingSubsystem());
            values.put(HORNETQ_SERVER_TYPE, "default");
            if (destination.getType() == MessageDestination.Type.QUEUE) {
                values.put(JMSQUEUE_TYPE, destination.getName());
            } else {
                values.put(JMSTOPIC_TYPE, destination.getName());
            }
            Object address = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            Object operation = WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.createAddOperation(cl, address), "entries"), destination.getJndiNames());
            Object response = this.executeOnOperation(cl, operation);
            return WildflyManagementAPI.isSuccessfulOutcome(cl, response);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            return false;
        }
    }

    public Collection<WildflyJaxrsResourceNode> listJaxrsResources(Lookup lookup, String deployment) throws IOException {
        Collection<WildflyJaxrsResource> jaxrsResources = this.listJaxrsResources(deployment);
        ArrayList<WildflyJaxrsResourceNode> modules = new ArrayList<WildflyJaxrsResourceNode>(jaxrsResources.size());
        for (WildflyJaxrsResource jaxrsResource : jaxrsResources) {
            modules.add(new WildflyJaxrsResourceNode(jaxrsResource, lookup));
        }
        return modules;
    }

    private Collection<WildflyJaxrsResource> listJaxrsResources(String deployment) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            HashMap<String, WildflyJaxrsResource> jaxrsResources = new HashMap<String, WildflyJaxrsResource>();
            Object readJaxrsResources = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readJaxrsResources, "operation"), "show-resources");
            LinkedHashMap<Object, Object> address = new LinkedHashMap<Object, Object>();
            address.put("deployment", deployment);
            address.put("subsystem", "jaxrs");
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, address);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readJaxrsResources, "address"), path);
            Object response = this.executeOnModelNode(cl, readJaxrsResources);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                String serverUrl = "http://" + this.serverAddress + ':' + this.ip.getProperty("port");
                List names = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object jaxrsResource : names) {
                    String resourceClass = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, jaxrsResource, "resource-class"));
                    String resourcePath = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, jaxrsResource, "resource-path"));
                    List methods = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.getModelNodeChild(cl, jaxrsResource, "resource-methods"));
                    String key = resourceClass + "___" + resourcePath;
                    if (jaxrsResources.containsKey(key)) {
                        ((WildflyJaxrsResource)jaxrsResources.get(key)).addMethods(methods);
                        continue;
                    }
                    jaxrsResources.put(key, new WildflyJaxrsResource(resourceClass, resourcePath, serverUrl, methods));
                }
            }
            return jaxrsResources.values();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public Collection<WildflyMailSessionResource> listMailSessions() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyMailSessionResource> modules = new ArrayList<WildflyMailSessionResource>();
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", MAIL_SUBSYSTEM);
            Object address = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            Object readMailSessions = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readMailSessions, "operation"), "read-children-resources");
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readMailSessions, "address"), address);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readMailSessions, "child-type"), MAIL_SESSION_TYPE);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readMailSessions, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readMailSessions, "include-runtime"), "true");
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readMailSessions, "recursive"), "true");
            Object response = this.executeOnModelNode(cl, readMailSessions);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object result = WildflyManagementAPI.readResult(cl, response);
                List mailSessions = WildflyManagementAPI.modelNodeAsList(cl, result);
                for (Object mailSession : mailSessions) {
                    String sessionName = WildflyManagementAPI.modelNodeAsPropertyForName(cl, mailSession);
                    modules.add(this.fillMailSession(sessionName, mailSession));
                }
            }
            return modules;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public Collection listEarApplications(Lookup lookup) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyEarApplicationNode> modules = new ArrayList<WildflyEarApplicationNode>();
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, null);
            Object readDeployments = WildflyManagementAPI.createReadResourceOperation(cl, deploymentAddressModelNode, true);
            Object response = this.executeOnModelNode(cl, readDeployments);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object result = WildflyManagementAPI.readResult(cl, response);
                List applications = WildflyManagementAPI.modelNodeAsList(cl, result);
                for (Object application : applications) {
                    String applicationName = WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.readResult(cl, application), "name"));
                    if (!applicationName.endsWith(".ear")) continue;
                    modules.add(new WildflyEarApplicationNode(applicationName, lookup));
                }
            }
            return modules;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    public Collection listEarSubModules(Lookup lookup, String jeeApplicationName) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<AbstractNode> modules = new ArrayList<AbstractNode>();
            Object deploymentAddressModelNode = WildflyManagementAPI.createDeploymentPathAddressAsModelNode(cl, jeeApplicationName);
            Object readDeployments = WildflyManagementAPI.createReadResourceOperation(cl, deploymentAddressModelNode, true);
            Object response = this.executeOnModelNode(cl, readDeployments);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                String httpPort = this.ip.getProperty("port");
                Object result = WildflyManagementAPI.readResult(cl, response);
                List subDeployments = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.getModelNodeChild(cl, result, "subdeployment"));
                for (Object subDeployment : subDeployments) {
                    Object deployment;
                    String applicationName = WildflyManagementAPI.modelNodeAsPropertyForName(cl, subDeployment);
                    if (applicationName.endsWith(".war")) {
                        deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.modelNodeAsPropertyForValue(cl, subDeployment), "subsystem"), WEB_SUBSYSTEM);
                        if (WildflyManagementAPI.modelNodeIsDefined(cl, deployment)) {
                            String url = "http://" + this.serverAddress + ':' + httpPort + WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, deployment, "context-root"));
                            modules.add(new WildflyWebModuleNode(applicationName, lookup, url));
                            continue;
                        }
                        modules.add(new WildflyWebModuleNode(applicationName, lookup, null));
                        continue;
                    }
                    if (!applicationName.endsWith(".jar") || !WildflyManagementAPI.modelNodeIsDefined(cl, deployment = WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, WildflyManagementAPI.modelNodeAsPropertyForValue(cl, subDeployment), "subsystem"), EJB3_SUBSYSTEM))) continue;
                    ArrayList<WildflyEjbComponentNode> ejbs = new ArrayList<WildflyEjbComponentNode>();
                    ejbs.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.ENTITY));
                    ejbs.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.MDB));
                    ejbs.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.SINGLETON));
                    ejbs.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.STATEFULL));
                    ejbs.addAll(this.listEJBs(cl, deployment, WildflyEjbComponentNode.Type.STATELESS));
                    modules.add(new WildflyEjbModuleNode(applicationName, lookup, ejbs, true));
                }
            }
            return modules;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private List<WildflyEjbComponentNode> listEJBs(WildflyDeploymentFactory.WildFlyClassLoader cl, Object deployment, WildflyEjbComponentNode.Type type) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<WildflyEjbComponentNode> modules = new ArrayList<WildflyEjbComponentNode>();
        if (WildflyManagementAPI.modelNodeHasDefinedChild(cl, deployment, type.getPropertyName())) {
            List ejbs = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.getModelNodeChild(cl, deployment, type.getPropertyName()));
            for (Object ejb : ejbs) {
                modules.add(new WildflyEjbComponentNode(WildflyManagementAPI.modelNodeAsPropertyForName(cl, ejb), type));
            }
        }
        return modules;
    }

    private WildflySocket fillSocket(String name, boolean outBound) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, IOException {
        WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
        WildflySocket socket = new WildflySocket();
        LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
        values.put("socket-binding-group", "standard-sockets");
        if (outBound) {
            values.put("remote-destination-outbound-socket-binding", name);
        } else {
            values.put("socket-binding", name);
        }
        Object address = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
        Object readSocket = WildflyManagementAPI.createModelNode(cl);
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readSocket, "operation"), "read-resource");
        WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readSocket, "address"), address);
        WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readSocket, "recursive-depth"), 0);
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readSocket, "include-runtime"), "true");
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readSocket, "recursive"), "true");
        Object response = this.executeOnModelNode(cl, readSocket);
        if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
            Object binding = WildflyManagementAPI.readResult(cl, response);
            if (WildflyManagementAPI.modelNodeHasDefinedChild(cl, binding, "fixed-source-port")) {
                socket.setFixedSourcePort(WildflyManagementAPI.modelNodeAsBoolean(cl, WildflyManagementAPI.getModelNodeChild(cl, binding, "fixed-source-port")));
            }
            if (WildflyManagementAPI.modelNodeHasDefinedChild(cl, binding, "host")) {
                socket.setHost(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, binding, "host")));
            }
            if (WildflyManagementAPI.modelNodeHasDefinedChild(cl, binding, "port")) {
                socket.setPort(WildflyManagementAPI.modelNodeAsInt(cl, WildflyManagementAPI.getModelNodeChild(cl, binding, "port")));
            }
        }
        return socket;
    }

    public Collection<WildflyConnectionFactory> listConnectionFactories() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyConnectionFactory> connectionFactories = new ArrayList<WildflyConnectionFactory>();
            Object readHornetQServers = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "operation"), "read-children-names");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", this.getMessagingSubsystem());
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readHornetQServers, "child-type"), this.getMessagingServerType());
            Object response = this.executeOnModelNode(cl, readHornetQServers);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List names = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object hornetqServer : names) {
                    String hornetqServerName = WildflyManagementAPI.modelNodeAsString(cl, hornetqServer);
                    connectionFactories.addAll(this.getConnectionFactoriesForServer(hornetqServerName));
                }
            }
            return connectionFactories;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private Collection<? extends WildflyConnectionFactory> getConnectionFactoriesForServer(String hornetqServerName) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyConnectionFactory> listedConnectionFactories = new ArrayList<WildflyConnectionFactory>();
            Object readConnectionFactories = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readConnectionFactories, "operation"), "read-children-resources");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", this.getMessagingSubsystem());
            values.put(this.getMessagingServerType(), hornetqServerName);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readConnectionFactories, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readConnectionFactories, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readConnectionFactories, "child-type"), CONNECTION_FACTORY_TYPE);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readConnectionFactories, "include-runtime"), "true");
            Object response = this.executeOnModelNode(cl, readConnectionFactories);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List connectionFactories = WildflyManagementAPI.modelNodeAsPropertyList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object connectionFactory : connectionFactories) {
                    listedConnectionFactories.add(this.fillConnectionFactory(WildflyManagementAPI.getPropertyName(cl, connectionFactory), WildflyManagementAPI.getPropertyValue(cl, connectionFactory)));
                }
            }
            return listedConnectionFactories;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private WildflyConnectionFactory fillConnectionFactory(String name, Object configuration) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, IOException {
        WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
        List properties = WildflyManagementAPI.modelNodeAsPropertyList(cl, configuration);
        HashMap<String, String> attributes = new HashMap<String, String>(properties.size());
        for (Object property : properties) {
            String propertyName = WildflyManagementAPI.getPropertyName(cl, property);
            Object propertyValue = WildflyManagementAPI.getPropertyValue(cl, property);
            if (!WildflyManagementAPI.modelNodeIsDefined(cl, propertyValue)) continue;
            attributes.put(propertyName, WildflyManagementAPI.modelNodeAsString(cl, propertyValue));
        }
        return new WildflyConnectionFactory(attributes, name);
    }

    private WildflyMailSessionResource fillMailSession(String name, Object mailSession) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, IOException {
        WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
        Object configuration = WildflyManagementAPI.modelNodeAsPropertyForValue(cl, mailSession);
        List properties = WildflyManagementAPI.modelNodeAsPropertyList(cl, configuration);
        HashMap<String, String> attributes = new HashMap<String, String>(properties.size());
        for (Object property : properties) {
            String propertyName = WildflyManagementAPI.getPropertyName(cl, property);
            Object propertyValue = WildflyManagementAPI.getPropertyValue(cl, property);
            if ("debug".equals(propertyName) || "jndi-name".equals(propertyName) || !WildflyManagementAPI.modelNodeIsDefined(cl, propertyValue)) continue;
            attributes.put(propertyName, WildflyManagementAPI.modelNodeAsString(cl, propertyValue));
        }
        WildflyMailSessionResource session = new WildflyMailSessionResource(attributes, name);
        List serverProperties = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.getModelNodeChild(cl, configuration, MESSAGING_ACTIVEMQ_SERVER_TYPE));
        for (Object property : serverProperties) {
            if (!WildflyManagementAPI.modelNodeIsDefined(cl, property)) continue;
            Object settings = WildflyManagementAPI.modelNodeAsPropertyForValue(cl, property);
            if (WildflyManagementAPI.modelNodeHasDefinedChild(cl, settings, "username")) {
                session.setUserName(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, settings, "username")));
            }
            if (!WildflyManagementAPI.modelNodeHasDefinedChild(cl, settings, "outbound-socket-binding-ref")) continue;
            session.setSocket(this.fillSocket(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, settings, "outbound-socket-binding-ref")), true));
        }
        session.setIsDebug(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, configuration, "debug")));
        session.setJndiName(WildflyManagementAPI.modelNodeAsString(cl, WildflyManagementAPI.getModelNodeChild(cl, configuration, "jndi-name")));
        return session;
    }

    public String getDeploymentDirectory() throws IOException {
        WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
        LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
        values.put("subsystem", "deployment-scanner");
        values.put("scanner", "default");
        return this.resolvePath(cl, values);
    }

    private String resolveExpression(String unresolvedString) throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            Object resolveExpression = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, resolveExpression, "operation"), "resolve-expression");
            Object rootAddress = WildflyManagementAPI.createPathAddressAsModelNode(cl, new LinkedHashMap<Object, Object>());
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, resolveExpression, "address"), rootAddress);
            String testedExpression = unresolvedString.startsWith("${") && unresolvedString.endsWith("}") ? unresolvedString : "${" + unresolvedString + "}";
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, resolveExpression, "expression"), testedExpression);
            Object response = this.executeOnModelNode(cl, resolveExpression);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                Object resolvedExpression = WildflyManagementAPI.readResult(cl, response);
                return WildflyManagementAPI.modelNodeAsString(cl, resolvedExpression);
            }
            return unresolvedString;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private void enableExplodedDeployment(String scannerName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, IOException {
        WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
        LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
        values.put("subsystem", "deployment-scanner");
        values.put("scanner", scannerName);
        Object updateDeploymentScanner = WildflyManagementAPI.createModelNode(cl);
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, updateDeploymentScanner, "operation"), "write-attribute");
        Object scannerAddress = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
        WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, updateDeploymentScanner, "address"), scannerAddress);
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, updateDeploymentScanner, "include-runtime"), "true");
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, updateDeploymentScanner, "name"), "auto-deploy-exploded");
        WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, updateDeploymentScanner, "value"), "true");
        this.executeOnModelNode(cl, updateDeploymentScanner);
    }

    public Collection<WildflyResourceAdapter> listResourceAdapters() throws IOException {
        try {
            WildflyDeploymentFactory.WildFlyClassLoader cl = WildflyDeploymentFactory.getInstance().getWildFlyClassLoader(this.ip);
            ArrayList<WildflyResourceAdapter> resourceAdapters = new ArrayList<WildflyResourceAdapter>();
            Object readResourceAdapters = WildflyManagementAPI.createModelNode(cl);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readResourceAdapters, "operation"), "read-children-resources");
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            values.put("subsystem", RESOURCE_ADAPTER_SUBSYSTEM);
            Object path = WildflyManagementAPI.createPathAddressAsModelNode(cl, values);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readResourceAdapters, "address"), path);
            WildflyManagementAPI.setModelNodeChild(cl, WildflyManagementAPI.getModelNodeChild(cl, readResourceAdapters, "recursive-depth"), 0);
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readResourceAdapters, "include-runtime"), "true");
            WildflyManagementAPI.setModelNodeChildString(cl, WildflyManagementAPI.getModelNodeChild(cl, readResourceAdapters, "child-type"), RESOURCE_ADAPTER_TYPE);
            Object response = this.executeOnModelNode(cl, readResourceAdapters);
            if (WildflyManagementAPI.isSuccessfulOutcome(cl, response)) {
                List ressources = WildflyManagementAPI.modelNodeAsList(cl, WildflyManagementAPI.readResult(cl, response));
                for (Object resource : ressources) {
                    Object configuration = WildflyManagementAPI.modelNodeAsPropertyForValue(cl, resource);
                    List properties = WildflyManagementAPI.modelNodeAsPropertyList(cl, configuration);
                    HashMap<String, String> attributes = new HashMap<String, String>(properties.size());
                    for (Object property : properties) {
                        String propertyName = WildflyManagementAPI.getPropertyName(cl, property);
                        Object propertyValue = WildflyManagementAPI.getPropertyValue(cl, property);
                        if (!WildflyManagementAPI.modelNodeIsDefined(cl, propertyValue)) continue;
                        attributes.put(propertyName, WildflyManagementAPI.modelNodeAsString(cl, propertyValue));
                    }
                    WildflyResourceAdapter resourceAdapter = new WildflyResourceAdapter(attributes, WildflyManagementAPI.modelNodeAsPropertyForName(cl, resource));
                    resourceAdapters.add(resourceAdapter);
                }
            }
            return resourceAdapters;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }

    private String getMessagingSubsystem() {
        if (this.version.compareTo(WildflyPluginUtils.WILDFLY_10_0_0) >= 0) {
            return MESSAGING_ACTIVEMQ_SUBSYSTEM;
        }
        return MESSAGING_SUBSYSTEM;
    }

    private String getMessagingServerType() {
        if (this.version.compareTo(WildflyPluginUtils.WILDFLY_10_0_0) >= 0) {
            return MESSAGING_ACTIVEMQ_SERVER_TYPE;
        }
        return HORNETQ_SERVER_TYPE;
    }
}

