/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Image;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.javaee.wildfly.nodes.AbstractStateNode;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyDeploymentChildren;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyEarApplicationNode;
import org.netbeans.modules.javaee.wildfly.nodes.actions.OpenURLAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.OpenURLActionCookie;
import org.netbeans.modules.javaee.wildfly.nodes.actions.StartModuleAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.StartModuleCookieImpl;
import org.netbeans.modules.javaee.wildfly.nodes.actions.StopModuleAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.StopModuleCookieImpl;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleCookieImpl;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class WildflyWebModuleNode
extends AbstractStateNode {
    private final String url;

    public WildflyWebModuleNode(String fileName, Lookup lookup, String url) {
        super((Children)new WildflyDeploymentChildren(lookup, fileName));
        this.setDisplayName(fileName.substring(0, fileName.lastIndexOf(46)));
        this.url = url;
        this.getCookieSet().add((Node.Cookie)new UndeployModuleCookieImpl(fileName, ModuleType.WAR, lookup));
        this.getCookieSet().add((Node.Cookie)new StartModuleCookieImpl(fileName, lookup));
        this.getCookieSet().add((Node.Cookie)new StopModuleCookieImpl(fileName, lookup));
        if (url != null) {
            this.getCookieSet().add((Node.Cookie)new OpenURLActionCookieImpl(url));
        }
    }

    public Action[] getActions(boolean context) {
        if (this.getParentNode() instanceof WildflyEarApplicationNode) {
            if (this.url != null) {
                return new SystemAction[]{SystemAction.get(OpenURLAction.class)};
            }
            return new SystemAction[0];
        }
        if (this.url != null) {
            return new SystemAction[]{SystemAction.get(OpenURLAction.class), SystemAction.get(StopModuleAction.class), SystemAction.get(UndeployModuleAction.class)};
        }
        return new SystemAction[]{SystemAction.get(StartModuleAction.class), SystemAction.get(UndeployModuleAction.class)};
    }

    @Override
    public Image getOriginalIcon(int type) {
        return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_ARCHIVE);
    }

    @Override
    public Image getOriginalOpenedIcon(int type) {
        return this.getIcon(type);
    }

    @Override
    protected boolean isRunning() {
        return this.url != null;
    }

    @Override
    protected boolean isWaiting() {
        return this.url == null;
    }

    private static class OpenURLActionCookieImpl
    implements OpenURLActionCookie {
        private final String url;

        public OpenURLActionCookieImpl(String url) {
            this.url = url;
        }

        @Override
        public String getWebURL() {
            return this.url;
        }
    }
}

