/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryImpl;
import org.netbeans.modules.remote.impl.fs.DirEntryInvalid;
import org.netbeans.modules.remote.impl.fs.FormatException;

public class DirectoryStorage {
    public static final DirectoryStorage EMPTY = new DirectoryStorage(null, (Collection)Collections.emptyList()){

        @Override
        public void store() throws IOException {
            RemoteLogger.assertTrueInConsole(false, "EMPTY.store() is called!", new Object[0]);
        }

        @Override
        public void touch() throws IOException {
            RemoteLogger.assertTrueInConsole(false, "EMPTY.touch() is called!", new Object[0]);
        }

        @Override
        public String toString() {
            return "EMPTY DirectoryStorage";
        }
    };
    private final Map<String, DirEntry> entries;
    private final File cacheFile;
    private static final int VERSION = 7;
    private static final int ODD_VERSION = 6;

    public DirectoryStorage(File file, Collection<DirEntry> newEntries) {
        this.cacheFile = file;
        this.entries = new HashMap<String, DirEntry>();
        for (DirEntry entry : newEntries) {
            this.entries.put(entry.getName(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryStorage load(File storageFile, ExecutionEnvironment env) throws IOException, FormatException {
        try (BufferedReader br = null;){
            int invalidsCount;
            int version;
            br = new BufferedReader(new FileReader(storageFile));
            String line = br.readLine();
            String prefix = "VERSION=";
            if (line == null || !line.startsWith(prefix)) {
                throw new FormatException("Wrong file format " + storageFile.getAbsolutePath() + " line " + line, false);
            }
            try {
                version = Integer.parseInt(line.substring(prefix.length()));
            }
            catch (NumberFormatException nfe) {
                throw new FormatException("wrong version format " + storageFile.getAbsolutePath(), nfe);
            }
            if (version > 7) {
                throw new FormatException("directory cache file version " + version + " not supported: " + storageFile.getAbsolutePath(), true);
            }
            if (version <= 6) {
                throw new FormatException("Discarding old directory cache file version " + version + ' ' + storageFile.getAbsolutePath(), true);
            }
            line = br.readLine();
            prefix = "dummies=";
            if (line == null || !line.startsWith(prefix)) {
                throw new FormatException("Wrong file format " + storageFile.getAbsolutePath() + " line " + line, false);
            }
            try {
                invalidsCount = Integer.parseInt(line.substring(prefix.length()));
            }
            catch (NumberFormatException nfe) {
                throw new FormatException("wrong dummies count format " + storageFile.getAbsolutePath(), nfe);
            }
            ArrayList<DirEntry> loadedEntries = new ArrayList<DirEntry>();
            for (int i = 0; i < invalidsCount; ++i) {
                line = br.readLine();
                if (line == null) {
                    throw new FormatException("premature end of file " + storageFile.getAbsolutePath(), false);
                }
                loadedEntries.add(new DirEntryInvalid(line));
            }
            while ((line = br.readLine()) != null) {
                if (line.length() == 0) continue;
                try {
                    DirEntryImpl entry = DirEntryImpl.fromExternalForm(line);
                    loadedEntries.add(entry);
                }
                catch (FormatException fe) {
                    RemoteLogger.getInstance().log(Level.INFO, "Error loading cache file " + storageFile.getAbsolutePath(), fe);
                }
            }
            DirectoryStorage directoryStorage = new DirectoryStorage(storageFile, loadedEntries);
            return directoryStorage;
        }
    }

    public void touch() throws IOException {
        if (!this.cacheFile.exists()) {
            this.store();
            RemoteLogger.assertTrueInConsole(false, "Storage has been unexpectedly deleted: " + this.cacheFile.getAbsolutePath(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        BufferedWriter wr = null;
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            try {
                wr = new BufferedWriter(new FileWriter(this.cacheFile));
                wr.write("VERSION=7\n");
                ArrayList<DirEntry> invalid = new ArrayList<DirEntry>();
                ArrayList<DirEntry> valid = new ArrayList<DirEntry>();
                for (DirEntry entry : this.entries.values()) {
                    if (entry.isValid()) {
                        valid.add(entry);
                        continue;
                    }
                    invalid.add(entry);
                }
                wr.write("dummies=" + invalid.size() + '\n');
                for (DirEntry entry : invalid) {
                    wr.write(entry.toExternalForm());
                    wr.write(10);
                }
                for (DirEntry entry : valid) {
                    wr.write(entry.toExternalForm());
                    wr.write(10);
                }
                wr.close();
                wr = null;
            }
            finally {
                if (wr != null) {
                    wr.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirEntry getValidEntry(String fileName) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            DirEntry ret = this.entries.get(fileName);
            return ret == null || !ret.isValid() ? null : ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown(String fileName) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.containsKey(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirEntry> listAll() {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return new ArrayList<DirEntry>(this.entries.values());
        }
    }

    public List<DirEntry> listValid() {
        return this.listValid(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirEntry> listValid(String nameToSkip) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            ArrayList<DirEntry> result = new ArrayList<DirEntry>(this.entries.size());
            for (DirEntry entry : this.entries.values()) {
                if (!entry.isValid() || nameToSkip != null && nameToSkip.equals(entry.getName())) continue;
                result.add(entry);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAddEntry(DirEntry entry) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            this.entries.put(entry.getName(), entry);
        }
    }

    void testAddDummy(String dummy) {
        DirEntryInvalid entry = new DirEntryInvalid(dummy);
        this.testAddEntry(entry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DirectoryStorage");
        sb.append(" file=").append(this.cacheFile.getAbsolutePath());
        sb.append(" entries.size()=").append(this.entries.size()).append("\n");
        int cnt = 0;
        for (DirEntry entry : this.entries.values()) {
            if (cnt > 0) {
                sb.append('\n');
            }
            if (cnt++ <= 10) {
                sb.append(entry);
                continue;
            }
            sb.append("...");
            break;
        }
        return sb.toString();
    }
}

