/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WeakCache<K, V> {
    private final ConcurrentMap<K, Ref<K, V>> map = new ConcurrentHashMap<K, Ref<K, V>>();
    private final ReferenceQueue<V> referenceQueue = new ReferenceQueue();
    private final Lock lock = new ReentrantLock();

    public Collection<V> values() {
        ArrayList result = new ArrayList(this.map.size());
        for (Ref ref : this.map.values()) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public void remove(K key, V expected) {
        Ref expectedRef = new Ref(key, expected, this.referenceQueue);
        this.map.remove(key, expectedRef);
    }

    public void put(K key, V value) {
        Ref ref = new Ref(key, value, this.referenceQueue);
        this.map.put(key, ref);
    }

    public V get(K key) {
        Ref ref = (Ref)this.map.get(key);
        V result = ref == null ? null : (V)ref.get();
        return result;
    }

    public V remove(K key) {
        Ref removed = (Ref)this.map.remove(key);
        return removed == null ? null : (V)removed.get();
    }

    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCleaningDeadEntries() {
        if (this.lock.tryLock()) {
            try {
                Ref ref;
                while ((ref = (Ref)this.referenceQueue.poll()) != null) {
                    if (ref.key == null) continue;
                    Ref expectedRef = new Ref(ref.key, null, this.referenceQueue);
                    this.map.remove(ref.key, expectedRef);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class Ref<K, V>
    extends SoftReference<V> {
        private final K key;

        private Ref(K key, V value, ReferenceQueue<V> referenceQueue) {
            super(value, referenceQueue);
            this.key = key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)o;
            return Ref.equalsImpl(this.key, ref.key) && this.get() == ref.get();
        }

        public int hashCode() {
            Object value = this.get();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        private static boolean equalsImpl(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

