/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;

public class ActionsSynchronizer {
    private static final Logger logger = Logger.getLogger(ActionsSynchronizer.class.getName());
    private static final Map<JPDADebugger, ActionsSynchronizer> INSTANCES = new WeakHashMap<JPDADebugger, ActionsSynchronizer>();
    private static final Map<Object, Set<Object>> ACTIONS_WAITING_FOR_OTHERS = new HashMap<Object, Set<Object>>();
    private final List<Object> runningActions = new ArrayList<Object>();
    private final List<Object> scheduledActions = new ArrayList<Object>();

    private ActionsSynchronizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionsSynchronizer get(JPDADebugger debugger) {
        Map<JPDADebugger, ActionsSynchronizer> map = INSTANCES;
        synchronized (map) {
            ActionsSynchronizer as = INSTANCES.get(debugger);
            if (as == null) {
                as = new ActionsSynchronizer();
                INSTANCES.put(debugger, as);
            }
            return as;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionScheduled(Object action) {
        List<Object> list = this.runningActions;
        synchronized (list) {
            logger.log(Level.FINE, "actionScheduled({0})", action);
            this.scheduledActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionStarts(Object action) {
        List<Object> list = this.runningActions;
        synchronized (list) {
            logger.log(Level.FINE, "actionStarts({0})", action);
            this.scheduledActions.remove(action);
            Set<Object> waitingFor = ACTIONS_WAITING_FOR_OTHERS.get(action);
            if (waitingFor != null) {
                while (this.containsAny(this.scheduledActions, waitingFor) || this.containsAny(this.runningActions, waitingFor)) {
                    logger.log(Level.FINE, "action {0} is blocked.", action);
                    try {
                        this.runningActions.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            this.runningActions.add(action);
            logger.log(Level.FINE, "action {0} can proceed. Running actions = {1}", new Object[]{action, this.runningActions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionEnds(Object action) {
        List<Object> list = this.runningActions;
        synchronized (list) {
            this.runningActions.remove(action);
            logger.log(Level.FINE, "actionEnds({0}). Running actions = {1}", new Object[]{action, this.runningActions});
            this.runningActions.notifyAll();
        }
    }

    private boolean containsAny(List<Object> s1, Set<Object> s2) {
        for (Object o : s1) {
            if (!s2.contains(o)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<Object> actionsToWaitForBeforeResume = new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_TOGGLE_BREAKPOINT, ActionsManager.ACTION_FIX));
        ACTIONS_WAITING_FOR_OTHERS.put(ActionsManager.ACTION_CONTINUE, actionsToWaitForBeforeResume);
        ACTIONS_WAITING_FOR_OTHERS.put(ActionsManager.ACTION_STEP_INTO, actionsToWaitForBeforeResume);
        ACTIONS_WAITING_FOR_OTHERS.put(ActionsManager.ACTION_STEP_OPERATION, actionsToWaitForBeforeResume);
        ACTIONS_WAITING_FOR_OTHERS.put(ActionsManager.ACTION_STEP_OUT, actionsToWaitForBeforeResume);
        ACTIONS_WAITING_FOR_OTHERS.put(ActionsManager.ACTION_STEP_OVER, actionsToWaitForBeforeResume);
        ACTIONS_WAITING_FOR_OTHERS.put(ActionsManager.ACTION_RUN_TO_CURSOR, actionsToWaitForBeforeResume);
    }
}

